/*
 * Decompiled with CFR 0.152.
 */
package io.branch.indexing;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.PrefHelper;
import io.branch.referral.util.LinkProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class AppIndexingHelper {
    AppIndexingHelper() {
    }

    public static void addToAppIndex(final Context context, final BranchUniversalObject buo) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String urlForAppIndexing = buo.getShortUrl(context, new LinkProperties().setChannel("google_search"));
                if (!TextUtils.isEmpty((CharSequence)urlForAppIndexing)) {
                    try {
                        AppIndexingHelper.listOnGoogleSearch(urlForAppIndexing, context, buo);
                    }
                    catch (Throwable e) {
                        PrefHelper.Debug("BranchSDK", "Branch Warning: Unable to list your content in google search. Please make sure you have the latest google play libs added to your project");
                    }
                }
            }
        }).run();
    }

    private static void listOnGoogleSearch(String shortLink, Context context, BranchUniversalObject branchUniversalObject) throws Exception {
        Class<?> ThingClass = Class.forName("com.google.android.gms.appindexing.Thing");
        Class<?> ThingBuilderClass = Class.forName("com.google.android.gms.appindexing.Thing$Builder");
        Constructor<?> constructor = ThingBuilderClass.getConstructor(new Class[0]);
        Object thingBuilder = constructor.newInstance(new Object[0]);
        Method setNameMethod = ThingBuilderClass.getMethod("setName", String.class);
        Method setDescMethod = ThingBuilderClass.getMethod("setDescription", String.class);
        Method setUrlMethod = ThingBuilderClass.getMethod("setUrl", Uri.class);
        Method thingBuildMethod = ThingBuilderClass.getMethod("build", new Class[0]);
        setNameMethod.invoke(thingBuilder, branchUniversalObject.getTitle());
        setDescMethod.invoke(thingBuilder, branchUniversalObject.getDescription());
        setUrlMethod.invoke(thingBuilder, Uri.parse((String)shortLink));
        Object thingObj = thingBuildMethod.invoke(thingBuilder, new Object[0]);
        Class<?> ThingActionClass = Class.forName("com.google.android.gms.appindexing.Action");
        Class<?> ThingActionBuilderClass = Class.forName("com.google.android.gms.appindexing.Action$Builder");
        Constructor<?> thingActionBuilderConstructor = ThingActionBuilderClass.getConstructor(String.class);
        Object actionBuilder = thingActionBuilderConstructor.newInstance((String)ThingActionClass.getDeclaredField("TYPE_VIEW").get(null));
        Method setObjectMethod = ThingActionBuilderClass.getMethod("setObject", ThingClass);
        Method setActionStatusMethod = ThingActionBuilderClass.getMethod("setActionStatus", String.class);
        Method actionBuildMethod = ThingActionBuilderClass.getMethod("build", new Class[0]);
        setObjectMethod.invoke(actionBuilder, thingObj);
        setActionStatusMethod.invoke(actionBuilder, (String)ThingActionClass.getDeclaredField("STATUS_TYPE_COMPLETED").get(null));
        Object actionObj = actionBuildMethod.invoke(actionBuilder, new Object[0]);
        Class<?> AppIndexClass = Class.forName("com.google.android.gms.appindexing.AppIndex");
        Class<?> ApiClass = Class.forName("com.google.android.gms.common.api.Api");
        Class<?> GoogleApiClientClass = Class.forName("com.google.android.gms.common.api.GoogleApiClient");
        Class<?> GoogleApiClientBuilderClass = Class.forName("com.google.android.gms.common.api.GoogleApiClient$Builder");
        Constructor<?> googleApiClientBuilderConstructor = GoogleApiClientBuilderClass.getConstructor(Context.class);
        Object apiClientBuilder = googleApiClientBuilderConstructor.newInstance(context);
        Method addApiMethod = GoogleApiClientBuilderClass.getMethod("addApi", ApiClass);
        Method apiClientBuildMethod = GoogleApiClientBuilderClass.getMethod("build", new Class[0]);
        Method apiClientConnectMethod = GoogleApiClientClass.getMethod("connect", new Class[0]);
        Method apiClientDisConnectMethod = GoogleApiClientClass.getMethod("disconnect", new Class[0]);
        addApiMethod.invoke(apiClientBuilder, ApiClass.cast(AppIndexClass.getDeclaredField("API").get(null)));
        Object googleApiClientApiClientObj = apiClientBuildMethod.invoke(apiClientBuilder, new Object[0]);
        apiClientConnectMethod.invoke(googleApiClientApiClientObj, new Object[0]);
        Class<?> AppIndexApiClass = Class.forName("com.google.android.gms.appindexing.AppIndexApi");
        Object appIndexApiObj = AppIndexClass.getDeclaredField("AppIndexApi").get(null);
        Method startMethod = AppIndexApiClass.getMethod("start", GoogleApiClientClass, ThingActionClass);
        startMethod.invoke(appIndexApiObj, googleApiClientApiClientObj, actionObj);
        apiClientDisConnectMethod.invoke(googleApiClientApiClientObj, new Object[0]);
    }
}

