/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers.shim;

import com.crashlytics.android.answers.CustomEvent;
import java.util.HashMap;
import java.util.Map;

public class KitEvent {
    private final String eventName;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public KitEvent(String eventName) {
        this.eventName = eventName;
    }

    public KitEvent putAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public KitEvent putAttribute(String key, Number value) {
        this.attributes.put(key, value);
        return this;
    }

    CustomEvent toCustomEvent() {
        CustomEvent event = new CustomEvent(this.eventName);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            if (value instanceof String) {
                event.putCustomAttribute(key, (String)value);
                continue;
            }
            if (!(value instanceof Number)) continue;
            event.putCustomAttribute(key, (Number)value);
        }
        return event;
    }
}

