/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage;

import app.raybritton.tokenstorage.Optional;
import app.raybritton.tokenstorage.RxTokenWrapper;
import app.raybritton.tokenstorage.TokenStorage;
import app.raybritton.tokenstorage.crypto.Crypto;
import app.raybritton.tokenstorage.keyCrypto.KeyCrypto;
import app.raybritton.tokenstorage.persistence.Persistence;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.subjects.ReplaySubject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\u0006\u0010\n\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020\"J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000eJ\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100)2\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000eJ\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00180)J\u001a\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001b0)2\u0006\u0010#\u001a\u00020\u000eJ\u0010\u0010-\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0010\u0010/\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020\u000eJ\u0010\u00100\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0006\u00101\u001a\u00020\"J\u0006\u00102\u001a\u00020&J\u0016\u00103\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eJ\u0016\u00105\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eJ\u000e\u00106\u001a\u0002072\u0006\u0010#\u001a\u00020\u000eR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u0019*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00180\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001b0\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lapp/raybritton/tokenstorage/RxTokenStorage;", "C", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "P", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "KC", "Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "", "crypto", "persistence", "keyCrypto", "(Lapp/raybritton/tokenstorage/crypto/Crypto;Lapp/raybritton/tokenstorage/persistence/Persistence;Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;)V", "containSubjects", "", "", "Lio/reactivex/subjects/ReplaySubject;", "", "getCrypto", "()Lapp/raybritton/tokenstorage/crypto/Crypto;", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "getKeyCrypto", "()Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "keysSubject", "", "kotlin.jvm.PlatformType", "loadSubjects", "Lapp/raybritton/tokenstorage/Optional;", "getPersistence", "()Lapp/raybritton/tokenstorage/persistence/Persistence;", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "storage", "Lapp/raybritton/tokenstorage/TokenStorage;", "clear", "Lio/reactivex/Completable;", "key", "clearAll", "clearAllSync", "", "clearSync", "contains", "Lio/reactivex/Flowable;", "containsSync", "keys", "load", "loadContains", "loadString", "loadSync", "reload", "reset", "resetSync", "save", "plaintext", "saveSync", "wrap", "Lapp/raybritton/tokenstorage/RxTokenWrapper;", "rx_release"})
public final class RxTokenStorage<C extends Crypto, P extends Persistence, KC extends KeyCrypto> {
    private final TokenStorage<C, P, KC> storage;
    private final Map<String, ReplaySubject<Optional<String>>> loadSubjects;
    private final Map<String, ReplaySubject<Boolean>> containSubjects;
    private final ReplaySubject<List<String>> keysSubject;
    @NotNull
    private final C crypto;
    @NotNull
    private final P persistence;
    @NotNull
    private final KC keyCrypto;

    @NotNull
    public final C getCrypto() {
        return this.crypto;
    }

    @NotNull
    public final P getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final KC getKeyCrypto() {
        return this.keyCrypto;
    }

    @NotNull
    public final Completable clearAll() {
        Completable completable = Completable.fromCallable((Callable)new Callable<Object>(this){
            final /* synthetic */ RxTokenStorage this$0;

            public final void call() {
                ReplaySubject it;
                RxTokenStorage.access$getStorage$p(this.this$0).clearAll();
                Iterable $receiver$iv = RxTokenStorage.access$getLoadSubjects$p(this.this$0).values();
                for (T element$iv : $receiver$iv) {
                    it = (ReplaySubject)element$iv;
                    it.onNext((Object)Optional.None.INSTANCE);
                }
                $receiver$iv = RxTokenStorage.access$getContainSubjects$p(this.this$0).values();
                for (T element$iv : $receiver$iv) {
                    it = (ReplaySubject)element$iv;
                    it.onNext((Object)false);
                }
                ReplaySubject replaySubject = RxTokenStorage.access$getKeysSubject$p(this.this$0);
                List list = CollectionsKt.emptyList();
                replaySubject.onNext((Object)list);
            }
            {
                this.this$0 = rxTokenStorage;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026nNext(listOf())\n        }");
        return completable;
    }

    @NotNull
    public final Completable clear(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Completable completable = Completable.fromCallable((Callable)new Callable<Object>(this, key){
            final /* synthetic */ RxTokenStorage this$0;
            final /* synthetic */ String $key;

            public final void call() {
                RxTokenStorage.access$getStorage$p(this.this$0).clear(this.$key);
                RxTokenStorage.access$reload(this.this$0, this.$key);
            }
            {
                this.this$0 = rxTokenStorage;
                this.$key = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026    reload(key)\n        }");
        return completable;
    }

    @NotNull
    public final Completable save(@NotNull String key, @NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        Completable completable = Completable.fromCallable((Callable)new Callable<Object>(this, key, plaintext){
            final /* synthetic */ RxTokenStorage this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ String $plaintext;

            public final void call() {
                RxTokenStorage.access$getStorage$p(this.this$0).save(this.$key, this.$plaintext);
                RxTokenStorage.access$reload(this.this$0, this.$key);
            }
            {
                this.this$0 = rxTokenStorage;
                this.$key = string;
                this.$plaintext = string2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026    reload(key)\n        }");
        return completable;
    }

    @NotNull
    public final Flowable<Optional<String>> load(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.storage.getCrypto().verify();
        this.storage.getKeyCrypto().verify();
        if (this.loadSubjects.containsKey(key)) {
            ReplaySubject<Optional<String>> replaySubject = this.loadSubjects.get(key);
            if (replaySubject == null) {
                Intrinsics.throwNpe();
            }
            Flowable flowable = replaySubject.share().toFlowable(BackpressureStrategy.LATEST);
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"loadSubjects[key]!!.shar\u2026kpressureStrategy.LATEST)");
            return flowable;
        }
        ReplaySubject replaySubject = ReplaySubject.createWithSize((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)replaySubject, (String)"ReplaySubject.createWithSize<Optional<String>>(1)");
        ReplaySubject subject = replaySubject;
        Map<String, ReplaySubject<Optional<String>>> map = this.loadSubjects;
        ReplaySubject replaySubject2 = subject;
        map.put(key, (ReplaySubject<Optional<String>>)replaySubject2);
        subject.onNext(Optional.Companion.auto(this.loadString(key)));
        Flowable flowable = subject.share().toFlowable(BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"subject.share().toFlowab\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    @NotNull
    public final Flowable<List<String>> keys() {
        this.storage.getCrypto().verify();
        this.storage.getKeyCrypto().verify();
        Flowable flowable = this.keysSubject.share().toFlowable(BackpressureStrategy.LATEST).startWith((Object)this.storage.keys());
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"keysSubject.share().toFl\u2026startWith(storage.keys())");
        return flowable;
    }

    @NotNull
    public final Flowable<Boolean> contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.storage.getCrypto().verify();
        this.storage.getKeyCrypto().verify();
        if (this.containSubjects.containsKey(key)) {
            ReplaySubject<Boolean> replaySubject = this.containSubjects.get(key);
            if (replaySubject == null) {
                Intrinsics.throwNpe();
            }
            Flowable flowable = replaySubject.share().toFlowable(BackpressureStrategy.LATEST);
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"containSubjects[key]!!.s\u2026kpressureStrategy.LATEST)");
            return flowable;
        }
        ReplaySubject replaySubject = ReplaySubject.createWithSize((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)replaySubject, (String)"ReplaySubject.createWithSize<Boolean>(1)");
        ReplaySubject subject = replaySubject;
        Map<String, ReplaySubject<Boolean>> map = this.containSubjects;
        ReplaySubject replaySubject2 = subject;
        map.put(key, (ReplaySubject<Boolean>)replaySubject2);
        subject.onNext((Object)this.loadContains(key));
        Flowable flowable = subject.share().toFlowable(BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"subject.share().toFlowab\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    @NotNull
    public final Completable reset() {
        Completable completable = Completable.fromCallable((Callable)new Callable<Object>(this){
            final /* synthetic */ RxTokenStorage this$0;

            public final void call() {
                this.this$0.resetSync();
            }
            {
                this.this$0 = rxTokenStorage;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026     resetSync()\n       }");
        return completable;
    }

    public final void clearAllSync() {
        ReplaySubject it;
        this.storage.clearAll();
        Iterable $receiver$iv = this.loadSubjects.values();
        for (Object element$iv : $receiver$iv) {
            it = (ReplaySubject)element$iv;
            it.onNext((Object)Optional.None.INSTANCE);
        }
        $receiver$iv = this.containSubjects.values();
        for (Object element$iv : $receiver$iv) {
            it = (ReplaySubject)element$iv;
            it.onNext((Object)false);
        }
        ReplaySubject<List<String>> replaySubject = this.keysSubject;
        List list = CollectionsKt.emptyList();
        replaySubject.onNext((Object)list);
    }

    public final void clearSync(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.storage.clear(key);
        this.reload(key);
    }

    public final void saveSync(@NotNull String key, @NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        this.storage.save(key, plaintext);
        this.reload(key);
    }

    @Nullable
    public final String loadSync(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.storage.load(key);
    }

    public final boolean containsSync(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.storage.contains(key);
    }

    public final void resetSync() {
        this.crypto.reset();
        this.persistence.reset();
    }

    @NotNull
    public final RxTokenWrapper wrap(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new RxTokenWrapper(this, key);
    }

    private final boolean loadContains(String key) {
        return this.storage.contains(key);
    }

    private final String loadString(String key) {
        return this.storage.load(key);
    }

    private final void reload(String key) {
        ReplaySubject<Optional<String>> replaySubject = this.loadSubjects.get(key);
        if (replaySubject != null) {
            replaySubject.onNext(Optional.Companion.auto(this.loadString(key)));
        }
        ReplaySubject<Boolean> replaySubject2 = this.containSubjects.get(key);
        if (replaySubject2 != null) {
            replaySubject2.onNext((Object)this.loadContains(key));
        }
        if (!this.keyCrypto.scramblesKeys()) {
            this.keysSubject.onNext((Object)this.storage.keys());
        }
    }

    public RxTokenStorage(@NotNull C crypto, @NotNull P persistence, @NotNull KC keyCrypto) {
        Map map;
        Intrinsics.checkParameterIsNotNull(crypto, (String)"crypto");
        Intrinsics.checkParameterIsNotNull(persistence, (String)"persistence");
        Intrinsics.checkParameterIsNotNull(keyCrypto, (String)"keyCrypto");
        this.storage = new TokenStorage(crypto, persistence, keyCrypto);
        RxTokenStorage rxTokenStorage = this;
        rxTokenStorage.loadSubjects = map = (Map)new LinkedHashMap();
        rxTokenStorage = this;
        rxTokenStorage.containSubjects = map = (Map)new LinkedHashMap();
        ReplaySubject replaySubject = ReplaySubject.create((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)replaySubject, (String)"ReplaySubject.create<List<String>>(1)");
        this.keysSubject = replaySubject;
        this.crypto = this.storage.getCrypto();
        this.persistence = this.storage.getPersistence();
        this.keyCrypto = this.storage.getKeyCrypto();
    }

    @NotNull
    public static final /* synthetic */ TokenStorage access$getStorage$p(RxTokenStorage $this) {
        return $this.storage;
    }

    @NotNull
    public static final /* synthetic */ Map access$getLoadSubjects$p(RxTokenStorage $this) {
        return $this.loadSubjects;
    }

    @NotNull
    public static final /* synthetic */ Map access$getContainSubjects$p(RxTokenStorage $this) {
        return $this.containSubjects;
    }

    @NotNull
    public static final /* synthetic */ ReplaySubject access$getKeysSubject$p(RxTokenStorage $this) {
        return $this.keysSubject;
    }

    public static final /* synthetic */ void access$reload(RxTokenStorage $this, @NotNull String key) {
        $this.reload(key);
    }
}

