package app.raybritton.tokenstorage

import io.reactivex.Completable
import io.reactivex.Flowable

class RxTokenWrapper(private val tokenStorage: RxTokenStorage,
                   val key: String) {
    fun save(plaintext: String): Completable {
        return tokenStorage.save(key, plaintext)
    }

    fun load(): Flowable<Optional<String>> {
        return tokenStorage.load(key)
    }

    fun isSet(): Flowable<Boolean> {
        return tokenStorage.contains(key)
    }

    fun clear(): Completable {
        return tokenStorage.clear(key)
    }

    fun clearSync() {
        return tokenStorage.clearSync(key)
    }

    fun saveSync(plaintext: String) {
        return tokenStorage.saveSync(key, plaintext)
    }

    fun loadSync(): String? {
        return tokenStorage.loadSync(key)
    }

    fun isSetSync(): Boolean {
        return tokenStorage.containsSync(key)
    }
}