/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.impl.model.WorkName;
import androidx.work.impl.model.WorkNameDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WorkNameDao_Impl
implements WorkNameDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WorkName> __insertionAdapterOfWorkName;

    public WorkNameDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfWorkName = new EntityInsertionAdapter<WorkName>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `WorkName` (`name`,`work_spec_id`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, WorkName value) {
                if (value.getName() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getName());
                }
                if (value.getWorkSpecId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getWorkSpecId());
                }
            }
        };
    }

    @Override
    public void insert(WorkName workName) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfWorkName.insert((Object)workName);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkSpecIdsWithName(String name) {
        String _sql = "SELECT work_spec_id FROM workname WHERE name=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT work_spec_id FROM workname WHERE name=?", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getNamesForWorkSpecId(String workSpecId) {
        String _sql = "SELECT name FROM workname WHERE work_spec_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT name FROM workname WHERE work_spec_id=?", (int)1);
        int _argIndex = 1;
        if (workSpecId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, workSpecId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

