/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.WorkManagerImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StopWorkRunnable
implements Runnable {
    private static final String TAG = Logger.tagWithPrefix("StopWorkRunnable");
    private final WorkManagerImpl mWorkManagerImpl;
    private final StartStopToken mToken;
    private final boolean mStopInForeground;

    public StopWorkRunnable(@NonNull WorkManagerImpl workManagerImpl, @NonNull StartStopToken startStopToken, boolean stopInForeground) {
        this.mWorkManagerImpl = workManagerImpl;
        this.mToken = startStopToken;
        this.mStopInForeground = stopInForeground;
    }

    @Override
    public void run() {
        boolean isStopped = this.mStopInForeground ? this.mWorkManagerImpl.getProcessor().stopForegroundWork(this.mToken) : this.mWorkManagerImpl.getProcessor().stopWork(this.mToken);
        Logger.get().debug(TAG, "StopWorkRunnable for " + this.mToken.getId().getWorkSpecId() + "; Processor.stopWork = " + isStopped);
    }
}

