/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.ApplicationExitInfo;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.InitializationExceptionHandler;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkDatabasePathHelper;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemjob.SystemJobScheduler;
import androidx.work.impl.model.WorkProgressDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.PreferenceUtils;
import androidx.work.impl.utils.ProcessUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ForceStopRunnable
implements Runnable {
    private static final String TAG = Logger.tagWithPrefix("ForceStopRunnable");
    @VisibleForTesting
    static final String ACTION_FORCE_STOP_RESCHEDULE = "ACTION_FORCE_STOP_RESCHEDULE";
    @VisibleForTesting
    static final int MAX_ATTEMPTS = 3;
    private static final int ALARM_ID = -1;
    private static final long BACKOFF_DURATION_MS = 300L;
    private static final long TEN_YEARS = TimeUnit.DAYS.toMillis(3650L);
    private final Context mContext;
    private final WorkManagerImpl mWorkManager;
    private final PreferenceUtils mPreferenceUtils;
    private int mRetryCount;

    public ForceStopRunnable(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this.mContext = context.getApplicationContext();
        this.mWorkManager = workManager;
        this.mPreferenceUtils = workManager.getPreferenceUtils();
        this.mRetryCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.multiProcessChecks()) {
                return;
            }
            while (true) {
                try {
                    WorkDatabasePathHelper.migrateDatabase(this.mContext);
                }
                catch (SQLiteException sqLiteException) {
                    String message = "Unexpected SQLite exception during migrations";
                    Logger.get().error(TAG, message);
                    IllegalStateException exception = new IllegalStateException(message, sqLiteException);
                    InitializationExceptionHandler exceptionHandler = this.mWorkManager.getConfiguration().getInitializationExceptionHandler();
                    if (exceptionHandler != null) {
                        exceptionHandler.handleException(exception);
                        break;
                    }
                    throw exception;
                }
                Logger.get().debug(TAG, "Performing cleanup operations.");
                try {
                    this.forceStopRunnable();
                }
                catch (SQLiteAccessPermException | SQLiteCantOpenDatabaseException | SQLiteConstraintException | SQLiteDatabaseCorruptException | SQLiteDatabaseLockedException | SQLiteDiskIOException | SQLiteTableLockedException exception) {
                    ++this.mRetryCount;
                    if (this.mRetryCount >= 3) {
                        String message = "The file system on the device is in a bad state. WorkManager cannot access the app's internal data store.";
                        Logger.get().error(TAG, message, exception);
                        IllegalStateException throwable = new IllegalStateException(message, exception);
                        InitializationExceptionHandler exceptionHandler = this.mWorkManager.getConfiguration().getInitializationExceptionHandler();
                        if (exceptionHandler != null) {
                            Logger.get().debug(TAG, "Routing exception to the specified exception handler", throwable);
                            exceptionHandler.handleException(throwable);
                            break;
                        }
                        throw throwable;
                    }
                    long duration = (long)this.mRetryCount * 300L;
                    Logger.get().debug(TAG, "Retrying after " + duration, exception);
                    this.sleep((long)this.mRetryCount * 300L);
                    continue;
                }
                break;
            }
        }
        finally {
            this.mWorkManager.onForceStopRunnableCompleted();
        }
    }

    @VisibleForTesting
    @SuppressLint(value={"ClassVerificationFailure"})
    public boolean isForceStopped() {
        try {
            int flags = 0x20000000;
            if (Build.VERSION.SDK_INT >= 31) {
                flags |= 0x2000000;
            }
            PendingIntent pendingIntent = ForceStopRunnable.getPendingIntent(this.mContext, flags);
            if (Build.VERSION.SDK_INT >= 30) {
                ActivityManager activityManager;
                List exitInfoList;
                if (pendingIntent != null) {
                    pendingIntent.cancel();
                }
                if ((exitInfoList = (activityManager = (ActivityManager)this.mContext.getSystemService("activity")).getHistoricalProcessExitReasons(null, 0, 0)) != null && !exitInfoList.isEmpty()) {
                    long timestamp = this.mPreferenceUtils.getLastForceStopEventMillis();
                    for (int i = 0; i < exitInfoList.size(); ++i) {
                        ApplicationExitInfo info = (ApplicationExitInfo)exitInfoList.get(i);
                        if (info.getReason() != 10 || info.getTimestamp() < timestamp) continue;
                        return true;
                    }
                }
            } else if (pendingIntent == null) {
                ForceStopRunnable.setAlarm(this.mContext);
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException | SecurityException exception) {
            Logger.get().warning(TAG, "Ignoring exception", exception);
            return true;
        }
    }

    @VisibleForTesting
    public void forceStopRunnable() {
        boolean needsScheduling = this.cleanUp();
        if (this.shouldRescheduleWorkers()) {
            Logger.get().debug(TAG, "Rescheduling Workers.");
            this.mWorkManager.rescheduleEligibleWork();
            this.mWorkManager.getPreferenceUtils().setNeedsReschedule(false);
        } else if (this.isForceStopped()) {
            Logger.get().debug(TAG, "Application was force-stopped, rescheduling.");
            this.mWorkManager.rescheduleEligibleWork();
            this.mPreferenceUtils.setLastForceStopEventMillis(System.currentTimeMillis());
        } else if (needsScheduling) {
            Logger.get().debug(TAG, "Found unfinished work, scheduling it.");
            Schedulers.schedule(this.mWorkManager.getConfiguration(), this.mWorkManager.getWorkDatabase(), this.mWorkManager.getSchedulers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean cleanUp() {
        boolean needsScheduling;
        boolean needsReconciling = false;
        if (Build.VERSION.SDK_INT >= 23) {
            needsReconciling = SystemJobScheduler.reconcileJobs(this.mContext, this.mWorkManager);
        }
        WorkDatabase workDatabase = this.mWorkManager.getWorkDatabase();
        WorkSpecDao workSpecDao = workDatabase.workSpecDao();
        WorkProgressDao workProgressDao = workDatabase.workProgressDao();
        workDatabase.beginTransaction();
        try {
            List<WorkSpec> workSpecs = workSpecDao.getRunningWork();
            boolean bl = needsScheduling = workSpecs != null && !workSpecs.isEmpty();
            if (needsScheduling) {
                for (WorkSpec workSpec : workSpecs) {
                    workSpecDao.setState(WorkInfo.State.ENQUEUED, workSpec.id);
                    workSpecDao.markWorkSpecScheduled(workSpec.id, -1L);
                }
            }
            workProgressDao.deleteAll();
            workDatabase.setTransactionSuccessful();
        }
        finally {
            workDatabase.endTransaction();
        }
        return needsScheduling || needsReconciling;
    }

    @VisibleForTesting
    public boolean shouldRescheduleWorkers() {
        return this.mWorkManager.getPreferenceUtils().getNeedsReschedule();
    }

    @VisibleForTesting
    public boolean multiProcessChecks() {
        Configuration configuration = this.mWorkManager.getConfiguration();
        if (TextUtils.isEmpty((CharSequence)configuration.getDefaultProcessName())) {
            Logger.get().debug(TAG, "The default process name was not specified.");
            return true;
        }
        boolean isDefaultProcess = ProcessUtils.isDefaultProcess(this.mContext, configuration);
        Logger.get().debug(TAG, "Is default app process = " + isDefaultProcess);
        return isDefaultProcess;
    }

    @VisibleForTesting
    public void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static PendingIntent getPendingIntent(Context context, int flags) {
        Intent intent = ForceStopRunnable.getIntent(context);
        return PendingIntent.getBroadcast((Context)context, (int)-1, (Intent)intent, (int)flags);
    }

    @VisibleForTesting
    static Intent getIntent(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(context, BroadcastReceiver.class));
        intent.setAction(ACTION_FORCE_STOP_RESCHEDULE);
        return intent;
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    static void setAlarm(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        PendingIntent pendingIntent = ForceStopRunnable.getPendingIntent(context, flags);
        long triggerAt = System.currentTimeMillis() + TEN_YEARS;
        if (alarmManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                alarmManager.setExact(0, triggerAt, pendingIntent);
            } else {
                alarmManager.set(0, triggerAt, pendingIntent);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class BroadcastReceiver
    extends android.content.BroadcastReceiver {
        private static final String TAG = Logger.tagWithPrefix("ForceStopRunnable$Rcvr");

        public void onReceive(@NonNull Context context, @Nullable Intent intent) {
            String action;
            if (intent != null && ForceStopRunnable.ACTION_FORCE_STOP_RESCHEDULE.equals(action = intent.getAction())) {
                Logger.get().verbose(TAG, "Rescheduling alarm that keeps track of force-stops.");
                ForceStopRunnable.setAlarm(context);
            }
        }
    }
}

