/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Operation;
import androidx.work.impl.OperationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpecDao;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PruneWorkRunnable
implements Runnable {
    private final WorkManagerImpl mWorkManagerImpl;
    private final OperationImpl mOperation;

    public PruneWorkRunnable(@NonNull WorkManagerImpl workManagerImpl) {
        this.mWorkManagerImpl = workManagerImpl;
        this.mOperation = new OperationImpl();
    }

    @NonNull
    public Operation getOperation() {
        return this.mOperation;
    }

    @Override
    public void run() {
        try {
            WorkDatabase workDatabase = this.mWorkManagerImpl.getWorkDatabase();
            WorkSpecDao workSpecDao = workDatabase.workSpecDao();
            workSpecDao.pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast();
            this.mOperation.markState(Operation.SUCCESS);
        }
        catch (Throwable exception) {
            this.mOperation.markState(new Operation.State.FAILURE(exception));
        }
    }
}

