/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.arch.core.util.Function;
import androidx.room.ColumnInfo;
import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.Relation;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.Logger;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u0000 J2\u00020\u0001:\u0003JKLB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u00cb\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0003\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u0012\b\b\u0002\u0010 \u001a\u00020!\u0012\b\b\u0002\u0010\"\u001a\u00020\u0017\u0012\b\b\u0002\u0010#\u001a\u00020\u0017\u00a2\u0006\u0002\u0010$J\u0006\u0010-\u001a\u00020\u0011J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0015H\u00c6\u0003J\t\u00100\u001a\u00020\u0017H\u00c6\u0003J\t\u00101\u001a\u00020\u0019H\u00c6\u0003J\t\u00102\u001a\u00020\u0011H\u00c6\u0003J\t\u00103\u001a\u00020\u0011H\u00c6\u0003J\t\u00104\u001a\u00020\u0011H\u00c6\u0003J\t\u00105\u001a\u00020\u0011H\u00c6\u0003J\t\u00106\u001a\u00020\u001fH\u00c6\u0003J\t\u00107\u001a\u00020!H\u00c6\u0003J\t\u00108\u001a\u00020\u0017H\u00c6\u0003J\t\u00109\u001a\u00020\nH\u00c6\u0003J\t\u0010:\u001a\u00020\u0017H\u00c6\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u000eH\u00c6\u0003J\t\u0010>\u001a\u00020\u000eH\u00c6\u0003J\t\u0010?\u001a\u00020\u0011H\u00c6\u0003J\t\u0010@\u001a\u00020\u0011H\u00c6\u0003J\t\u0010A\u001a\u00020\u0011H\u00c6\u0003J\u00d3\u0001\u0010B\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0003\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00112\b\b\u0002\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u00112\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u00172\b\b\u0002\u0010#\u001a\u00020\u0017H\u00c6\u0001J\u0013\u0010C\u001a\u00020\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010D\u001a\u00020\u001fJ\t\u0010E\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010F\u001a\u00020G2\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010H\u001a\u00020G2\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010H\u001a\u00020G2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010I\u001a\u00020\u0003H\u0016R\u0012\u0010\u001a\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u0012\u0010\u001b\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010,R\u0012\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Landroidx/work/impl/model/WorkSpec;", "", "id", "", "workerClassName_", "(Ljava/lang/String;Ljava/lang/String;)V", "newId", "other", "(Ljava/lang/String;Landroidx/work/impl/model/WorkSpec;)V", "state", "Landroidx/work/WorkInfo$State;", "workerClassName", "inputMergerClassName", "input", "Landroidx/work/Data;", "output", "initialDelay", "", "intervalDuration", "flexDuration", "constraints", "Landroidx/work/Constraints;", "runAttemptCount", "", "backoffPolicy", "Landroidx/work/BackoffPolicy;", "backoffDelayDuration", "lastEnqueueTime", "minimumRetentionDuration", "scheduleRequestedAt", "expedited", "", "outOfQuotaPolicy", "Landroidx/work/OutOfQuotaPolicy;", "periodCount", "generation", "(Ljava/lang/String;Landroidx/work/WorkInfo$State;Ljava/lang/String;Ljava/lang/String;Landroidx/work/Data;Landroidx/work/Data;JJJLandroidx/work/Constraints;ILandroidx/work/BackoffPolicy;JJJJZLandroidx/work/OutOfQuotaPolicy;II)V", "getGeneration", "()I", "isBackedOff", "()Z", "isPeriodic", "getPeriodCount", "setPeriodCount", "(I)V", "calculateNextRunTime", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "hasConstraints", "hashCode", "setBackoffDelayDuration", "", "setPeriodic", "toString", "Companion", "IdAndState", "WorkInfoPojo", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Entity(indices={@Index(value={"schedule_requested_at"}), @Index(value={"last_enqueue_time"})})
public final class WorkSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @ColumnInfo(name="id")
    @PrimaryKey
    @NotNull
    public final String id;
    @JvmField
    @ColumnInfo(name="state")
    @NotNull
    public WorkInfo.State state;
    @JvmField
    @ColumnInfo(name="worker_class_name")
    @NotNull
    public String workerClassName;
    @JvmField
    @ColumnInfo(name="input_merger_class_name")
    @Nullable
    public String inputMergerClassName;
    @JvmField
    @ColumnInfo(name="input")
    @NotNull
    public Data input;
    @JvmField
    @ColumnInfo(name="output")
    @NotNull
    public Data output;
    @JvmField
    @ColumnInfo(name="initial_delay")
    public long initialDelay;
    @JvmField
    @ColumnInfo(name="interval_duration")
    public long intervalDuration;
    @JvmField
    @ColumnInfo(name="flex_duration")
    public long flexDuration;
    @JvmField
    @Embedded
    @NotNull
    public Constraints constraints;
    @JvmField
    @ColumnInfo(name="run_attempt_count")
    public int runAttemptCount;
    @JvmField
    @ColumnInfo(name="backoff_policy")
    @NotNull
    public BackoffPolicy backoffPolicy;
    @JvmField
    @ColumnInfo(name="backoff_delay_duration")
    public long backoffDelayDuration;
    @JvmField
    @ColumnInfo(name="last_enqueue_time")
    public long lastEnqueueTime;
    @JvmField
    @ColumnInfo(name="minimum_retention_duration")
    public long minimumRetentionDuration;
    @JvmField
    @ColumnInfo(name="schedule_requested_at")
    public long scheduleRequestedAt;
    @JvmField
    @ColumnInfo(name="run_in_foreground")
    public boolean expedited;
    @JvmField
    @ColumnInfo(name="out_of_quota_policy")
    @NotNull
    public OutOfQuotaPolicy outOfQuotaPolicy;
    @ColumnInfo(name="period_count", defaultValue="0")
    private int periodCount;
    @ColumnInfo(defaultValue="0")
    private final int generation;
    @NotNull
    private static final String TAG;
    public static final long SCHEDULE_NOT_REQUESTED_YET = -1L;
    @JvmField
    @NotNull
    public static final Function<List<WorkInfoPojo>, List<WorkInfo>> WORK_INFO_MAPPER;

    public WorkSpec(@NotNull String id, @NotNull WorkInfo.State state, @NotNull String workerClassName, @Nullable String inputMergerClassName, @NotNull Data input, @NotNull Data output, long initialDelay, long intervalDuration, long flexDuration, @NotNull Constraints constraints, @IntRange(from=0L) int runAttemptCount, @NotNull BackoffPolicy backoffPolicy, long backoffDelayDuration, long lastEnqueueTime, long minimumRetentionDuration, long scheduleRequestedAt, boolean expedited, @NotNull OutOfQuotaPolicy outOfQuotaPolicy, int periodCount, int generation) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)((Object)backoffPolicy), (String)"backoffPolicy");
        Intrinsics.checkNotNullParameter((Object)((Object)outOfQuotaPolicy), (String)"outOfQuotaPolicy");
        this.id = id;
        this.state = state;
        this.workerClassName = workerClassName;
        this.inputMergerClassName = inputMergerClassName;
        this.input = input;
        this.output = output;
        this.initialDelay = initialDelay;
        this.intervalDuration = intervalDuration;
        this.flexDuration = flexDuration;
        this.constraints = constraints;
        this.runAttemptCount = runAttemptCount;
        this.backoffPolicy = backoffPolicy;
        this.backoffDelayDuration = backoffDelayDuration;
        this.lastEnqueueTime = lastEnqueueTime;
        this.minimumRetentionDuration = minimumRetentionDuration;
        this.scheduleRequestedAt = scheduleRequestedAt;
        this.expedited = expedited;
        this.outOfQuotaPolicy = outOfQuotaPolicy;
        this.periodCount = periodCount;
        this.generation = generation;
    }

    public /* synthetic */ WorkSpec(String string, WorkInfo.State state, String string2, String string3, Data data, Data data2, long l, long l2, long l3, Constraints constraints, int n, BackoffPolicy backoffPolicy, long l4, long l5, long l6, long l7, boolean bl, OutOfQuotaPolicy outOfQuotaPolicy, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            state = WorkInfo.State.ENQUEUED;
        }
        if ((n4 & 8) != 0) {
            string3 = null;
        }
        if ((n4 & 0x10) != 0) {
            Data data3 = Data.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)data3, (String)"EMPTY");
            data = data3;
        }
        if ((n4 & 0x20) != 0) {
            Data data4 = Data.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)data4, (String)"EMPTY");
            data2 = data4;
        }
        if ((n4 & 0x40) != 0) {
            l = 0L;
        }
        if ((n4 & 0x80) != 0) {
            l2 = 0L;
        }
        if ((n4 & 0x100) != 0) {
            l3 = 0L;
        }
        if ((n4 & 0x200) != 0) {
            constraints = Constraints.NONE;
        }
        if ((n4 & 0x400) != 0) {
            n = 0;
        }
        if ((n4 & 0x800) != 0) {
            backoffPolicy = BackoffPolicy.EXPONENTIAL;
        }
        if ((n4 & 0x1000) != 0) {
            l4 = 30000L;
        }
        if ((n4 & 0x2000) != 0) {
            l5 = 0L;
        }
        if ((n4 & 0x4000) != 0) {
            l6 = 0L;
        }
        if ((n4 & 0x8000) != 0) {
            l7 = -1L;
        }
        if ((n4 & 0x10000) != 0) {
            bl = false;
        }
        if ((n4 & 0x20000) != 0) {
            outOfQuotaPolicy = OutOfQuotaPolicy.RUN_AS_NON_EXPEDITED_WORK_REQUEST;
        }
        if ((n4 & 0x40000) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x80000) != 0) {
            n3 = 0;
        }
        this(string, state, string2, string3, data, data2, l, l2, l3, constraints, n, backoffPolicy, l4, l5, l6, l7, bl, outOfQuotaPolicy, n2, n3);
    }

    public final int getPeriodCount() {
        return this.periodCount;
    }

    public final void setPeriodCount(int n) {
        this.periodCount = n;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public WorkSpec(@NotNull String id, @NotNull String workerClassName_) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)workerClassName_, (String)"workerClassName_");
        this(id, null, workerClassName_, null, null, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 1048570, null);
    }

    public WorkSpec(@NotNull String newId, @NotNull WorkSpec other) {
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = other.workerClassName;
        WorkInfo.State state = other.state;
        String string2 = other.inputMergerClassName;
        Data data = new Data(other.input);
        Data data2 = new Data(other.output);
        long l = other.initialDelay;
        long l2 = other.intervalDuration;
        long l3 = other.flexDuration;
        Constraints constraints = new Constraints(other.constraints);
        int n = other.runAttemptCount;
        BackoffPolicy backoffPolicy = other.backoffPolicy;
        long l4 = other.backoffDelayDuration;
        long l5 = other.lastEnqueueTime;
        long l6 = other.minimumRetentionDuration;
        long l7 = other.scheduleRequestedAt;
        boolean bl = other.expedited;
        OutOfQuotaPolicy outOfQuotaPolicy = other.outOfQuotaPolicy;
        int n2 = other.periodCount;
        this(newId, state, string, string2, data, data2, l, l2, l3, constraints, n, backoffPolicy, l4, l5, l6, l7, bl, outOfQuotaPolicy, n2, 0, 524288, null);
    }

    public final void setBackoffDelayDuration(long backoffDelayDuration) {
        if (backoffDelayDuration > 18000000L) {
            Logger.get().warning(TAG, "Backoff delay duration exceeds maximum value");
        }
        if (backoffDelayDuration < 10000L) {
            Logger.get().warning(TAG, "Backoff delay duration less than minimum value");
        }
        this.backoffDelayDuration = RangesKt.coerceIn((long)backoffDelayDuration, (long)10000L, (long)18000000L);
    }

    public final boolean isPeriodic() {
        return this.intervalDuration != 0L;
    }

    public final boolean isBackedOff() {
        return this.state == WorkInfo.State.ENQUEUED && this.runAttemptCount > 0;
    }

    public final void setPeriodic(long intervalDuration) {
        if (intervalDuration < 900000L) {
            Logger.get().warning(TAG, "Interval duration lesser than minimum allowed value; Changed to 900000");
        }
        this.setPeriodic(RangesKt.coerceAtLeast((long)intervalDuration, (long)900000L), RangesKt.coerceAtLeast((long)intervalDuration, (long)900000L));
    }

    public final void setPeriodic(long intervalDuration, long flexDuration) {
        if (intervalDuration < 900000L) {
            Logger.get().warning(TAG, "Interval duration lesser than minimum allowed value; Changed to 900000");
        }
        this.intervalDuration = RangesKt.coerceAtLeast((long)intervalDuration, (long)900000L);
        if (flexDuration < 300000L) {
            Logger.get().warning(TAG, "Flex duration lesser than minimum allowed value; Changed to 300000");
        }
        if (flexDuration > this.intervalDuration) {
            Logger.get().warning(TAG, "Flex duration greater than interval duration; Changed to " + intervalDuration);
        }
        this.flexDuration = RangesKt.coerceIn((long)flexDuration, (long)300000L, (long)this.intervalDuration);
    }

    public final long calculateNextRunTime() {
        long l;
        if (this.isBackedOff()) {
            boolean isLinearBackoff = this.backoffPolicy == BackoffPolicy.LINEAR;
            long delay = isLinearBackoff ? this.backoffDelayDuration * (long)this.runAttemptCount : (long)Math.scalb(this.backoffDelayDuration, this.runAttemptCount - 1);
            l = this.lastEnqueueTime + RangesKt.coerceAtMost((long)delay, (long)18000000L);
        } else if (this.isPeriodic()) {
            boolean isFlexApplicable;
            long start = this.periodCount == 0 ? this.lastEnqueueTime + this.initialDelay : this.lastEnqueueTime;
            boolean bl = isFlexApplicable = this.flexDuration != this.intervalDuration;
            if (isFlexApplicable) {
                long offset = this.periodCount == 0 ? (long)-1 * this.flexDuration : 0L;
                l = start + this.intervalDuration + offset;
            } else {
                long offset = this.periodCount == 0 ? 0L : this.intervalDuration;
                l = start + offset;
            }
        } else {
            long start = this.lastEnqueueTime == 0L ? System.currentTimeMillis() : this.lastEnqueueTime;
            l = start + this.initialDelay;
        }
        return l;
    }

    public final boolean hasConstraints() {
        return !Intrinsics.areEqual((Object)Constraints.NONE, (Object)this.constraints);
    }

    @NotNull
    public String toString() {
        return "{WorkSpec: " + this.id + '}';
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final WorkInfo.State component2() {
        return this.state;
    }

    @NotNull
    public final String component3() {
        return this.workerClassName;
    }

    @Nullable
    public final String component4() {
        return this.inputMergerClassName;
    }

    @NotNull
    public final Data component5() {
        return this.input;
    }

    @NotNull
    public final Data component6() {
        return this.output;
    }

    public final long component7() {
        return this.initialDelay;
    }

    public final long component8() {
        return this.intervalDuration;
    }

    public final long component9() {
        return this.flexDuration;
    }

    @NotNull
    public final Constraints component10() {
        return this.constraints;
    }

    public final int component11() {
        return this.runAttemptCount;
    }

    @NotNull
    public final BackoffPolicy component12() {
        return this.backoffPolicy;
    }

    public final long component13() {
        return this.backoffDelayDuration;
    }

    public final long component14() {
        return this.lastEnqueueTime;
    }

    public final long component15() {
        return this.minimumRetentionDuration;
    }

    public final long component16() {
        return this.scheduleRequestedAt;
    }

    public final boolean component17() {
        return this.expedited;
    }

    @NotNull
    public final OutOfQuotaPolicy component18() {
        return this.outOfQuotaPolicy;
    }

    public final int component19() {
        return this.periodCount;
    }

    public final int component20() {
        return this.generation;
    }

    @NotNull
    public final WorkSpec copy(@NotNull String id, @NotNull WorkInfo.State state, @NotNull String workerClassName, @Nullable String inputMergerClassName, @NotNull Data input, @NotNull Data output, long initialDelay, long intervalDuration, long flexDuration, @NotNull Constraints constraints, @IntRange(from=0L) int runAttemptCount, @NotNull BackoffPolicy backoffPolicy, long backoffDelayDuration, long lastEnqueueTime, long minimumRetentionDuration, long scheduleRequestedAt, boolean expedited, @NotNull OutOfQuotaPolicy outOfQuotaPolicy, int periodCount, int generation) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)((Object)backoffPolicy), (String)"backoffPolicy");
        Intrinsics.checkNotNullParameter((Object)((Object)outOfQuotaPolicy), (String)"outOfQuotaPolicy");
        return new WorkSpec(id, state, workerClassName, inputMergerClassName, input, output, initialDelay, intervalDuration, flexDuration, constraints, runAttemptCount, backoffPolicy, backoffDelayDuration, lastEnqueueTime, minimumRetentionDuration, scheduleRequestedAt, expedited, outOfQuotaPolicy, periodCount, generation);
    }

    public static /* synthetic */ WorkSpec copy$default(WorkSpec workSpec, String string, WorkInfo.State state, String string2, String string3, Data data, Data data2, long l, long l2, long l3, Constraints constraints, int n, BackoffPolicy backoffPolicy, long l4, long l5, long l6, long l7, boolean bl, OutOfQuotaPolicy outOfQuotaPolicy, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = workSpec.id;
        }
        if ((n4 & 2) != 0) {
            state = workSpec.state;
        }
        if ((n4 & 4) != 0) {
            string2 = workSpec.workerClassName;
        }
        if ((n4 & 8) != 0) {
            string3 = workSpec.inputMergerClassName;
        }
        if ((n4 & 0x10) != 0) {
            data = workSpec.input;
        }
        if ((n4 & 0x20) != 0) {
            data2 = workSpec.output;
        }
        if ((n4 & 0x40) != 0) {
            l = workSpec.initialDelay;
        }
        if ((n4 & 0x80) != 0) {
            l2 = workSpec.intervalDuration;
        }
        if ((n4 & 0x100) != 0) {
            l3 = workSpec.flexDuration;
        }
        if ((n4 & 0x200) != 0) {
            constraints = workSpec.constraints;
        }
        if ((n4 & 0x400) != 0) {
            n = workSpec.runAttemptCount;
        }
        if ((n4 & 0x800) != 0) {
            backoffPolicy = workSpec.backoffPolicy;
        }
        if ((n4 & 0x1000) != 0) {
            l4 = workSpec.backoffDelayDuration;
        }
        if ((n4 & 0x2000) != 0) {
            l5 = workSpec.lastEnqueueTime;
        }
        if ((n4 & 0x4000) != 0) {
            l6 = workSpec.minimumRetentionDuration;
        }
        if ((n4 & 0x8000) != 0) {
            l7 = workSpec.scheduleRequestedAt;
        }
        if ((n4 & 0x10000) != 0) {
            bl = workSpec.expedited;
        }
        if ((n4 & 0x20000) != 0) {
            outOfQuotaPolicy = workSpec.outOfQuotaPolicy;
        }
        if ((n4 & 0x40000) != 0) {
            n2 = workSpec.periodCount;
        }
        if ((n4 & 0x80000) != 0) {
            n3 = workSpec.generation;
        }
        return workSpec.copy(string, state, string2, string3, data, data2, l, l2, l3, constraints, n, backoffPolicy, l4, l5, l6, l7, bl, outOfQuotaPolicy, n2, n3);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.state.hashCode();
        result = result * 31 + this.workerClassName.hashCode();
        result = result * 31 + (this.inputMergerClassName == null ? 0 : this.inputMergerClassName.hashCode());
        result = result * 31 + this.input.hashCode();
        result = result * 31 + this.output.hashCode();
        result = result * 31 + Long.hashCode(this.initialDelay);
        result = result * 31 + Long.hashCode(this.intervalDuration);
        result = result * 31 + Long.hashCode(this.flexDuration);
        result = result * 31 + this.constraints.hashCode();
        result = result * 31 + Integer.hashCode(this.runAttemptCount);
        result = result * 31 + this.backoffPolicy.hashCode();
        result = result * 31 + Long.hashCode(this.backoffDelayDuration);
        result = result * 31 + Long.hashCode(this.lastEnqueueTime);
        result = result * 31 + Long.hashCode(this.minimumRetentionDuration);
        result = result * 31 + Long.hashCode(this.scheduleRequestedAt);
        int n = this.expedited ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.outOfQuotaPolicy.hashCode();
        result = result * 31 + Integer.hashCode(this.periodCount);
        result = result * 31 + Integer.hashCode(this.generation);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorkSpec)) {
            return false;
        }
        WorkSpec workSpec = (WorkSpec)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)workSpec.id)) {
            return false;
        }
        if (this.state != workSpec.state) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workerClassName, (Object)workSpec.workerClassName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.inputMergerClassName, (Object)workSpec.inputMergerClassName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.input, (Object)workSpec.input)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.output, (Object)workSpec.output)) {
            return false;
        }
        if (this.initialDelay != workSpec.initialDelay) {
            return false;
        }
        if (this.intervalDuration != workSpec.intervalDuration) {
            return false;
        }
        if (this.flexDuration != workSpec.flexDuration) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.constraints, (Object)workSpec.constraints)) {
            return false;
        }
        if (this.runAttemptCount != workSpec.runAttemptCount) {
            return false;
        }
        if (this.backoffPolicy != workSpec.backoffPolicy) {
            return false;
        }
        if (this.backoffDelayDuration != workSpec.backoffDelayDuration) {
            return false;
        }
        if (this.lastEnqueueTime != workSpec.lastEnqueueTime) {
            return false;
        }
        if (this.minimumRetentionDuration != workSpec.minimumRetentionDuration) {
            return false;
        }
        if (this.scheduleRequestedAt != workSpec.scheduleRequestedAt) {
            return false;
        }
        if (this.expedited != workSpec.expedited) {
            return false;
        }
        if (this.outOfQuotaPolicy != workSpec.outOfQuotaPolicy) {
            return false;
        }
        if (this.periodCount != workSpec.periodCount) {
            return false;
        }
        return this.generation == workSpec.generation;
    }

    /*
     * WARNING - void declaration
     */
    private static final List WORK_INFO_MAPPER$lambda-1(List input) {
        List list;
        List list2 = input;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WorkInfoPojo workInfoPojo = (WorkInfoPojo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toWorkInfo());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    static {
        String string = Logger.tagWithPrefix("WorkSpec");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"WorkSpec\")");
        TAG = string;
        WORK_INFO_MAPPER = WorkSpec::WORK_INFO_MAPPER$lambda-1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/work/impl/model/WorkSpec$IdAndState;", "", "id", "", "state", "Landroidx/work/WorkInfo$State;", "(Ljava/lang/String;Landroidx/work/WorkInfo$State;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "work-runtime_release"})
    public static final class IdAndState {
        @JvmField
        @ColumnInfo(name="id")
        @NotNull
        public String id;
        @JvmField
        @ColumnInfo(name="state")
        @NotNull
        public WorkInfo.State state;

        public IdAndState(@NotNull String id, @NotNull WorkInfo.State state) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.id = id;
            this.state = state;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final WorkInfo.State component2() {
            return this.state;
        }

        @NotNull
        public final IdAndState copy(@NotNull String id, @NotNull WorkInfo.State state) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new IdAndState(id, state);
        }

        public static /* synthetic */ IdAndState copy$default(IdAndState idAndState, String string, WorkInfo.State state, int n, Object object) {
            if ((n & 1) != 0) {
                string = idAndState.id;
            }
            if ((n & 2) != 0) {
                state = idAndState.state;
            }
            return idAndState.copy(string, state);
        }

        @NotNull
        public String toString() {
            return "IdAndState(id=" + this.id + ", state=" + (Object)((Object)this.state) + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdAndState)) {
                return false;
            }
            IdAndState idAndState = (IdAndState)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)idAndState.id)) {
                return false;
            }
            return this.state == idAndState.state;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u00c6\u0003JQ\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\tH\u00d6\u0001J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001J\u0006\u00100\u001a\u000201R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010\u0019\u00a8\u00062"}, d2={"Landroidx/work/impl/model/WorkSpec$WorkInfoPojo;", "", "id", "", "state", "Landroidx/work/WorkInfo$State;", "output", "Landroidx/work/Data;", "runAttemptCount", "", "tags", "", "progress", "(Ljava/lang/String;Landroidx/work/WorkInfo$State;Landroidx/work/Data;ILjava/util/List;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "getOutput", "()Landroidx/work/Data;", "setOutput", "(Landroidx/work/Data;)V", "getProgress", "()Ljava/util/List;", "setProgress", "(Ljava/util/List;)V", "getRunAttemptCount", "()I", "setRunAttemptCount", "(I)V", "getState", "()Landroidx/work/WorkInfo$State;", "setState", "(Landroidx/work/WorkInfo$State;)V", "getTags", "setTags", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "toWorkInfo", "Landroidx/work/WorkInfo;", "work-runtime_release"})
    public static final class WorkInfoPojo {
        @ColumnInfo(name="id")
        @NotNull
        private String id;
        @ColumnInfo(name="state")
        @NotNull
        private WorkInfo.State state;
        @ColumnInfo(name="output")
        @NotNull
        private Data output;
        @ColumnInfo(name="run_attempt_count")
        private int runAttemptCount;
        @Relation(entity=WorkTag.class, parentColumn="id", entityColumn="work_spec_id", projection={"tag"})
        @NotNull
        private List<String> tags;
        @Relation(entity=WorkProgress.class, parentColumn="id", entityColumn="work_spec_id", projection={"progress"})
        @NotNull
        private List<Data> progress;

        public WorkInfoPojo(@NotNull String id, @NotNull WorkInfo.State state, @NotNull Data output, int runAttemptCount, @NotNull List<String> tags, @NotNull List<Data> progress) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            Intrinsics.checkNotNullParameter(progress, (String)"progress");
            this.id = id;
            this.state = state;
            this.output = output;
            this.runAttemptCount = runAttemptCount;
            this.tags = tags;
            this.progress = progress;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final void setId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.id = string;
        }

        @NotNull
        public final WorkInfo.State getState() {
            return this.state;
        }

        public final void setState(@NotNull WorkInfo.State state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
            this.state = state;
        }

        @NotNull
        public final Data getOutput() {
            return this.output;
        }

        public final void setOutput(@NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"<set-?>");
            this.output = data;
        }

        public final int getRunAttemptCount() {
            return this.runAttemptCount;
        }

        public final void setRunAttemptCount(int n) {
            this.runAttemptCount = n;
        }

        @NotNull
        public final List<String> getTags() {
            return this.tags;
        }

        public final void setTags(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.tags = list;
        }

        @NotNull
        public final List<Data> getProgress() {
            return this.progress;
        }

        public final void setProgress(@NotNull List<Data> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.progress = list;
        }

        @NotNull
        public final WorkInfo toWorkInfo() {
            Data progress = !((Collection)this.progress).isEmpty() ? this.progress.get(0) : Data.EMPTY;
            return new WorkInfo(UUID.fromString(this.id), this.state, this.output, this.tags, progress, this.runAttemptCount);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final WorkInfo.State component2() {
            return this.state;
        }

        @NotNull
        public final Data component3() {
            return this.output;
        }

        public final int component4() {
            return this.runAttemptCount;
        }

        @NotNull
        public final List<String> component5() {
            return this.tags;
        }

        @NotNull
        public final List<Data> component6() {
            return this.progress;
        }

        @NotNull
        public final WorkInfoPojo copy(@NotNull String id, @NotNull WorkInfo.State state, @NotNull Data output, int runAttemptCount, @NotNull List<String> tags, @NotNull List<Data> progress) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            Intrinsics.checkNotNullParameter(progress, (String)"progress");
            return new WorkInfoPojo(id, state, output, runAttemptCount, tags, progress);
        }

        public static /* synthetic */ WorkInfoPojo copy$default(WorkInfoPojo workInfoPojo, String string, WorkInfo.State state, Data data, int n, List list, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = workInfoPojo.id;
            }
            if ((n2 & 2) != 0) {
                state = workInfoPojo.state;
            }
            if ((n2 & 4) != 0) {
                data = workInfoPojo.output;
            }
            if ((n2 & 8) != 0) {
                n = workInfoPojo.runAttemptCount;
            }
            if ((n2 & 0x10) != 0) {
                list = workInfoPojo.tags;
            }
            if ((n2 & 0x20) != 0) {
                list2 = workInfoPojo.progress;
            }
            return workInfoPojo.copy(string, state, data, n, list, list2);
        }

        @NotNull
        public String toString() {
            return "WorkInfoPojo(id=" + this.id + ", state=" + (Object)((Object)this.state) + ", output=" + this.output + ", runAttemptCount=" + this.runAttemptCount + ", tags=" + this.tags + ", progress=" + this.progress + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.state.hashCode();
            result = result * 31 + this.output.hashCode();
            result = result * 31 + Integer.hashCode(this.runAttemptCount);
            result = result * 31 + ((Object)this.tags).hashCode();
            result = result * 31 + ((Object)this.progress).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WorkInfoPojo)) {
                return false;
            }
            WorkInfoPojo workInfoPojo = (WorkInfoPojo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)workInfoPojo.id)) {
                return false;
            }
            if (this.state != workInfoPojo.state) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.output, (Object)workInfoPojo.output)) {
                return false;
            }
            if (this.runAttemptCount != workInfoPojo.runAttemptCount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tags, workInfoPojo.tags)) {
                return false;
            }
            return Intrinsics.areEqual(this.progress, workInfoPojo.progress);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/work/impl/model/WorkSpec$Companion;", "", "()V", "SCHEDULE_NOT_REQUESTED_YET", "", "TAG", "", "WORK_INFO_MAPPER", "Landroidx/arch/core/util/Function;", "", "Landroidx/work/impl/model/WorkSpec$WorkInfoPojo;", "Landroidx/work/WorkInfo;", "work-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

