/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.greedy;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.StartStopTokens;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.greedy.DelayedWorkTracker;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerImpl;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.ProcessUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GreedyScheduler
implements Scheduler,
WorkConstraintsCallback,
ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("GreedyScheduler");
    private final Context mContext;
    private final WorkManagerImpl mWorkManagerImpl;
    private final WorkConstraintsTracker mWorkConstraintsTracker;
    private final Set<WorkSpec> mConstrainedWorkSpecs = new HashSet<WorkSpec>();
    private DelayedWorkTracker mDelayedWorkTracker;
    private boolean mRegisteredExecutionListener;
    private final Object mLock;
    private final StartStopTokens mStartStopTokens = new StartStopTokens();
    Boolean mInDefaultProcess;

    public GreedyScheduler(@NonNull Context context, @NonNull Configuration configuration, @NonNull Trackers trackers, @NonNull WorkManagerImpl workManagerImpl) {
        this.mContext = context;
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = new WorkConstraintsTrackerImpl(trackers, this);
        this.mDelayedWorkTracker = new DelayedWorkTracker(this, configuration.getRunnableScheduler());
        this.mLock = new Object();
    }

    @VisibleForTesting
    public GreedyScheduler(@NonNull Context context, @NonNull WorkManagerImpl workManagerImpl, @NonNull WorkConstraintsTracker workConstraintsTracker) {
        this.mContext = context;
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = workConstraintsTracker;
        this.mLock = new Object();
    }

    @VisibleForTesting
    public void setDelayedWorkTracker(@NonNull DelayedWorkTracker delayedWorkTracker) {
        this.mDelayedWorkTracker = delayedWorkTracker;
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        if (this.mInDefaultProcess == null) {
            this.checkDefaultProcess();
        }
        if (!this.mInDefaultProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in a secondary process");
            return;
        }
        this.registerExecutionListenerIfNeeded();
        HashSet<WorkSpec> constrainedWorkSpecs = new HashSet<WorkSpec>();
        HashSet<String> constrainedWorkSpecIds = new HashSet<String>();
        for (WorkSpec workSpec : workSpecs) {
            long nextRunTime = workSpec.calculateNextRunTime();
            long now = System.currentTimeMillis();
            if (workSpec.state != WorkInfo.State.ENQUEUED) continue;
            if (now < nextRunTime) {
                if (this.mDelayedWorkTracker == null) continue;
                this.mDelayedWorkTracker.schedule(workSpec);
                continue;
            }
            if (workSpec.hasConstraints()) {
                if (Build.VERSION.SDK_INT >= 23 && workSpec.constraints.requiresDeviceIdle()) {
                    Logger.get().debug(TAG, "Ignoring " + workSpec + ". Requires device idle.");
                    continue;
                }
                if (Build.VERSION.SDK_INT >= 24 && workSpec.constraints.hasContentUriTriggers()) {
                    Logger.get().debug(TAG, "Ignoring " + workSpec + ". Requires ContentUri triggers.");
                    continue;
                }
                constrainedWorkSpecs.add(workSpec);
                constrainedWorkSpecIds.add(workSpec.id);
                continue;
            }
            Logger.get().debug(TAG, "Starting work for " + workSpec.id);
            this.mWorkManagerImpl.startWork(this.mStartStopTokens.tokenFor(workSpec));
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!constrainedWorkSpecs.isEmpty()) {
                String formattedIds = TextUtils.join((CharSequence)",", constrainedWorkSpecIds);
                Logger.get().debug(TAG, "Starting tracking for " + formattedIds);
                this.mConstrainedWorkSpecs.addAll(constrainedWorkSpecs);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
            }
        }
    }

    private void checkDefaultProcess() {
        Configuration configuration = this.mWorkManagerImpl.getConfiguration();
        this.mInDefaultProcess = ProcessUtils.isDefaultProcess(this.mContext, configuration);
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        if (this.mInDefaultProcess == null) {
            this.checkDefaultProcess();
        }
        if (!this.mInDefaultProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in non-main process");
            return;
        }
        this.registerExecutionListenerIfNeeded();
        Logger.get().debug(TAG, "Cancelling work ID " + workSpecId);
        if (this.mDelayedWorkTracker != null) {
            this.mDelayedWorkTracker.unschedule(workSpecId);
        }
        for (StartStopToken id : this.mStartStopTokens.remove(workSpecId)) {
            this.mWorkManagerImpl.stopWork(id);
        }
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<WorkSpec> workSpecs) {
        for (WorkSpec workSpec : workSpecs) {
            WorkGenerationalId id = WorkSpecKt.generationalId(workSpec);
            Logger.get().debug(TAG, "Constraints met: Scheduling work ID " + id);
            this.mWorkManagerImpl.startWork(this.mStartStopTokens.tokenFor(id));
        }
    }

    @Override
    public void onAllConstraintsNotMet(@NonNull List<WorkSpec> workSpecs) {
        for (WorkSpec workSpec : workSpecs) {
            WorkGenerationalId id = WorkSpecKt.generationalId(workSpec);
            Logger.get().debug(TAG, "Constraints not met: Cancelling work ID " + id);
            StartStopToken runId = this.mStartStopTokens.remove(id);
            if (runId == null) continue;
            this.mWorkManagerImpl.stopWork(runId);
        }
    }

    @Override
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        this.mStartStopTokens.remove(id);
        this.removeConstraintTrackingFor(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstraintTrackingFor(@NonNull WorkGenerationalId id) {
        Object object = this.mLock;
        synchronized (object) {
            for (WorkSpec constrainedWorkSpec : this.mConstrainedWorkSpecs) {
                if (!WorkSpecKt.generationalId(constrainedWorkSpec).equals(id)) continue;
                Logger.get().debug(TAG, "Stopping tracking for " + id);
                this.mConstrainedWorkSpecs.remove(constrainedWorkSpec);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
                break;
            }
        }
    }

    private void registerExecutionListenerIfNeeded() {
        if (!this.mRegisteredExecutionListener) {
            this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
            this.mRegisteredExecutionListener = true;
        }
    }
}

