/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.RunnableScheduler;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkTimer {
    private static final String TAG = Logger.tagWithPrefix("WorkTimer");
    final RunnableScheduler mRunnableScheduler;
    final Map<String, WorkTimerRunnable> mTimerMap = new HashMap<String, WorkTimerRunnable>();
    final Map<String, TimeLimitExceededListener> mListeners = new HashMap<String, TimeLimitExceededListener>();
    final Object mLock = new Object();

    public WorkTimer(@NonNull RunnableScheduler scheduler) {
        this.mRunnableScheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(@NonNull String workSpecId, long processingTimeMillis, @NonNull TimeLimitExceededListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Starting timer for " + workSpecId);
            this.stopTimer(workSpecId);
            WorkTimerRunnable runnable = new WorkTimerRunnable(this, workSpecId);
            this.mTimerMap.put(workSpecId, runnable);
            this.mListeners.put(workSpecId, listener);
            this.mRunnableScheduler.scheduleWithDelay(processingTimeMillis, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            WorkTimerRunnable removed = this.mTimerMap.remove(workSpecId);
            if (removed != null) {
                Logger.get().debug(TAG, "Stopping timer for " + workSpecId);
                this.mListeners.remove(workSpecId);
            }
        }
    }

    @VisibleForTesting
    @NonNull
    public synchronized Map<String, WorkTimerRunnable> getTimerMap() {
        return this.mTimerMap;
    }

    @VisibleForTesting
    @NonNull
    public synchronized Map<String, TimeLimitExceededListener> getListeners() {
        return this.mListeners;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface TimeLimitExceededListener {
        public void onTimeLimitExceeded(@NonNull String var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class WorkTimerRunnable
    implements Runnable {
        static final String TAG = "WrkTimerRunnable";
        private final WorkTimer mWorkTimer;
        private final String mWorkSpecId;

        WorkTimerRunnable(@NonNull WorkTimer workTimer, @NonNull String workSpecId) {
            this.mWorkTimer = workTimer;
            this.mWorkSpecId = workSpecId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mWorkTimer.mLock;
            synchronized (object) {
                WorkTimerRunnable removed = this.mWorkTimer.mTimerMap.remove(this.mWorkSpecId);
                if (removed != null) {
                    TimeLimitExceededListener listener = this.mWorkTimer.mListeners.remove(this.mWorkSpecId);
                    if (listener != null) {
                        listener.onTimeLimitExceeded(this.mWorkSpecId);
                    }
                } else {
                    Logger.get().debug(TAG, String.format("Timer with %s is already marked as complete.", this.mWorkSpecId));
                }
            }
        }
    }
}

