/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LiveDataUtils {
    public static <In, Out> LiveData<Out> dedupedMappedLiveDataFor(@NonNull LiveData<In> inputLiveData, final @NonNull Function<In, Out> mappingMethod, final @NonNull TaskExecutor workTaskExecutor) {
        final Object lock = new Object();
        final MediatorLiveData outputLiveData = new MediatorLiveData();
        outputLiveData.addSource(inputLiveData, new Observer<In>(){
            Out mCurrentOutput = null;

            public void onChanged(final @Nullable In input) {
                workTaskExecutor.executeOnTaskThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = lock;
                        synchronized (object) {
                            Object newOutput = mappingMethod.apply(input);
                            if (mCurrentOutput == null && newOutput != null) {
                                mCurrentOutput = newOutput;
                                outputLiveData.postValue(newOutput);
                            } else if (mCurrentOutput != null && !mCurrentOutput.equals(newOutput)) {
                                mCurrentOutput = newOutput;
                                outputLiveData.postValue(newOutput);
                            }
                        }
                    }
                });
            }
        });
        return outputLiveData;
    }

    private LiveDataUtils() {
    }
}

