/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.work.Configuration;
import androidx.work.Data;
import androidx.work.InputMerger;
import androidx.work.InputMergerFactory;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.WorkerParameters;
import androidx.work.impl.Scheduler;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemalarm.RescheduleReceiver;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.utils.PackageManagerHelper;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.WorkForegroundRunnable;
import androidx.work.impl.utils.WorkForegroundUpdater;
import androidx.work.impl.utils.WorkProgressUpdater;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkerWrapper
implements Runnable {
    static final String TAG = Logger.tagWithPrefix("WorkerWrapper");
    Context mAppContext;
    private String mWorkSpecId;
    private List<Scheduler> mSchedulers;
    private WorkerParameters.RuntimeExtras mRuntimeExtras;
    WorkSpec mWorkSpec;
    ListenableWorker mWorker;
    TaskExecutor mWorkTaskExecutor;
    @NonNull
    ListenableWorker.Result mResult = ListenableWorker.Result.failure();
    private Configuration mConfiguration;
    private ForegroundProcessor mForegroundProcessor;
    private WorkDatabase mWorkDatabase;
    private WorkSpecDao mWorkSpecDao;
    private DependencyDao mDependencyDao;
    private WorkTagDao mWorkTagDao;
    private List<String> mTags;
    private String mWorkDescription;
    @NonNull
    SettableFuture<Boolean> mFuture = SettableFuture.create();
    @NonNull
    final SettableFuture<ListenableWorker.Result> mWorkerResultFuture = SettableFuture.create();
    private volatile boolean mInterrupted;

    WorkerWrapper(@NonNull Builder builder) {
        this.mAppContext = builder.mAppContext;
        this.mWorkTaskExecutor = builder.mWorkTaskExecutor;
        this.mForegroundProcessor = builder.mForegroundProcessor;
        this.mWorkSpecId = builder.mWorkSpecId;
        this.mSchedulers = builder.mSchedulers;
        this.mRuntimeExtras = builder.mRuntimeExtras;
        this.mWorker = builder.mWorker;
        this.mConfiguration = builder.mConfiguration;
        this.mWorkDatabase = builder.mWorkDatabase;
        this.mWorkSpecDao = this.mWorkDatabase.workSpecDao();
        this.mDependencyDao = this.mWorkDatabase.dependencyDao();
        this.mWorkTagDao = this.mWorkDatabase.workTagDao();
    }

    @NonNull
    public ListenableFuture<Boolean> getFuture() {
        return this.mFuture;
    }

    @Override
    @WorkerThread
    public void run() {
        this.mTags = this.mWorkTagDao.getTagsForWorkSpecId(this.mWorkSpecId);
        this.mWorkDescription = this.createWorkDescription(this.mTags);
        this.runWorker();
    }

    private void runWorker() {
        Data input;
        if (this.tryCheckForInterruptionAndResolve()) {
            return;
        }
        this.mWorkDatabase.beginTransaction();
        try {
            long now;
            this.mWorkSpec = this.mWorkSpecDao.getWorkSpec(this.mWorkSpecId);
            if (this.mWorkSpec == null) {
                Logger.get().error(TAG, "Didn't find WorkSpec for id " + this.mWorkSpecId);
                this.resolve(false);
                this.mWorkDatabase.setTransactionSuccessful();
                return;
            }
            if (this.mWorkSpec.state != WorkInfo.State.ENQUEUED) {
                this.resolveIncorrectStatus();
                this.mWorkDatabase.setTransactionSuccessful();
                Logger.get().debug(TAG, this.mWorkSpec.workerClassName + " is not in ENQUEUED state. Nothing more to do");
                return;
            }
            if ((this.mWorkSpec.isPeriodic() || this.mWorkSpec.isBackedOff()) && (now = System.currentTimeMillis()) < this.mWorkSpec.calculateNextRunTime()) {
                Logger.get().debug(TAG, String.format("Delaying execution for %s because it is being executed before schedule.", this.mWorkSpec.workerClassName));
                this.resolve(true);
                this.mWorkDatabase.setTransactionSuccessful();
                return;
            }
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
        }
        if (this.mWorkSpec.isPeriodic()) {
            input = this.mWorkSpec.input;
        } else {
            String inputMergerClassName;
            InputMergerFactory inputMergerFactory = this.mConfiguration.getInputMergerFactory();
            InputMerger inputMerger = inputMergerFactory.createInputMergerWithDefaultFallback(inputMergerClassName = this.mWorkSpec.inputMergerClassName);
            if (inputMerger == null) {
                Logger.get().error(TAG, "Could not create Input Merger " + this.mWorkSpec.inputMergerClassName);
                this.setFailedAndResolve();
                return;
            }
            ArrayList<Data> inputs = new ArrayList<Data>();
            inputs.add(this.mWorkSpec.input);
            inputs.addAll(this.mWorkSpecDao.getInputsFromPrerequisites(this.mWorkSpecId));
            input = inputMerger.merge(inputs);
        }
        WorkerParameters params = new WorkerParameters(UUID.fromString(this.mWorkSpecId), input, this.mTags, this.mRuntimeExtras, this.mWorkSpec.runAttemptCount, this.mConfiguration.getExecutor(), this.mWorkTaskExecutor, this.mConfiguration.getWorkerFactory(), new WorkProgressUpdater(this.mWorkDatabase, this.mWorkTaskExecutor), new WorkForegroundUpdater(this.mWorkDatabase, this.mForegroundProcessor, this.mWorkTaskExecutor));
        if (this.mWorker == null) {
            this.mWorker = this.mConfiguration.getWorkerFactory().createWorkerWithDefaultFallback(this.mAppContext, this.mWorkSpec.workerClassName, params);
        }
        if (this.mWorker == null) {
            Logger.get().error(TAG, "Could not create Worker " + this.mWorkSpec.workerClassName);
            this.setFailedAndResolve();
            return;
        }
        if (this.mWorker.isUsed()) {
            Logger.get().error(TAG, "Received an already-used Worker " + this.mWorkSpec.workerClassName + "; Worker Factory should return new instances");
            this.setFailedAndResolve();
            return;
        }
        this.mWorker.setUsed();
        if (this.trySetRunning()) {
            if (this.tryCheckForInterruptionAndResolve()) {
                return;
            }
            WorkForegroundRunnable foregroundRunnable = new WorkForegroundRunnable(this.mAppContext, this.mWorkSpec, this.mWorker, params.getForegroundUpdater(), this.mWorkTaskExecutor);
            this.mWorkTaskExecutor.getMainThreadExecutor().execute(foregroundRunnable);
            final ListenableFuture<Void> runExpedited = foregroundRunnable.getFuture();
            this.mWorkerResultFuture.addListener(() -> {
                if (this.mWorkerResultFuture.isCancelled()) {
                    runExpedited.cancel(true);
                }
            }, new SynchronousExecutor());
            runExpedited.addListener(new Runnable(){

                @Override
                public void run() {
                    if (WorkerWrapper.this.mWorkerResultFuture.isCancelled()) {
                        return;
                    }
                    try {
                        runExpedited.get();
                        Logger.get().debug(TAG, "Starting work for " + WorkerWrapper.this.mWorkSpec.workerClassName);
                        WorkerWrapper.this.mWorkerResultFuture.setFuture(WorkerWrapper.this.mWorker.startWork());
                    }
                    catch (Throwable e) {
                        WorkerWrapper.this.mWorkerResultFuture.setException(e);
                    }
                }
            }, this.mWorkTaskExecutor.getMainThreadExecutor());
            final String workDescription = this.mWorkDescription;
            this.mWorkerResultFuture.addListener(new Runnable(){

                @Override
                @SuppressLint(value={"SyntheticAccessor"})
                public void run() {
                    try {
                        ListenableWorker.Result result = (ListenableWorker.Result)WorkerWrapper.this.mWorkerResultFuture.get();
                        if (result == null) {
                            Logger.get().error(TAG, WorkerWrapper.this.mWorkSpec.workerClassName + " returned a null result. Treating it as a failure.");
                        } else {
                            Logger.get().debug(TAG, WorkerWrapper.this.mWorkSpec.workerClassName + " returned a " + result + ".");
                            WorkerWrapper.this.mResult = result;
                        }
                    }
                    catch (CancellationException exception) {
                        Logger.get().info(TAG, workDescription + " was cancelled", exception);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        Logger.get().error(TAG, workDescription + " failed because it threw an exception/error", exception);
                    }
                    finally {
                        WorkerWrapper.this.onWorkFinished();
                    }
                }
            }, this.mWorkTaskExecutor.getSerialTaskExecutor());
        } else {
            this.resolveIncorrectStatus();
        }
    }

    void onWorkFinished() {
        if (!this.tryCheckForInterruptionAndResolve()) {
            this.mWorkDatabase.beginTransaction();
            try {
                WorkInfo.State state = this.mWorkSpecDao.getState(this.mWorkSpecId);
                this.mWorkDatabase.workProgressDao().delete(this.mWorkSpecId);
                if (state == null) {
                    this.resolve(false);
                } else if (state == WorkInfo.State.RUNNING) {
                    this.handleResult(this.mResult);
                } else if (!state.isFinished()) {
                    this.rescheduleAndResolve();
                }
                this.mWorkDatabase.setTransactionSuccessful();
            }
            finally {
                this.mWorkDatabase.endTransaction();
            }
        }
        if (this.mSchedulers != null) {
            for (Scheduler scheduler : this.mSchedulers) {
                scheduler.cancel(this.mWorkSpecId);
            }
            Schedulers.schedule(this.mConfiguration, this.mWorkDatabase, this.mSchedulers);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void interrupt() {
        this.mInterrupted = true;
        this.tryCheckForInterruptionAndResolve();
        this.mWorkerResultFuture.cancel(true);
        if (this.mWorker != null && this.mWorkerResultFuture.isCancelled()) {
            this.mWorker.stop();
        } else {
            String message = "WorkSpec " + this.mWorkSpec + " is already done. Not interrupting.";
            Logger.get().debug(TAG, message);
        }
    }

    private void resolveIncorrectStatus() {
        WorkInfo.State status = this.mWorkSpecDao.getState(this.mWorkSpecId);
        if (status == WorkInfo.State.RUNNING) {
            Logger.get().debug(TAG, "Status for " + this.mWorkSpecId + " is RUNNING; not doing any work and rescheduling for later execution");
            this.resolve(true);
        } else {
            Logger.get().debug(TAG, "Status for " + this.mWorkSpecId + " is " + (Object)((Object)status) + " ; not doing any work");
            this.resolve(false);
        }
    }

    private boolean tryCheckForInterruptionAndResolve() {
        if (this.mInterrupted) {
            Logger.get().debug(TAG, "Work interrupted for " + this.mWorkDescription);
            WorkInfo.State currentState = this.mWorkSpecDao.getState(this.mWorkSpecId);
            if (currentState == null) {
                this.resolve(false);
            } else {
                this.resolve(!currentState.isFinished());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(boolean needsReschedule) {
        this.mWorkDatabase.beginTransaction();
        try {
            boolean isInForeground;
            boolean hasUnfinishedWork = this.mWorkDatabase.workSpecDao().hasUnfinishedWork();
            if (!hasUnfinishedWork) {
                PackageManagerHelper.setComponentEnabled(this.mAppContext, RescheduleReceiver.class, false);
            }
            if (needsReschedule) {
                this.mWorkSpecDao.setState(WorkInfo.State.ENQUEUED, this.mWorkSpecId);
                this.mWorkSpecDao.markWorkSpecScheduled(this.mWorkSpecId, -1L);
            }
            if (this.mWorkSpec != null && this.mWorker != null && (isInForeground = this.mForegroundProcessor.isEnqueuedInForeground(this.mWorkSpecId))) {
                this.mForegroundProcessor.stopForeground(this.mWorkSpecId);
            }
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
        }
        this.mFuture.set(needsReschedule);
    }

    private void handleResult(ListenableWorker.Result result) {
        if (result instanceof ListenableWorker.Result.Success) {
            Logger.get().info(TAG, "Worker result SUCCESS for " + this.mWorkDescription);
            if (this.mWorkSpec.isPeriodic()) {
                this.resetPeriodicAndResolve();
            } else {
                this.setSucceededAndResolve();
            }
        } else if (result instanceof ListenableWorker.Result.Retry) {
            Logger.get().info(TAG, "Worker result RETRY for " + this.mWorkDescription);
            this.rescheduleAndResolve();
        } else {
            Logger.get().info(TAG, "Worker result FAILURE for " + this.mWorkDescription);
            if (this.mWorkSpec.isPeriodic()) {
                this.resetPeriodicAndResolve();
            } else {
                this.setFailedAndResolve();
            }
        }
    }

    private boolean trySetRunning() {
        boolean setToRunning = false;
        this.mWorkDatabase.beginTransaction();
        try {
            WorkInfo.State currentState = this.mWorkSpecDao.getState(this.mWorkSpecId);
            if (currentState == WorkInfo.State.ENQUEUED) {
                this.mWorkSpecDao.setState(WorkInfo.State.RUNNING, this.mWorkSpecId);
                this.mWorkSpecDao.incrementWorkSpecRunAttemptCount(this.mWorkSpecId);
                setToRunning = true;
            }
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
        }
        return setToRunning;
    }

    @VisibleForTesting
    void setFailedAndResolve() {
        this.mWorkDatabase.beginTransaction();
        try {
            this.iterativelyFailWorkAndDependents(this.mWorkSpecId);
            ListenableWorker.Result.Failure failure = (ListenableWorker.Result.Failure)this.mResult;
            Data output = failure.getOutputData();
            this.mWorkSpecDao.setOutput(this.mWorkSpecId, output);
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
            this.resolve(false);
        }
    }

    private void iterativelyFailWorkAndDependents(String workSpecId) {
        LinkedList<String> idsToProcess = new LinkedList<String>();
        idsToProcess.add(workSpecId);
        while (!idsToProcess.isEmpty()) {
            String id = (String)idsToProcess.remove();
            if (this.mWorkSpecDao.getState(id) != WorkInfo.State.CANCELLED) {
                this.mWorkSpecDao.setState(WorkInfo.State.FAILED, id);
            }
            idsToProcess.addAll(this.mDependencyDao.getDependentWorkIds(id));
        }
    }

    private void rescheduleAndResolve() {
        this.mWorkDatabase.beginTransaction();
        try {
            this.mWorkSpecDao.setState(WorkInfo.State.ENQUEUED, this.mWorkSpecId);
            this.mWorkSpecDao.setLastEnqueuedTime(this.mWorkSpecId, System.currentTimeMillis());
            this.mWorkSpecDao.markWorkSpecScheduled(this.mWorkSpecId, -1L);
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
            this.resolve(true);
        }
    }

    private void resetPeriodicAndResolve() {
        this.mWorkDatabase.beginTransaction();
        try {
            this.mWorkSpecDao.setLastEnqueuedTime(this.mWorkSpecId, System.currentTimeMillis());
            this.mWorkSpecDao.setState(WorkInfo.State.ENQUEUED, this.mWorkSpecId);
            this.mWorkSpecDao.resetWorkSpecRunAttemptCount(this.mWorkSpecId);
            this.mWorkSpecDao.incrementPeriodCount(this.mWorkSpecId);
            this.mWorkSpecDao.markWorkSpecScheduled(this.mWorkSpecId, -1L);
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
            this.resolve(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSucceededAndResolve() {
        this.mWorkDatabase.beginTransaction();
        try {
            this.mWorkSpecDao.setState(WorkInfo.State.SUCCEEDED, this.mWorkSpecId);
            ListenableWorker.Result.Success success = (ListenableWorker.Result.Success)this.mResult;
            Data output = success.getOutputData();
            this.mWorkSpecDao.setOutput(this.mWorkSpecId, output);
            long currentTimeMillis = System.currentTimeMillis();
            List<String> dependentWorkIds = this.mDependencyDao.getDependentWorkIds(this.mWorkSpecId);
            for (String dependentWorkId : dependentWorkIds) {
                if (this.mWorkSpecDao.getState(dependentWorkId) != WorkInfo.State.BLOCKED || !this.mDependencyDao.hasCompletedAllPrerequisites(dependentWorkId)) continue;
                Logger.get().info(TAG, "Setting status to enqueued for " + dependentWorkId);
                this.mWorkSpecDao.setState(WorkInfo.State.ENQUEUED, dependentWorkId);
                this.mWorkSpecDao.setLastEnqueuedTime(dependentWorkId, currentTimeMillis);
            }
            this.mWorkDatabase.setTransactionSuccessful();
        }
        finally {
            this.mWorkDatabase.endTransaction();
            this.resolve(false);
        }
    }

    private String createWorkDescription(List<String> tags) {
        StringBuilder sb = new StringBuilder("Work [ id=").append(this.mWorkSpecId).append(", tags={ ");
        boolean first = true;
        for (String tag : tags) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(tag);
        }
        sb.append(" } ]");
        return sb.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        @NonNull
        Context mAppContext;
        @Nullable
        ListenableWorker mWorker;
        @NonNull
        ForegroundProcessor mForegroundProcessor;
        @NonNull
        TaskExecutor mWorkTaskExecutor;
        @NonNull
        Configuration mConfiguration;
        @NonNull
        WorkDatabase mWorkDatabase;
        @NonNull
        String mWorkSpecId;
        List<Scheduler> mSchedulers;
        @NonNull
        WorkerParameters.RuntimeExtras mRuntimeExtras = new WorkerParameters.RuntimeExtras();

        public Builder(@NonNull Context context, @NonNull Configuration configuration, @NonNull TaskExecutor workTaskExecutor, @NonNull ForegroundProcessor foregroundProcessor, @NonNull WorkDatabase database, @NonNull String workSpecId) {
            this.mAppContext = context.getApplicationContext();
            this.mWorkTaskExecutor = workTaskExecutor;
            this.mForegroundProcessor = foregroundProcessor;
            this.mConfiguration = configuration;
            this.mWorkDatabase = database;
            this.mWorkSpecId = workSpecId;
        }

        @NonNull
        public Builder withSchedulers(@NonNull List<Scheduler> schedulers) {
            this.mSchedulers = schedulers;
            return this;
        }

        @NonNull
        public Builder withRuntimeExtras(@Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
            if (runtimeExtras != null) {
                this.mRuntimeExtras = runtimeExtras;
            }
            return this;
        }

        @NonNull
        @VisibleForTesting
        public Builder withWorker(@NonNull ListenableWorker worker) {
            this.mWorker = worker;
            return this;
        }

        @NonNull
        public WorkerWrapper build() {
            return new WorkerWrapper(this);
        }
    }
}

