/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.work.Operation;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class OperationImpl
implements Operation {
    private final MutableLiveData<Operation.State> mOperationState = new MutableLiveData();
    private final SettableFuture<Operation.State.SUCCESS> mOperationFuture = SettableFuture.create();

    public OperationImpl() {
        this.setState(Operation.IN_PROGRESS);
    }

    @Override
    @NonNull
    public ListenableFuture<Operation.State.SUCCESS> getResult() {
        return this.mOperationFuture;
    }

    @Override
    @NonNull
    public LiveData<Operation.State> getState() {
        return this.mOperationState;
    }

    public void setState(@NonNull Operation.State state) {
        this.mOperationState.postValue((Object)state);
        if (state instanceof Operation.State.SUCCESS) {
            this.mOperationFuture.set((Operation.State.SUCCESS)state);
        } else if (state instanceof Operation.State.FAILURE) {
            Operation.State.FAILURE failed = (Operation.State.FAILURE)state;
            this.mOperationFuture.setException(failed.getThrowable());
        }
    }
}

