/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import androidx.annotation.RestrictTo;
import androidx.work.DirectExecutor;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.impl.ToContinuation;
import androidx.work.impl.WorkerStoppedException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a&\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0087@\u00a2\u0006\u0002\u0010\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"TAG", "", "getUninterruptibly", "V", "future", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;)Ljava/lang/Object;", "awaitWithin", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "worker", "Landroidx/work/ListenableWorker;", "(Lcom/google/common/util/concurrent/ListenableFuture;Landroidx/work/ListenableWorker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nonNullCause", "", "Ljava/util/concurrent/ExecutionException;", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nWorkerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapperKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,591:1\n314#2,11:592\n*S KotlinDebug\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapperKt\n*L\n532#1:592,11\n*E\n"})
public final class WorkerWrapperKt {
    @NotNull
    private static final String TAG;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final <T> Object awaitWithin(@NotNull ListenableFuture<T> $this$awaitWithin, @NotNull ListenableWorker worker, @NotNull Continuation<? super T> $completion) {
        try {
            if ($this$awaitWithin.isDone()) {
                return WorkerWrapperKt.getUninterruptibly((Future)$this$awaitWithin);
            }
        }
        catch (ExecutionException e) {
            throw WorkerWrapperKt.nonNullCause(e);
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super T> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        $this$awaitWithin.addListener((Runnable)new ToContinuation<T>($this$awaitWithin, cont), (Executor)DirectExecutor.INSTANCE);
        cont.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(worker, $this$awaitWithin){
            final /* synthetic */ ListenableWorker $worker;
            final /* synthetic */ ListenableFuture<T> $this_awaitWithin;
            {
                this.$worker = $worker;
                this.$this_awaitWithin = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (it instanceof WorkerStoppedException) {
                    this.$worker.stop(((WorkerStoppedException)it).getReason());
                }
                this.$this_awaitWithin.cancel(false);
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <V> V getUninterruptibly(Future<V> future) {
        boolean interrupted = false;
        try {
            while (true) {
                V v;
                try {
                    v = future.get();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                return v;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final Throwable nonNullCause(ExecutionException $this$nonNullCause) {
        Throwable throwable = $this$nonNullCause.getCause();
        Intrinsics.checkNotNull((Object)throwable);
        return throwable;
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    public static final /* synthetic */ Object access$getUninterruptibly(Future future) {
        return WorkerWrapperKt.getUninterruptibly(future);
    }

    public static final /* synthetic */ Throwable access$nonNullCause(ExecutionException $receiver) {
        return WorkerWrapperKt.nonNullCause($receiver);
    }

    static {
        String string = Logger.tagWithPrefix("WorkerWrapper");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"WorkerWrapper\")");
        TAG = string;
    }
}

