/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.annotation.SuppressLint;
import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import androidx.work.Data;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import java.util.List;
import kotlin.Metadata;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0019\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H'J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u000fH'J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0003H'J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH'J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0016\u001a\u00020\u0017H'J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH'J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH'J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001e\u001a\u00020\u0007H'J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010 \u001a\u00020\u0007H'J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t2\u0006\u0010\u001e\u001a\u00020\u0007H'J\"\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0%2\u0006\u0010\u001e\u001a\u00020\u0007H'J\u001c\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0%2\u0006\u0010 \u001a\u00020\u0007H'J\u0012\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\t2\u0006\u0010\u001e\u001a\u00020\u0007H'J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020&0\t2\u0006\u0010 \u001a\u00020\u0007H'J\"\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0\u000f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u001c\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0\u000f2\u0006\u0010\u001e\u001a\u00020\u0007H'J\u001c\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\t0\u000f2\u0006\u0010 \u001a\u00020\u0007H'J\b\u00101\u001a\u000202H'J\u0010\u00103\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\nH'J\u0018\u00108\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0017H'J\b\u0010:\u001a\u00020\u0005H'J\b\u0010;\u001a\u00020\u0003H'J\u0018\u0010<\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u0003H'J\u0010\u0010>\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010?\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0018\u0010@\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0017H'J\u0018\u0010B\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0017H'J\u0018\u0010D\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u0014H'J\u0018\u0010F\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0018\u0010H\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u0003H'J\u0010\u0010J\u001a\u00020\u00052\u0006\u00107\u001a\u00020\nH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006K\u00c0\u0006\u0001"}, d2={"Landroidx/work/impl/model/WorkSpecDao;", "", "countNonFinishedContentUriTriggerWorkers", "", "delete", "", "id", "", "getAllEligibleWorkSpecsForScheduling", "", "Landroidx/work/impl/model/WorkSpec;", "maxLimit", "getAllUnfinishedWork", "getAllWorkSpecIds", "getAllWorkSpecIdsLiveData", "Landroidx/lifecycle/LiveData;", "getEligibleWorkForScheduling", "schedulerLimit", "getEligibleWorkForSchedulingWithContentUris", "getInputsFromPrerequisites", "Landroidx/work/Data;", "getRecentlyCompletedWork", "startingAt", "", "getRunningWork", "getScheduleRequestedAtLiveData", "getScheduledWork", "getState", "Landroidx/work/WorkInfo$State;", "getUnfinishedWorkWithName", "name", "getUnfinishedWorkWithTag", "tag", "getWorkSpec", "getWorkSpecIdAndStatesForName", "Landroidx/work/impl/model/WorkSpec$IdAndState;", "getWorkStatusPojoFlowDataForIds", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/work/impl/model/WorkSpec$WorkInfoPojo;", "ids", "getWorkStatusPojoFlowForName", "getWorkStatusPojoFlowForTag", "getWorkStatusPojoForId", "getWorkStatusPojoForIds", "getWorkStatusPojoForName", "getWorkStatusPojoForTag", "getWorkStatusPojoLiveDataForIds", "getWorkStatusPojoLiveDataForName", "getWorkStatusPojoLiveDataForTag", "hasUnfinishedWork", "", "incrementGeneration", "incrementPeriodCount", "incrementWorkSpecRunAttemptCount", "insertWorkSpec", "workSpec", "markWorkSpecScheduled", "startTime", "pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast", "resetScheduledState", "resetWorkSpecNextScheduleTimeOverride", "overrideGeneration", "resetWorkSpecRunAttemptCount", "setCancelledState", "setLastEnqueueTime", "enqueueTime", "setNextScheduleTimeOverride", "nextScheduleTimeOverrideMillis", "setOutput", "output", "setState", "state", "setStopReason", "stopReason", "updateWorkSpec", "work-runtime_release"})
@Dao
@SuppressLint(value={"UnknownNullness"})
public interface WorkSpecDao {
    @Insert(onConflict=5)
    public void insertWorkSpec(@NotNull WorkSpec var1);

    @Query(value="DELETE FROM workspec WHERE id=:id")
    public void delete(@NotNull String var1);

    @Query(value="SELECT * FROM workspec WHERE id=:id")
    @Nullable
    public WorkSpec getWorkSpec(@NotNull String var1);

    @Query(value="SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    @NotNull
    public List<WorkSpec.IdAndState> getWorkSpecIdAndStatesForName(@NotNull String var1);

    @Query(value="SELECT id FROM workspec")
    @NotNull
    public List<String> getAllWorkSpecIds();

    @Transaction
    @Query(value="SELECT id FROM workspec")
    @NotNull
    public LiveData<List<String>> getAllWorkSpecIdsLiveData();

    @Query(value="UPDATE workspec SET state=:state WHERE id=:id")
    public int setState(@NotNull WorkInfo.State var1, @NotNull String var2);

    @Query(value="UPDATE workspec SET stop_reason = CASE WHEN state=1 THEN 1 ELSE -256 END, state=5 WHERE id=:id")
    public int setCancelledState(@NotNull String var1);

    @Query(value="UPDATE workspec SET period_count=period_count+1 WHERE id=:id")
    public void incrementPeriodCount(@NotNull String var1);

    @Query(value="UPDATE workspec SET output=:output WHERE id=:id")
    public void setOutput(@NotNull String var1, @NotNull Data var2);

    @Query(value="UPDATE workspec SET last_enqueue_time=:enqueueTime WHERE id=:id")
    public void setLastEnqueueTime(@NotNull String var1, long var2);

    @Query(value="UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=:id")
    public int incrementWorkSpecRunAttemptCount(@NotNull String var1);

    @Query(value="UPDATE workspec SET run_attempt_count=0 WHERE id=:id")
    public int resetWorkSpecRunAttemptCount(@NotNull String var1);

    @Query(value="UPDATE workspec SET next_schedule_time_override=:nextScheduleTimeOverrideMillis WHERE id=:id")
    public void setNextScheduleTimeOverride(@NotNull String var1, long var2);

    @Query(value="UPDATE workspec SET next_schedule_time_override=9223372036854775807 WHERE (id=:id AND next_schedule_time_override_generation=:overrideGeneration)")
    public void resetWorkSpecNextScheduleTimeOverride(@NotNull String var1, int var2);

    @Query(value="SELECT state FROM workspec WHERE id=:id")
    @Nullable
    public WorkInfo.State getState(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id=:id")
    @Nullable
    public WorkSpec.WorkInfoPojo getWorkStatusPojoForId(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (:ids)")
    @NotNull
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForIds(@NotNull List<String> var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (:ids)")
    @NotNull
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForIds(@NotNull List<String> var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (:ids)")
    @NotNull
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowDataForIds(@NotNull List<String> var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    @NotNull
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForTag(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    @NotNull
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowForTag(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    @NotNull
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForTag(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    @NotNull
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForName(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    @NotNull
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForName(@NotNull String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    @NotNull
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowForName(@NotNull String var1);

    @Query(value="SELECT output FROM workspec WHERE id IN\n             (SELECT prerequisite_id FROM dependency WHERE work_spec_id=:id)")
    @NotNull
    public List<Data> getInputsFromPrerequisites(@NotNull String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    @NotNull
    public List<String> getUnfinishedWorkWithTag(@NotNull String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    @NotNull
    public List<String> getUnfinishedWorkWithName(@NotNull String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)")
    @NotNull
    public List<String> getAllUnfinishedWork();

    @Query(value="SELECT COUNT(*) > 0 FROM workspec WHERE state NOT IN (2, 3, 5) LIMIT 1")
    public boolean hasUnfinishedWork();

    @Query(value="UPDATE workspec SET schedule_requested_at=:startTime WHERE id=:id")
    public int markWorkSpecScheduled(@NotNull String var1, long var2);

    @Query(value="SELECT schedule_requested_at FROM workspec WHERE id=:id")
    @NotNull
    public LiveData<Long> getScheduleRequestedAtLiveData(@NotNull String var1);

    @Query(value="UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)")
    public int resetScheduledState();

    @Query(value="SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 ORDER BY last_enqueue_time LIMIT (SELECT MAX(:schedulerLimit-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND LENGTH(content_uri_triggers)=0 AND state NOT IN (2, 3, 5))")
    @NotNull
    public List<WorkSpec> getEligibleWorkForScheduling(int var1);

    @Query(value="SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 AND LENGTH(content_uri_triggers)<>0 ORDER BY last_enqueue_time")
    @NotNull
    public List<WorkSpec> getEligibleWorkForSchedulingWithContentUris();

    @Query(value="SELECT * FROM workspec WHERE state=0 ORDER BY last_enqueue_time LIMIT :maxLimit")
    @NotNull
    public List<WorkSpec> getAllEligibleWorkSpecsForScheduling(int var1);

    @Query(value="SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1")
    @NotNull
    public List<WorkSpec> getScheduledWork();

    @Query(value="SELECT * FROM workspec WHERE state=1")
    @NotNull
    public List<WorkSpec> getRunningWork();

    @Query(value="SELECT * FROM workspec WHERE last_enqueue_time >= :startingAt AND state IN (2, 3, 5) ORDER BY last_enqueue_time DESC")
    @NotNull
    public List<WorkSpec> getRecentlyCompletedWork(long var1);

    @Query(value="DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))")
    public void pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast();

    @Query(value="UPDATE workspec SET generation=generation+1 WHERE id=:id")
    public void incrementGeneration(@NotNull String var1);

    @Update
    public void updateWorkSpec(@NotNull WorkSpec var1);

    @Query(value="Select COUNT(*) FROM workspec WHERE LENGTH(content_uri_triggers)<>0 AND state NOT IN (2, 3, 5)")
    public int countNonFinishedContentUriTriggerWorkers();

    @Query(value="UPDATE workspec SET stop_reason=:stopReason WHERE id=:id")
    public void setStopReason(@NotNull String var1, int var2);
}

