/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemjob.SystemJobInfoConverter;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.IdGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
public class SystemJobScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix("SystemJobScheduler");
    private final JobScheduler mJobScheduler;
    private final WorkManagerImpl mWorkManager;
    private final IdGenerator mIdGenerator;
    private final SystemJobInfoConverter mSystemJobInfoConverter;

    public SystemJobScheduler(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this(context, workManager, (JobScheduler)context.getSystemService("jobscheduler"), new SystemJobInfoConverter(context));
    }

    @VisibleForTesting
    public SystemJobScheduler(Context context, WorkManagerImpl workManager, JobScheduler jobScheduler, SystemJobInfoConverter systemJobInfoConverter) {
        this.mWorkManager = workManager;
        this.mJobScheduler = jobScheduler;
        this.mIdGenerator = new IdGenerator(context);
        this.mSystemJobInfoConverter = systemJobInfoConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        WorkDatabase workDatabase = this.mWorkManager.getWorkDatabase();
        for (WorkSpec workSpec : workSpecs) {
            workDatabase.beginTransaction();
            try {
                int jobId;
                WorkSpec currentDbWorkSpec = workDatabase.workSpecDao().getWorkSpec(workSpec.id);
                if (currentDbWorkSpec == null) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it's no longer in the DB", new Throwable[0]);
                    continue;
                }
                if (currentDbWorkSpec.state != WorkInfo.State.ENQUEUED) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it is no longer enqueued", new Throwable[0]);
                    continue;
                }
                SystemIdInfo info = workDatabase.systemIdInfoDao().getSystemIdInfo(workSpec.id);
                int n = jobId = info != null ? info.systemId : this.mIdGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                if (info == null) {
                    SystemIdInfo newSystemIdInfo = new SystemIdInfo(workSpec.id, jobId);
                    this.mWorkManager.getWorkDatabase().systemIdInfoDao().insertSystemIdInfo(newSystemIdInfo);
                }
                this.scheduleInternal(workSpec, jobId);
                if (Build.VERSION.SDK_INT == 23) {
                    List<Integer> jobIds = SystemJobScheduler.getPendingJobIds(this.mJobScheduler, workSpec.id);
                    int index = jobIds.indexOf(jobId);
                    if (index >= 0) {
                        jobIds.remove(index);
                    }
                    int nextJobId = !jobIds.isEmpty() ? jobIds.get(0).intValue() : this.mIdGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                    this.scheduleInternal(workSpec, nextJobId);
                }
                workDatabase.setTransactionSuccessful();
            }
            finally {
                workDatabase.endTransaction();
            }
        }
    }

    @VisibleForTesting
    public void scheduleInternal(WorkSpec workSpec, int jobId) {
        JobInfo jobInfo = this.mSystemJobInfoConverter.convert(workSpec, jobId);
        Logger.get().debug(TAG, String.format("Scheduling work ID %s Job ID %s", workSpec.id, jobId), new Throwable[0]);
        try {
            this.mJobScheduler.schedule(jobInfo);
        }
        catch (IllegalStateException e) {
            int numWorkManagerJobs = 0;
            List allJobInfos = this.mJobScheduler.getAllPendingJobs();
            if (allJobInfos != null) {
                for (JobInfo currentJobInfo : allJobInfos) {
                    if (currentJobInfo.getExtras().getString("EXTRA_WORK_SPEC_ID") == null) continue;
                    ++numWorkManagerJobs;
                }
            }
            String message = String.format(Locale.getDefault(), "JobScheduler 100 job limit exceeded.  We count %d WorkManager jobs in JobScheduler; we have %d tracked jobs in our DB; our Configuration limit is %d.", numWorkManagerJobs, this.mWorkManager.getWorkDatabase().workSpecDao().getScheduledWork().size(), this.mWorkManager.getConfiguration().getMaxSchedulerLimit());
            Logger.get().error(TAG, message, new Throwable[0]);
            throw new IllegalStateException(message, e);
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        List allJobInfos = this.mJobScheduler.getAllPendingJobs();
        if (allJobInfos != null) {
            for (JobInfo jobInfo : allJobInfos) {
                if (!workSpecId.equals(jobInfo.getExtras().getString("EXTRA_WORK_SPEC_ID"))) continue;
                this.mWorkManager.getWorkDatabase().systemIdInfoDao().removeSystemIdInfo(workSpecId);
                this.mJobScheduler.cancel(jobInfo.getId());
                if (Build.VERSION.SDK_INT == 23) continue;
                return;
            }
        }
    }

    public static void jobSchedulerCancelAll(@NonNull Context context) {
        List jobInfos;
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null && (jobInfos = jobScheduler.getAllPendingJobs()) != null) {
            for (JobInfo jobInfo : jobInfos) {
                PersistableBundle extras = jobInfo.getExtras();
                if (!extras.containsKey("EXTRA_WORK_SPEC_ID")) continue;
                jobScheduler.cancel(jobInfo.getId());
            }
        }
    }

    private static List<Integer> getPendingJobIds(@NonNull JobScheduler jobScheduler, @NonNull String workSpecId) {
        ArrayList<Integer> pendingJobs = new ArrayList<Integer>(2);
        List jobInfos = jobScheduler.getAllPendingJobs();
        if (jobInfos != null) {
            for (JobInfo jobInfo : jobInfos) {
                PersistableBundle extras = jobInfo.getExtras();
                if (extras == null || !extras.containsKey("EXTRA_WORK_SPEC_ID") || !workSpecId.equals(extras.getString("EXTRA_WORK_SPEC_ID"))) continue;
                pendingJobs.add(jobInfo.getId());
            }
        }
        return pendingJobs;
    }
}

