/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.os.Build;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.DependencyDao_Impl;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.SystemIdInfoDao_Impl;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkNameDao_Impl;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkSpecDao_Impl;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.model.WorkTagDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class WorkDatabase_Impl
extends WorkDatabase {
    private volatile WorkSpecDao _workSpecDao;
    private volatile DependencyDao _dependencyDao;
    private volatile WorkTagDao _workTagDao;
    private volatile SystemIdInfoDao _systemIdInfoDao;
    private volatile WorkNameDao _workNameDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(6){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Dependency` (`work_spec_id` TEXT NOT NULL, `prerequisite_id` TEXT NOT NULL, PRIMARY KEY(`work_spec_id`, `prerequisite_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE , FOREIGN KEY(`prerequisite_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE  INDEX `index_Dependency_work_spec_id` ON `Dependency` (`work_spec_id`)");
                _db.execSQL("CREATE  INDEX `index_Dependency_prerequisite_id` ON `Dependency` (`prerequisite_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `WorkSpec` (`id` TEXT NOT NULL, `state` INTEGER NOT NULL, `worker_class_name` TEXT NOT NULL, `input_merger_class_name` TEXT, `input` BLOB NOT NULL, `output` BLOB NOT NULL, `initial_delay` INTEGER NOT NULL, `interval_duration` INTEGER NOT NULL, `flex_duration` INTEGER NOT NULL, `run_attempt_count` INTEGER NOT NULL, `backoff_policy` INTEGER NOT NULL, `backoff_delay_duration` INTEGER NOT NULL, `period_start_time` INTEGER NOT NULL, `minimum_retention_duration` INTEGER NOT NULL, `schedule_requested_at` INTEGER NOT NULL, `required_network_type` INTEGER, `requires_charging` INTEGER NOT NULL, `requires_device_idle` INTEGER NOT NULL, `requires_battery_not_low` INTEGER NOT NULL, `requires_storage_not_low` INTEGER NOT NULL, `trigger_content_update_delay` INTEGER NOT NULL, `trigger_max_content_delay` INTEGER NOT NULL, `content_uri_triggers` BLOB, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE  INDEX `index_WorkSpec_schedule_requested_at` ON `WorkSpec` (`schedule_requested_at`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `WorkTag` (`tag` TEXT NOT NULL, `work_spec_id` TEXT NOT NULL, PRIMARY KEY(`tag`, `work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE  INDEX `index_WorkTag_work_spec_id` ON `WorkTag` (`work_spec_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `SystemIdInfo` (`work_spec_id` TEXT NOT NULL, `system_id` INTEGER NOT NULL, PRIMARY KEY(`work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `WorkName` (`name` TEXT NOT NULL, `work_spec_id` TEXT NOT NULL, PRIMARY KEY(`name`, `work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE  INDEX `index_WorkName_work_spec_id` ON `WorkName` (`work_spec_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"c84d23ade98552f1cec71088c1f0794c\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Dependency`");
                _db.execSQL("DROP TABLE IF EXISTS `WorkSpec`");
                _db.execSQL("DROP TABLE IF EXISTS `WorkTag`");
                _db.execSQL("DROP TABLE IF EXISTS `SystemIdInfo`");
                _db.execSQL("DROP TABLE IF EXISTS `WorkName`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (WorkDatabase_Impl.this.mCallbacks != null) {
                    int _size = WorkDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)WorkDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                WorkDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                WorkDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (WorkDatabase_Impl.this.mCallbacks != null) {
                    int _size = WorkDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)WorkDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsDependency = new HashMap<String, TableInfo.Column>(2);
                _columnsDependency.put("work_spec_id", new TableInfo.Column("work_spec_id", "TEXT", true, 1));
                _columnsDependency.put("prerequisite_id", new TableInfo.Column("prerequisite_id", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysDependency = new HashSet<TableInfo.ForeignKey>(2);
                _foreignKeysDependency.add(new TableInfo.ForeignKey("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
                _foreignKeysDependency.add(new TableInfo.ForeignKey("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("prerequisite_id"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesDependency = new HashSet<TableInfo.Index>(2);
                _indicesDependency.add(new TableInfo.Index("index_Dependency_work_spec_id", false, Arrays.asList("work_spec_id")));
                _indicesDependency.add(new TableInfo.Index("index_Dependency_prerequisite_id", false, Arrays.asList("prerequisite_id")));
                TableInfo _infoDependency = new TableInfo("Dependency", _columnsDependency, _foreignKeysDependency, _indicesDependency);
                TableInfo _existingDependency = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Dependency");
                if (!_infoDependency.equals((Object)_existingDependency)) {
                    throw new IllegalStateException("Migration didn't properly handle Dependency(androidx.work.impl.model.Dependency).\n Expected:\n" + _infoDependency + "\n Found:\n" + _existingDependency);
                }
                HashMap<String, TableInfo.Column> _columnsWorkSpec = new HashMap<String, TableInfo.Column>(23);
                _columnsWorkSpec.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                _columnsWorkSpec.put("state", new TableInfo.Column("state", "INTEGER", true, 0));
                _columnsWorkSpec.put("worker_class_name", new TableInfo.Column("worker_class_name", "TEXT", true, 0));
                _columnsWorkSpec.put("input_merger_class_name", new TableInfo.Column("input_merger_class_name", "TEXT", false, 0));
                _columnsWorkSpec.put("input", new TableInfo.Column("input", "BLOB", true, 0));
                _columnsWorkSpec.put("output", new TableInfo.Column("output", "BLOB", true, 0));
                _columnsWorkSpec.put("initial_delay", new TableInfo.Column("initial_delay", "INTEGER", true, 0));
                _columnsWorkSpec.put("interval_duration", new TableInfo.Column("interval_duration", "INTEGER", true, 0));
                _columnsWorkSpec.put("flex_duration", new TableInfo.Column("flex_duration", "INTEGER", true, 0));
                _columnsWorkSpec.put("run_attempt_count", new TableInfo.Column("run_attempt_count", "INTEGER", true, 0));
                _columnsWorkSpec.put("backoff_policy", new TableInfo.Column("backoff_policy", "INTEGER", true, 0));
                _columnsWorkSpec.put("backoff_delay_duration", new TableInfo.Column("backoff_delay_duration", "INTEGER", true, 0));
                _columnsWorkSpec.put("period_start_time", new TableInfo.Column("period_start_time", "INTEGER", true, 0));
                _columnsWorkSpec.put("minimum_retention_duration", new TableInfo.Column("minimum_retention_duration", "INTEGER", true, 0));
                _columnsWorkSpec.put("schedule_requested_at", new TableInfo.Column("schedule_requested_at", "INTEGER", true, 0));
                _columnsWorkSpec.put("required_network_type", new TableInfo.Column("required_network_type", "INTEGER", false, 0));
                _columnsWorkSpec.put("requires_charging", new TableInfo.Column("requires_charging", "INTEGER", true, 0));
                _columnsWorkSpec.put("requires_device_idle", new TableInfo.Column("requires_device_idle", "INTEGER", true, 0));
                _columnsWorkSpec.put("requires_battery_not_low", new TableInfo.Column("requires_battery_not_low", "INTEGER", true, 0));
                _columnsWorkSpec.put("requires_storage_not_low", new TableInfo.Column("requires_storage_not_low", "INTEGER", true, 0));
                _columnsWorkSpec.put("trigger_content_update_delay", new TableInfo.Column("trigger_content_update_delay", "INTEGER", true, 0));
                _columnsWorkSpec.put("trigger_max_content_delay", new TableInfo.Column("trigger_max_content_delay", "INTEGER", true, 0));
                _columnsWorkSpec.put("content_uri_triggers", new TableInfo.Column("content_uri_triggers", "BLOB", false, 0));
                HashSet _foreignKeysWorkSpec = new HashSet(0);
                HashSet<TableInfo.Index> _indicesWorkSpec = new HashSet<TableInfo.Index>(1);
                _indicesWorkSpec.add(new TableInfo.Index("index_WorkSpec_schedule_requested_at", false, Arrays.asList("schedule_requested_at")));
                TableInfo _infoWorkSpec = new TableInfo("WorkSpec", _columnsWorkSpec, _foreignKeysWorkSpec, _indicesWorkSpec);
                TableInfo _existingWorkSpec = TableInfo.read((SupportSQLiteDatabase)_db, (String)"WorkSpec");
                if (!_infoWorkSpec.equals((Object)_existingWorkSpec)) {
                    throw new IllegalStateException("Migration didn't properly handle WorkSpec(androidx.work.impl.model.WorkSpec).\n Expected:\n" + _infoWorkSpec + "\n Found:\n" + _existingWorkSpec);
                }
                HashMap<String, TableInfo.Column> _columnsWorkTag = new HashMap<String, TableInfo.Column>(2);
                _columnsWorkTag.put("tag", new TableInfo.Column("tag", "TEXT", true, 1));
                _columnsWorkTag.put("work_spec_id", new TableInfo.Column("work_spec_id", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysWorkTag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysWorkTag.add(new TableInfo.ForeignKey("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesWorkTag = new HashSet<TableInfo.Index>(1);
                _indicesWorkTag.add(new TableInfo.Index("index_WorkTag_work_spec_id", false, Arrays.asList("work_spec_id")));
                TableInfo _infoWorkTag = new TableInfo("WorkTag", _columnsWorkTag, _foreignKeysWorkTag, _indicesWorkTag);
                TableInfo _existingWorkTag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"WorkTag");
                if (!_infoWorkTag.equals((Object)_existingWorkTag)) {
                    throw new IllegalStateException("Migration didn't properly handle WorkTag(androidx.work.impl.model.WorkTag).\n Expected:\n" + _infoWorkTag + "\n Found:\n" + _existingWorkTag);
                }
                HashMap<String, TableInfo.Column> _columnsSystemIdInfo = new HashMap<String, TableInfo.Column>(2);
                _columnsSystemIdInfo.put("work_spec_id", new TableInfo.Column("work_spec_id", "TEXT", true, 1));
                _columnsSystemIdInfo.put("system_id", new TableInfo.Column("system_id", "INTEGER", true, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysSystemIdInfo = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysSystemIdInfo.add(new TableInfo.ForeignKey("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
                HashSet _indicesSystemIdInfo = new HashSet(0);
                TableInfo _infoSystemIdInfo = new TableInfo("SystemIdInfo", _columnsSystemIdInfo, _foreignKeysSystemIdInfo, _indicesSystemIdInfo);
                TableInfo _existingSystemIdInfo = TableInfo.read((SupportSQLiteDatabase)_db, (String)"SystemIdInfo");
                if (!_infoSystemIdInfo.equals((Object)_existingSystemIdInfo)) {
                    throw new IllegalStateException("Migration didn't properly handle SystemIdInfo(androidx.work.impl.model.SystemIdInfo).\n Expected:\n" + _infoSystemIdInfo + "\n Found:\n" + _existingSystemIdInfo);
                }
                HashMap<String, TableInfo.Column> _columnsWorkName = new HashMap<String, TableInfo.Column>(2);
                _columnsWorkName.put("name", new TableInfo.Column("name", "TEXT", true, 1));
                _columnsWorkName.put("work_spec_id", new TableInfo.Column("work_spec_id", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysWorkName = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysWorkName.add(new TableInfo.ForeignKey("WorkSpec", "CASCADE", "CASCADE", Arrays.asList("work_spec_id"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesWorkName = new HashSet<TableInfo.Index>(1);
                _indicesWorkName.add(new TableInfo.Index("index_WorkName_work_spec_id", false, Arrays.asList("work_spec_id")));
                TableInfo _infoWorkName = new TableInfo("WorkName", _columnsWorkName, _foreignKeysWorkName, _indicesWorkName);
                TableInfo _existingWorkName = TableInfo.read((SupportSQLiteDatabase)_db, (String)"WorkName");
                if (!_infoWorkName.equals((Object)_existingWorkName)) {
                    throw new IllegalStateException("Migration didn't properly handle WorkName(androidx.work.impl.model.WorkName).\n Expected:\n" + _infoWorkName + "\n Found:\n" + _existingWorkName);
                }
            }
        }, "c84d23ade98552f1cec71088c1f0794c", "1db8206f0da6aa81bbdd2d99a82d9e14");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"Dependency", "WorkSpec", "WorkTag", "SystemIdInfo", "WorkName"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `Dependency`");
            _db.execSQL("DELETE FROM `WorkSpec`");
            _db.execSQL("DELETE FROM `WorkTag`");
            _db.execSQL("DELETE FROM `SystemIdInfo`");
            _db.execSQL("DELETE FROM `WorkName`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpecDao workSpecDao() {
        if (this._workSpecDao != null) {
            return this._workSpecDao;
        }
        WorkDatabase_Impl workDatabase_Impl = this;
        synchronized (workDatabase_Impl) {
            if (this._workSpecDao == null) {
                this._workSpecDao = new WorkSpecDao_Impl(this);
            }
            return this._workSpecDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyDao dependencyDao() {
        if (this._dependencyDao != null) {
            return this._dependencyDao;
        }
        WorkDatabase_Impl workDatabase_Impl = this;
        synchronized (workDatabase_Impl) {
            if (this._dependencyDao == null) {
                this._dependencyDao = new DependencyDao_Impl(this);
            }
            return this._dependencyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkTagDao workTagDao() {
        if (this._workTagDao != null) {
            return this._workTagDao;
        }
        WorkDatabase_Impl workDatabase_Impl = this;
        synchronized (workDatabase_Impl) {
            if (this._workTagDao == null) {
                this._workTagDao = new WorkTagDao_Impl(this);
            }
            return this._workTagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemIdInfoDao systemIdInfoDao() {
        if (this._systemIdInfoDao != null) {
            return this._systemIdInfoDao;
        }
        WorkDatabase_Impl workDatabase_Impl = this;
        synchronized (workDatabase_Impl) {
            if (this._systemIdInfoDao == null) {
                this._systemIdInfoDao = new SystemIdInfoDao_Impl(this);
            }
            return this._systemIdInfoDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkNameDao workNameDao() {
        if (this._workNameDao != null) {
            return this._workNameDao;
        }
        WorkDatabase_Impl workDatabase_Impl = this;
        synchronized (workDatabase_Impl) {
            if (this._workNameDao == null) {
                this._workNameDao = new WorkNameDao_Impl(this);
            }
            return this._workNameDao;
        }
    }
}

