/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.work.Logger;
import androidx.work.impl.background.systemalarm.ConstraintProxy;
import androidx.work.impl.utils.PackageManagerHelper;

public class ConstraintProxyUpdateReceiver
extends BroadcastReceiver {
    private static final String TAG = Logger.tagWithPrefix("ConstrntProxyUpdtRecvr");
    static final String ACTION = "androidx.work.impl.background.systemalarm.UpdateProxies";
    static final String KEY_BATTERY_NOT_LOW_PROXY_ENABLED = "KEY_BATTERY_NOT_LOW_PROXY_ENABLED";
    static final String KEY_BATTERY_CHARGING_PROXY_ENABLED = "KEY_BATTERY_CHARGING_PROXY_ENABLED";
    static final String KEY_STORAGE_NOT_LOW_PROXY_ENABLED = "KEY_STORAGE_NOT_LOW_PROXY_ENABLED";
    static final String KEY_NETWORK_STATE_PROXY_ENABLED = "KEY_NETWORK_STATE_PROXY_ENABLED";

    public static Intent newConstraintProxyUpdateIntent(Context context, boolean batteryNotLowProxyEnabled, boolean batteryChargingProxyEnabled, boolean storageNotLowProxyEnabled, boolean networkStateProxyEnabled) {
        Intent intent = new Intent(ACTION);
        ComponentName name = new ComponentName(context, ConstraintProxyUpdateReceiver.class);
        intent.setComponent(name);
        intent.putExtra(KEY_BATTERY_NOT_LOW_PROXY_ENABLED, batteryNotLowProxyEnabled).putExtra(KEY_BATTERY_CHARGING_PROXY_ENABLED, batteryChargingProxyEnabled).putExtra(KEY_STORAGE_NOT_LOW_PROXY_ENABLED, storageNotLowProxyEnabled).putExtra(KEY_NETWORK_STATE_PROXY_ENABLED, networkStateProxyEnabled);
        return intent;
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        String string = action = intent != null ? intent.getAction() : null;
        if (!ACTION.equals(action)) {
            Logger.get().debug(TAG, String.format("Ignoring unknown action %s", action), new Throwable[0]);
        } else {
            boolean batteryNotLowProxyEnabled = intent.getBooleanExtra(KEY_BATTERY_NOT_LOW_PROXY_ENABLED, false);
            boolean batteryChargingProxyEnabled = intent.getBooleanExtra(KEY_BATTERY_CHARGING_PROXY_ENABLED, false);
            boolean storageNotLowProxyEnabled = intent.getBooleanExtra(KEY_STORAGE_NOT_LOW_PROXY_ENABLED, false);
            boolean networkStateProxyEnabled = intent.getBooleanExtra(KEY_NETWORK_STATE_PROXY_ENABLED, false);
            Logger.get().debug(TAG, String.format("Updating proxies: BatteryNotLowProxy enabled (%s), BatteryChargingProxy enabled (%s), StorageNotLowProxy (%s), NetworkStateProxy enabled (%s)", batteryNotLowProxyEnabled, batteryChargingProxyEnabled, storageNotLowProxyEnabled, networkStateProxyEnabled), new Throwable[0]);
            PackageManagerHelper.setComponentEnabled(context, ConstraintProxy.BatteryNotLowProxy.class, batteryNotLowProxyEnabled);
            PackageManagerHelper.setComponentEnabled(context, ConstraintProxy.BatteryChargingProxy.class, batteryChargingProxyEnabled);
            PackageManagerHelper.setComponentEnabled(context, ConstraintProxy.StorageNotLowProxy.class, storageNotLowProxyEnabled);
            PackageManagerHelper.setComponentEnabled(context, ConstraintProxy.NetworkStateProxy.class, networkStateProxyEnabled);
        }
    }
}

