/*
 * Decompiled with CFR 0.152.
 */
package androidx.startup.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Landroidx/startup/lint/InitializerConstructorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "startup-runtime-lint"})
public final class InitializerConstructorDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DESCRIPTION = "Missing Initializer no-arg constructor";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"androidx.startup.Initializer");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String name = declaration.getQualifiedName();
        if (Intrinsics.areEqual((Object)name, (Object)"androidx.startup.Initializer")) {
            return;
        }
        if (declaration.isInterface()) {
            return;
        }
        boolean isJava = Intrinsics.areEqual((Object)declaration.getJavaPsi().getLanguage(), (Object)JavaLanguage.INSTANCE);
        if (isJava) {
            PsiMethod[] psiMethodArray = declaration.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"declaration.constructors");
            if (((Object[])psiMethodArray).length == 0) {
                return;
            }
        }
        PsiMethod[] psiMethodArray = declaration.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"declaration.constructors");
        for (PsiMethod constructor : psiMethodArray) {
            if (constructor.hasParameters()) continue;
            return;
        }
        Location location = context.getLocation((PsiElement)declaration.getJavaPsi());
        Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)location, (String)DESCRIPTION, null, (int)8, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(InitializerConstructorDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"EnsureInitializerNoArgConstr", (String)DESCRIPTION, (String)"\n                Every `Initializer` must have a no argument constructor.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/startup/lint/InitializerConstructorDetector$Companion;", "", "()V", "DESCRIPTION", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "startup-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

