/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.icu.util.Calendar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.biometric.BiometricPrompt;
import androidx.security.identity.EphemeralPublicKeyNotFoundException;
import androidx.security.identity.InvalidReaderSignatureException;
import androidx.security.identity.InvalidRequestMessageException;
import androidx.security.identity.MessageDecryptionException;
import androidx.security.identity.NoAuthenticationKeyAvailableException;
import androidx.security.identity.PersonalizationData;
import androidx.security.identity.ResultData;
import androidx.security.identity.UnknownAuthenticationKeyException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;

public abstract class IdentityCredential {
    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    protected IdentityCredential() {
    }

    @NonNull
    public abstract KeyPair createEphemeralKeyPair();

    public abstract void setReaderEphemeralPublicKey(@NonNull PublicKey var1) throws InvalidKeyException;

    public abstract void setSessionTranscript(@NonNull byte[] var1);

    @NonNull
    public abstract byte[] encryptMessageToReader(@NonNull byte[] var1);

    @NonNull
    public abstract byte[] decryptMessageFromReader(@NonNull byte[] var1) throws MessageDecryptionException;

    @NonNull
    public abstract Collection<X509Certificate> getCredentialKeyCertificateChain();

    public abstract void setAllowUsingExhaustedKeys(boolean var1);

    public void setAllowUsingExpiredKeys(boolean allowUsingExpiredKeys) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public abstract BiometricPrompt.CryptoObject getCryptoObject();

    @NonNull
    public abstract ResultData getEntries(@Nullable byte[] var1, @NonNull Map<String, Collection<String>> var2, @Nullable byte[] var3) throws NoAuthenticationKeyAvailableException, InvalidReaderSignatureException, EphemeralPublicKeyNotFoundException, InvalidRequestMessageException;

    public abstract void setAvailableAuthenticationKeys(int var1, int var2);

    @NonNull
    public abstract Collection<X509Certificate> getAuthKeysNeedingCertification();

    @Deprecated
    public abstract void storeStaticAuthenticationData(@NonNull X509Certificate var1, @NonNull byte[] var2) throws UnknownAuthenticationKeyException;

    public void storeStaticAuthenticationData(@NonNull X509Certificate authenticationKey, @NonNull Calendar expirationDate, @NonNull byte[] staticAuthData) throws UnknownAuthenticationKeyException {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public abstract int[] getAuthenticationDataUsageCount();

    @NonNull
    public byte[] proveOwnership(@NonNull byte[] challenge) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public byte[] delete(@NonNull byte[] challenge) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public byte[] update(@NonNull PersonalizationData personalizationData) {
        throw new UnsupportedOperationException();
    }
}

