/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.security.identity.AlreadyPersonalizedException;
import androidx.security.identity.CipherSuiteNotSupportedException;
import androidx.security.identity.DocTypeNotSupportedException;
import androidx.security.identity.HardwareIdentityCredential;
import androidx.security.identity.HardwareWritableIdentityCredential;
import androidx.security.identity.IdentityCredential;
import androidx.security.identity.IdentityCredentialStore;
import androidx.security.identity.IdentityCredentialStoreCapabilities;
import androidx.security.identity.SimpleIdentityCredentialStoreCapabilities;
import androidx.security.identity.WritableIdentityCredential;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

@RequiresApi(value=30)
class HardwareIdentityCredentialStore
extends IdentityCredentialStore {
    private static final String TAG = "HardwareIdentityCredentialStore";
    private android.security.identity.IdentityCredentialStore mStore = null;
    private boolean mIsDirectAccess = false;
    SimpleIdentityCredentialStoreCapabilities mCapabilities = null;

    private HardwareIdentityCredentialStore(@NonNull android.security.identity.IdentityCredentialStore store, boolean isDirectAccess) {
        this.mStore = store;
        this.mIsDirectAccess = isDirectAccess;
    }

    @Nullable
    static IdentityCredentialStore getInstanceIfSupported(@NonNull Context context) {
        android.security.identity.IdentityCredentialStore store = android.security.identity.IdentityCredentialStore.getInstance((Context)context);
        if (store != null) {
            return new HardwareIdentityCredentialStore(store, false);
        }
        return null;
    }

    @NonNull
    public static IdentityCredentialStore getInstance(@NonNull Context context) {
        IdentityCredentialStore instance = HardwareIdentityCredentialStore.getInstanceIfSupported(context);
        if (instance != null) {
            return instance;
        }
        throw new RuntimeException("HW-backed IdentityCredential not supported");
    }

    @Nullable
    static IdentityCredentialStore getDirectAccessInstanceIfSupported(@NonNull Context context) {
        android.security.identity.IdentityCredentialStore store = android.security.identity.IdentityCredentialStore.getDirectAccessInstance((Context)context);
        if (store != null) {
            return new HardwareIdentityCredentialStore(store, true);
        }
        return null;
    }

    @NonNull
    public static IdentityCredentialStore getDirectAccessInstance(@NonNull Context context) {
        IdentityCredentialStore instance = HardwareIdentityCredentialStore.getDirectAccessInstanceIfSupported(context);
        if (instance != null) {
            return instance;
        }
        throw new RuntimeException("HW-backed direct-access IdentityCredential not supported");
    }

    public static boolean isDirectAccessSupported(@NonNull Context context) {
        IdentityCredentialStore directAccessStore = HardwareIdentityCredentialStore.getDirectAccessInstanceIfSupported(context);
        return directAccessStore != null;
    }

    @Override
    @NonNull
    public String[] getSupportedDocTypes() {
        Set<String> docTypeSet = this.getCapabilities().getSupportedDocTypes();
        String[] docTypes = new String[docTypeSet.size()];
        int n = 0;
        for (String docType : docTypeSet) {
            docTypes[n++] = docType;
        }
        return docTypes;
    }

    @Override
    @NonNull
    public WritableIdentityCredential createCredential(@NonNull String credentialName, @NonNull String docType) throws AlreadyPersonalizedException, DocTypeNotSupportedException {
        try {
            android.security.identity.WritableIdentityCredential writableCredential = this.mStore.createCredential(credentialName, docType);
            return new HardwareWritableIdentityCredential(writableCredential);
        }
        catch (android.security.identity.AlreadyPersonalizedException e) {
            throw new AlreadyPersonalizedException(e.getMessage(), e);
        }
        catch (android.security.identity.DocTypeNotSupportedException e) {
            throw new DocTypeNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public IdentityCredential getCredentialByName(@NonNull String credentialName, int cipherSuite) throws CipherSuiteNotSupportedException {
        try {
            android.security.identity.IdentityCredential credential = this.mStore.getCredentialByName(credentialName, cipherSuite);
            if (credential == null) {
                return null;
            }
            return new HardwareIdentityCredential(credential);
        }
        catch (android.security.identity.CipherSuiteNotSupportedException e) {
            throw new CipherSuiteNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public byte[] deleteCredentialByName(@NonNull String credentialName) {
        return this.mStore.deleteCredentialByName(credentialName);
    }

    @Override
    @NonNull
    public IdentityCredentialStoreCapabilities getCapabilities() {
        LinkedHashSet<String> supportedDocTypesSet = new LinkedHashSet<String>(Arrays.asList(this.mStore.getSupportedDocTypes()));
        if (this.mCapabilities == null) {
            this.mCapabilities = new SimpleIdentityCredentialStoreCapabilities(this.mIsDirectAccess, 202009, true, supportedDocTypesSet, false, false, false, false);
        }
        return this.mCapabilities;
    }
}

