/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.crypto;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.security.crypto.MasterKeys;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public final class MasterKey {
    static final String KEYSTORE_PATH_URI = "android-keystore://";
    public static final String DEFAULT_MASTER_KEY_ALIAS = "_androidx_security_master_key_";
    public static final int DEFAULT_AES_GCM_MASTER_KEY_SIZE = 256;
    private static final int DEFAULT_AUTHENTICATION_VALIDITY_DURATION_SECONDS = 300;
    @NonNull
    private final String mKeyAlias;
    @Nullable
    private final KeyGenParameterSpec mKeyGenParameterSpec;

    @SuppressLint(value={"MethodNameUnits"})
    public static int getDefaultAuthenticationValidityDurationSeconds() {
        return 300;
    }

    MasterKey(@NonNull String keyAlias, @Nullable Object keyGenParameterSpec) {
        this.mKeyAlias = keyAlias;
        this.mKeyGenParameterSpec = Build.VERSION.SDK_INT >= 23 ? (KeyGenParameterSpec)keyGenParameterSpec : null;
    }

    public boolean isKeyStoreBacked() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            return keyStore.containsAlias(this.mKeyAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ignored) {
            return false;
        }
    }

    public boolean isUserAuthenticationRequired() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        return this.mKeyGenParameterSpec != null && this.mKeyGenParameterSpec.isUserAuthenticationRequired();
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getUserAuthenticationValidityDurationSeconds() {
        if (Build.VERSION.SDK_INT < 23) {
            return 0;
        }
        return this.mKeyGenParameterSpec == null ? 0 : this.mKeyGenParameterSpec.getUserAuthenticationValidityDurationSeconds();
    }

    public boolean isStrongBoxBacked() {
        if (Build.VERSION.SDK_INT < 28 || this.mKeyGenParameterSpec == null) {
            return false;
        }
        return this.mKeyGenParameterSpec.isStrongBoxBacked();
    }

    @NonNull
    public String toString() {
        return "MasterKey{keyAlias=" + this.mKeyAlias + ", isKeyStoreBacked=" + this.isKeyStoreBacked() + "}";
    }

    @NonNull
    String getKeyAlias() {
        return this.mKeyAlias;
    }

    public static final class Builder {
        @NonNull
        private final String mKeyAlias;
        @Nullable
        private KeyGenParameterSpec mKeyGenParameterSpec;
        @Nullable
        private KeyScheme mKeyScheme;
        private boolean mAuthenticationRequired;
        private int mUserAuthenticationValidityDurationSeconds;
        private boolean mRequestStrongBoxBacked;
        private final Context mContext;

        public Builder(@NonNull Context context) {
            this(context, MasterKey.DEFAULT_MASTER_KEY_ALIAS);
        }

        public Builder(@NonNull Context context, @NonNull String keyAlias) {
            this.mContext = context.getApplicationContext();
            this.mKeyAlias = keyAlias;
        }

        @NonNull
        public Builder setKeyScheme(@NonNull KeyScheme keyScheme) {
            switch (keyScheme) {
                case AES256_GCM: {
                    if (Build.VERSION.SDK_INT < 23 || this.mKeyGenParameterSpec == null) break;
                    throw new IllegalArgumentException("KeyScheme set after setting a KeyGenParamSpec");
                }
                default: {
                    throw new IllegalArgumentException("Unsupported scheme: " + (Object)((Object)keyScheme));
                }
            }
            this.mKeyScheme = keyScheme;
            return this;
        }

        @NonNull
        public Builder setUserAuthenticationRequired(boolean authenticationRequired) {
            return this.setUserAuthenticationRequired(authenticationRequired, MasterKey.getDefaultAuthenticationValidityDurationSeconds());
        }

        @NonNull
        public Builder setUserAuthenticationRequired(boolean authenticationRequired, @IntRange(from=1L) int userAuthenticationValidityDurationSeconds) {
            this.mAuthenticationRequired = authenticationRequired;
            this.mUserAuthenticationValidityDurationSeconds = userAuthenticationValidityDurationSeconds;
            return this;
        }

        @NonNull
        public Builder setRequestStrongBoxBacked(boolean requestStrongBoxBacked) {
            this.mRequestStrongBoxBacked = requestStrongBoxBacked;
            return this;
        }

        @NonNull
        @RequiresApi(value=23)
        public Builder setKeyGenParameterSpec(@NonNull KeyGenParameterSpec keyGenParameterSpec) {
            if (this.mKeyScheme != null) {
                throw new IllegalArgumentException("KeyGenParamSpec set after setting a KeyScheme");
            }
            if (!this.mKeyAlias.equals(keyGenParameterSpec.getKeystoreAlias())) {
                throw new IllegalArgumentException("KeyGenParamSpec's key alias does not match provided alias (" + this.mKeyAlias + " vs " + keyGenParameterSpec.getKeystoreAlias());
            }
            this.mKeyGenParameterSpec = keyGenParameterSpec;
            return this;
        }

        @NonNull
        public MasterKey build() throws GeneralSecurityException, IOException {
            if (Build.VERSION.SDK_INT >= 23) {
                return this.buildOnM();
            }
            return new MasterKey(this.mKeyAlias, null);
        }

        @RequiresApi(value=23)
        private MasterKey buildOnM() throws GeneralSecurityException, IOException {
            if (this.mKeyScheme == null && this.mKeyGenParameterSpec == null) {
                throw new IllegalArgumentException("build() called before setKeyGenParameterSpec or setKeyScheme.");
            }
            if (this.mKeyScheme == KeyScheme.AES256_GCM) {
                KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256);
                if (this.mAuthenticationRequired) {
                    builder.setUserAuthenticationRequired(true).setUserAuthenticationValidityDurationSeconds(this.mUserAuthenticationValidityDurationSeconds);
                }
                if (Build.VERSION.SDK_INT >= 28 && this.mRequestStrongBoxBacked && this.mContext.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore")) {
                    builder.setIsStrongBoxBacked(true);
                }
                this.mKeyGenParameterSpec = builder.build();
            }
            if (this.mKeyGenParameterSpec == null) {
                throw new NullPointerException("KeyGenParameterSpec was null after build() check");
            }
            String keyAlias = MasterKeys.getOrCreate(this.mKeyGenParameterSpec);
            return new MasterKey(keyAlias, this.mKeyGenParameterSpec);
        }
    }

    public static enum KeyScheme {
        AES256_GCM;

    }
}

