/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.annotation.SuppressLint;
import android.database.Cursor;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/room/util/FtsTableInfo;", "", "name", "", "columns", "", "createSql", "(Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V", "options", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;)V", "equals", "", "other", "hashCode", "", "toString", "Companion", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class FtsTableInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final String name;
    @JvmField
    @NotNull
    public final Set<String> columns;
    @JvmField
    @NotNull
    public final Set<String> options;
    @NotNull
    private static final String[] FTS_OPTIONS;

    public FtsTableInfo(@NotNull String name, @NotNull Set<String> columns, @NotNull Set<String> options) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.name = name;
        this.columns = columns;
        this.options = options;
    }

    public FtsTableInfo(@NotNull String name, @NotNull Set<String> columns, @NotNull String createSql) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)createSql, (String)"createSql");
        this(name, columns, Companion.parseOptions(createSql));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FtsTableInfo)) {
            return false;
        }
        Object that = other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((FtsTableInfo)that).name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columns, ((FtsTableInfo)that).columns)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, ((FtsTableInfo)that).options);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + ((Object)this.columns).hashCode();
        result = 31 * result + ((Object)this.options).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "FtsTableInfo{name='" + this.name + "', columns=" + this.columns + ", options=" + this.options + "'}";
    }

    @JvmStatic
    @SuppressLint(value={"SyntheticAccessor"})
    @NotNull
    public static final FtsTableInfo read(@NotNull SupportSQLiteDatabase database, @NotNull String tableName) {
        return Companion.read(database, tableName);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final Set<String> parseOptions(@NotNull String createStatement) {
        return Companion.parseOptions(createStatement);
    }

    static {
        String[] stringArray = new String[]{"tokenize=", "compress=", "content=", "languageid=", "matchinfo=", "notindexed=", "order=", "prefix=", "uncompress="};
        FTS_OPTIONS = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Landroidx/room/util/FtsTableInfo$Companion;", "", "()V", "FTS_OPTIONS", "", "", "[Ljava/lang/String;", "parseOptions", "", "createStatement", "read", "Landroidx/room/util/FtsTableInfo;", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "tableName", "readColumns", "readOptions", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nFtsTableInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtsTableInfo.kt\nandroidx/room/util/FtsTableInfo$Companion\n+ 2 CursorUtil.kt\nandroidx/room/util/CursorUtil\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,183:1\n145#2,7:184\n145#2,7:191\n1183#3,2:198\n1185#3:223\n107#4:200\n79#4,22:201\n766#5:224\n857#5:225\n858#5:228\n12744#6,2:226\n*S KotlinDebug\n*F\n+ 1 FtsTableInfo.kt\nandroidx/room/util/FtsTableInfo$Companion\n*L\n96#1:184,7\n110#1:191,7\n150#1:198,2\n150#1:223\n165#1:200\n165#1:201,22\n175#1:224\n175#1:225\n175#1:228\n176#1:226,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @SuppressLint(value={"SyntheticAccessor"})
        @NotNull
        public final FtsTableInfo read(@NotNull SupportSQLiteDatabase database, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Set<String> columns = this.readColumns(database, tableName);
            Set<String> options = this.readOptions(database, tableName);
            return new FtsTableInfo(tableName, columns, options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Set<String> readColumns(SupportSQLiteDatabase database, String tableName) {
            Set set;
            Set $this$readColumns_u24lambda_u241 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            Cursor $this$useCursor$iv = database.query("PRAGMA table_info(`" + tableName + "`)");
            boolean $i$f$useCursor = false;
            if (Build.VERSION.SDK_INT > 15) {
                Closeable closeable = (Closeable)$this$useCursor$iv;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl2 = false;
                    if (cursor.getColumnCount() > 0) {
                        int nameIndex = cursor.getColumnIndex("name");
                        while (cursor.moveToNext()) {
                            String string = cursor.getString(nameIndex);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(nameIndex)");
                            $this$readColumns_u24lambda_u241.add(string);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            try {
                Cursor cursor = $this$useCursor$iv;
                boolean bl3 = false;
                if (cursor.getColumnCount() > 0) {
                    int nameIndex = cursor.getColumnIndex("name");
                    while (cursor.moveToNext()) {
                        String string = cursor.getString(nameIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(nameIndex)");
                        $this$readColumns_u24lambda_u241.add(string);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useCursor$iv.close();
            }
            return SetsKt.build((Set)set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Set<String> readOptions(SupportSQLiteDatabase database, String tableName) {
            Object object;
            Object object2;
            void $this$useCursor$iv;
            Cursor cursor = database.query("SELECT * FROM sqlite_master WHERE `name` = '" + tableName + '\'');
            boolean $i$f$useCursor = false;
            if (Build.VERSION.SDK_INT > 15) {
                object2 = (Closeable)$this$useCursor$iv;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object2;
                    boolean bl = false;
                    String string = cursor2.moveToFirst() ? cursor2.getString(cursor2.getColumnIndexOrThrow("sql")) : "";
                    object = string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            try {
                void cursor3 = $this$useCursor$iv;
                boolean bl = false;
                object2 = cursor3.moveToFirst() ? cursor3.getString(cursor3.getColumnIndexOrThrow("sql")) : "";
                object = object2;
            }
            finally {
                $this$useCursor$iv.close();
            }
            Object sql = object;
            Intrinsics.checkNotNullExpressionValue((Object)sql, (String)"sql");
            return this.parseOptions((String)sql);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final Set<String> parseOptions(@NotNull String createStatement) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)createStatement, (String)"createStatement");
            if (((CharSequence)createStatement).length() == 0) {
                return SetsKt.emptySet();
            }
            String string = createStatement.substring(StringsKt.indexOf$default((CharSequence)createStatement, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)createStatement, (char)')', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String argsString = string;
            List args = new ArrayList();
            ArrayDeque<Character> quoteStack = new ArrayDeque<Character>();
            int lastDelimiterIndex = 0;
            lastDelimiterIndex = -1;
            CharSequence $this$forEachIndexed$iv = argsString;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                void $this$trim$iv;
                void value;
                char item$iv = $this$forEachIndexed$iv.charAt(i);
                int n = index$iv++;
                char c = item$iv;
                int i2 = n;
                boolean bl = false;
                void var14_19 = value;
                if ((var14_19 == 39 ? true : var14_19 == 34) ? true : var14_19 == 96) {
                    if (quoteStack.isEmpty()) {
                        quoteStack.push(Character.valueOf((char)value));
                        continue;
                    }
                    Character c2 = (Character)quoteStack.peek();
                    void var15_21 = value;
                    if (c2 == null || c2.charValue() != var15_21) continue;
                    quoteStack.pop();
                    continue;
                }
                if (var14_19 == 91) {
                    if (!quoteStack.isEmpty()) continue;
                    quoteStack.push(Character.valueOf((char)value));
                    continue;
                }
                if (var14_19 == 93) {
                    if (quoteStack.isEmpty()) continue;
                    Character c3 = (Character)quoteStack.peek();
                    char c4 = '[';
                    if (c3 == null || c3.charValue() != c4) continue;
                    quoteStack.pop();
                    continue;
                }
                if (var14_19 != 44 || !quoteStack.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)argsString.substring(lastDelimiterIndex + 1, i2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                List list = args;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                list.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                lastDelimiterIndex = i2;
            }
            String string2 = argsString.substring(lastDelimiterIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            args.add(((Object)StringsKt.trim((CharSequence)string2)).toString());
            Iterable $this$filter$iv = args;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block11: {
                    String arg = (String)element$iv$iv;
                    boolean bl4 = false;
                    String[] $this$any$iv = FTS_OPTIONS;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String validOption = element$iv = $this$any$iv[i];
                        boolean bl5 = false;
                        if (!StringsKt.startsWith$default((String)arg, (String)validOption, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set options = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return options;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

