/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.MatrixCursor;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a#\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a)\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a/\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\u00012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u00120\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"copyAndClose", "Landroid/database/Cursor;", "c", "findColumnIndexBySuffix", "", "cursor", "name", "", "columnNames", "", "([Ljava/lang/String;Ljava/lang/String;)I", "getColumnIndex", "getColumnIndexOrThrow", "wrapMappedColumns", "mapping", "", "(Landroid/database/Cursor;[Ljava/lang/String;[I)Landroid/database/Cursor;", "useCursor", "R", "block", "Lkotlin/Function1;", "(Landroid/database/Cursor;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "room-runtime_release"})
@JvmName(name="CursorUtil")
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SourceDebugExtension(value={"SMAP\nCursorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CursorUtil.kt\nandroidx/room/util/CursorUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n145#1,7:184\n13644#2,3:191\n1#3:194\n*S KotlinDebug\n*F\n+ 1 CursorUtil.kt\nandroidx/room/util/CursorUtil\n*L\n39#1:184,7\n127#1:191,3\n*E\n"})
public final class CursorUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Cursor copyAndClose(@NotNull Cursor c) {
        MatrixCursor matrixCursor;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Cursor $this$useCursor$iv = c;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                MatrixCursor matrixCursor2 = new MatrixCursor(cursor.getColumnNames(), cursor.getCount());
                while (cursor.moveToNext()) {
                    Object[] row = new Object[cursor.getColumnCount()];
                    int n = c.getColumnCount();
                    block23: for (int i = 0; i < n; ++i) {
                        switch (cursor.getType(i)) {
                            case 0: {
                                row[i] = null;
                                continue block23;
                            }
                            case 1: {
                                row[i] = cursor.getLong(i);
                                continue block23;
                            }
                            case 2: {
                                row[i] = cursor.getDouble(i);
                                continue block23;
                            }
                            case 3: {
                                row[i] = cursor.getString(i);
                                continue block23;
                            }
                            case 4: {
                                row[i] = cursor.getBlob(i);
                                continue block23;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    matrixCursor2.addRow(row);
                }
                MatrixCursor matrixCursor3 = matrixCursor2;
                matrixCursor = matrixCursor3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Cursor cursor = $this$useCursor$iv;
            boolean bl = false;
            MatrixCursor matrixCursor4 = new MatrixCursor(cursor.getColumnNames(), cursor.getCount());
            while (cursor.moveToNext()) {
                Object[] row = new Object[cursor.getColumnCount()];
                int n = c.getColumnCount();
                block25: for (int i = 0; i < n; ++i) {
                    switch (cursor.getType(i)) {
                        case 0: {
                            row[i] = null;
                            continue block25;
                        }
                        case 1: {
                            row[i] = cursor.getLong(i);
                            continue block25;
                        }
                        case 2: {
                            row[i] = cursor.getDouble(i);
                            continue block25;
                        }
                        case 3: {
                            row[i] = cursor.getString(i);
                            continue block25;
                        }
                        case 4: {
                            row[i] = cursor.getBlob(i);
                            continue block25;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                matrixCursor4.addRow(row);
            }
            MatrixCursor matrixCursor5 = matrixCursor4;
            matrixCursor = matrixCursor5;
        }
        finally {
            $this$useCursor$iv.close();
        }
        return (Cursor)matrixCursor;
    }

    public static final int getColumnIndex(@NotNull Cursor c, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int index = c.getColumnIndex(name);
        if (index >= 0) {
            return index;
        }
        index = c.getColumnIndex('`' + name + '`');
        return index >= 0 ? index : CursorUtil.findColumnIndexBySuffix(c, name);
    }

    public static final int getColumnIndexOrThrow(@NotNull Cursor c, @NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int index = CursorUtil.getColumnIndex(c, name);
        if (index >= 0) {
            return index;
        }
        try {
            String[] stringArray = c.getColumnNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"c.columnNames");
            string = ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null);
        }
        catch (Exception e) {
            Log.d((String)"RoomCursorUtil", (String)"Cannot collect column names for debug purposes", (Throwable)e);
            string = "unknown";
        }
        String availableColumns = string;
        throw new IllegalArgumentException("column '" + name + "' does not exist. Available columns: " + availableColumns);
    }

    private static final int findColumnIndexBySuffix(Cursor cursor, String name) {
        if (Build.VERSION.SDK_INT > 25) {
            return -1;
        }
        if (((CharSequence)name).length() == 0) {
            return -1;
        }
        String[] columnNames = cursor.getColumnNames();
        Intrinsics.checkNotNullExpressionValue((Object)columnNames, (String)"columnNames");
        return CursorUtil.findColumnIndexBySuffix(columnNames, name);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static final int findColumnIndexBySuffix(@NotNull String[] columnNames, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String dotSuffix = '.' + name;
        String backtickSuffix = '.' + name + '`';
        String[] $this$forEachIndexed$iv = columnNames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (String item$iv : $this$forEachIndexed$iv) {
            void columnName;
            int n = index$iv++;
            String string = item$iv;
            int index = n;
            boolean bl = false;
            if (columnName.length() < name.length() + 2) continue;
            if (StringsKt.endsWith$default((String)columnName, (String)dotSuffix, (boolean)false, (int)2, null)) {
                return index;
            }
            if (columnName.charAt(0) != '`' || !StringsKt.endsWith$default((String)columnName, (String)backtickSuffix, (boolean)false, (int)2, null)) continue;
            return index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R useCursor(@NotNull Cursor $this$useCursor, @NotNull Function1<? super Cursor, ? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)$this$useCursor, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Object object;
            Closeable closeable = (Closeable)$this$useCursor;
            Throwable throwable = null;
            try {
                object = block.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        try {
            Object object = block.invoke((Object)$this$useCursor);
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$useCursor.close();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public static final Cursor wrapMappedColumns(@NotNull Cursor cursor, @NotNull String[] columnNames, @NotNull int[] mapping) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        if (!(columnNames.length == mapping.length)) {
            boolean bl = false;
            String string = "Expected columnNames.length == mapping.length";
            throw new IllegalStateException(string.toString());
        }
        return (Cursor)new CursorWrapper(cursor, columnNames, mapping){
            final /* synthetic */ String[] $columnNames;
            final /* synthetic */ int[] $mapping;
            {
                this.$columnNames = $columnNames;
                this.$mapping = $mapping;
                super($cursor);
            }

            /*
             * WARNING - void declaration
             */
            public int getColumnIndex(@NotNull String columnName) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
                String[] stringArray = this.$columnNames;
                int[] nArray = this.$mapping;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void mappedColumnName;
                    int n = index$iv++;
                    void var9_9 = item$iv;
                    int i = n;
                    boolean bl = false;
                    if (!StringsKt.equals((String)mappedColumnName, (String)columnName, (boolean)true)) continue;
                    return nArray[i];
                }
                return super.getColumnIndex(columnName);
            }
        };
    }
}

