/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import android.database.Cursor;
import androidx.annotation.RestrictTo;
import androidx.paging.PositionalDataSource;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B3\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rB;\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u000fB3\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0011B;\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH$J\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0002J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0016J\u001e\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020,2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0016J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!J\b\u0010.\u001a\u00020&H\u0002R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/room/paging/LimitOffsetDataSource;", "T", "", "Landroidx/paging/PositionalDataSource;", "db", "Landroidx/room/RoomDatabase;", "query", "Landroidx/sqlite/db/SupportSQLiteQuery;", "inTransaction", "", "tables", "", "", "(Landroidx/room/RoomDatabase;Landroidx/sqlite/db/SupportSQLiteQuery;Z[Ljava/lang/String;)V", "registerObserverImmediately", "(Landroidx/room/RoomDatabase;Landroidx/sqlite/db/SupportSQLiteQuery;ZZ[Ljava/lang/String;)V", "Landroidx/room/RoomSQLiteQuery;", "(Landroidx/room/RoomDatabase;Landroidx/room/RoomSQLiteQuery;Z[Ljava/lang/String;)V", "sourceQuery", "(Landroidx/room/RoomDatabase;Landroidx/room/RoomSQLiteQuery;ZZ[Ljava/lang/String;)V", "countQuery", "isInvalid", "()Z", "limitOffsetQuery", "observer", "Landroidx/room/InvalidationTracker$Observer;", "registeredObserver", "Ljava/util/concurrent/atomic/AtomicBoolean;", "convertRows", "", "cursor", "Landroid/database/Cursor;", "countItems", "", "getSQLiteQuery", "startPosition", "loadCount", "loadInitial", "", "params", "Landroidx/paging/PositionalDataSource$LoadInitialParams;", "callback", "Landroidx/paging/PositionalDataSource$LoadInitialCallback;", "loadRange", "Landroidx/paging/PositionalDataSource$LoadRangeParams;", "Landroidx/paging/PositionalDataSource$LoadRangeCallback;", "registerObserverIfNecessary", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class LimitOffsetDataSource<T>
extends PositionalDataSource<T> {
    @NotNull
    private final RoomDatabase db;
    @NotNull
    private final RoomSQLiteQuery sourceQuery;
    private final boolean inTransaction;
    @NotNull
    private final String countQuery;
    @NotNull
    private final String limitOffsetQuery;
    @NotNull
    private final InvalidationTracker.Observer observer;
    @NotNull
    private final AtomicBoolean registeredObserver;

    protected LimitOffsetDataSource(@NotNull RoomDatabase db, @NotNull RoomSQLiteQuery sourceQuery, boolean inTransaction, boolean registerObserverImmediately, final String ... tables) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this.db = db;
        this.sourceQuery = sourceQuery;
        this.inTransaction = inTransaction;
        this.countQuery = "SELECT COUNT(*) FROM ( " + this.sourceQuery.getSql() + " )";
        this.limitOffsetQuery = "SELECT * FROM ( " + this.sourceQuery.getSql() + " ) LIMIT ? OFFSET ?";
        this.registeredObserver = new AtomicBoolean(false);
        this.observer = new InvalidationTracker.Observer(){

            @Override
            public void onInvalidated(@NotNull Set<String> tables2) {
                Intrinsics.checkNotNullParameter(tables2, (String)"tables");
                this.invalidate();
            }
        };
        if (registerObserverImmediately) {
            this.registerObserverIfNecessary();
        }
    }

    protected LimitOffsetDataSource(@NotNull RoomDatabase db, @NotNull SupportSQLiteQuery query, boolean inTransaction, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.copyFrom(query);
        Intrinsics.checkNotNullExpressionValue((Object)roomSQLiteQuery, (String)"copyFrom(query)");
        this(db, roomSQLiteQuery, inTransaction, Arrays.copyOf(tables, tables.length));
    }

    protected LimitOffsetDataSource(@NotNull RoomDatabase db, @NotNull SupportSQLiteQuery query, boolean inTransaction, boolean registerObserverImmediately, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.copyFrom(query);
        Intrinsics.checkNotNullExpressionValue((Object)roomSQLiteQuery, (String)"copyFrom(query)");
        this(db, roomSQLiteQuery, inTransaction, registerObserverImmediately, Arrays.copyOf(tables, tables.length));
    }

    protected LimitOffsetDataSource(@NotNull RoomDatabase db, @NotNull RoomSQLiteQuery query, boolean inTransaction, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this(db, query, inTransaction, true, Arrays.copyOf(tables, tables.length));
    }

    private final void registerObserverIfNecessary() {
        if (this.registeredObserver.compareAndSet(false, true)) {
            this.db.getInvalidationTracker().addWeakObserver(this.observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int countItems() {
        int n;
        this.registerObserverIfNecessary();
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.countQuery, this.sourceQuery.getArgCount());
        sqLiteQuery.copyArgumentsFrom(this.sourceQuery);
        Cursor cursor = this.db.query(sqLiteQuery);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"db.query(sqLiteQuery)");
        Cursor cursor2 = cursor;
        try {
            n = cursor2.moveToFirst() ? cursor2.getInt(0) : 0;
        }
        finally {
            cursor2.close();
            sqLiteQuery.release();
        }
        return n;
    }

    public boolean isInvalid() {
        this.registerObserverIfNecessary();
        this.db.getInvalidationTracker().refreshVersionsSync();
        return super.isInvalid();
    }

    @NotNull
    protected abstract List<T> convertRows(@NotNull Cursor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInitial(@NotNull PositionalDataSource.LoadInitialParams params, @NotNull PositionalDataSource.LoadInitialCallback<T> callback) {
        Object onResultCaller;
        block9: {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.registerObserverIfNecessary();
            onResultCaller = null;
            this.db.beginTransaction();
            try {
                int totalCount = this.countItems();
                if (totalCount != 0) {
                    int firstLoadPosition = PositionalDataSource.Companion.computeInitialLoadPosition(params, totalCount);
                    int firstLoadSize = PositionalDataSource.Companion.computeInitialLoadSize(params, firstLoadPosition, totalCount);
                    Closeable closeable = (Closeable)this.db.query(this.getSQLiteQuery(firstLoadPosition, firstLoadSize));
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
                        List<T> rows = this.convertRows(cursor);
                        this.db.setTransactionSuccessful();
                        onResultCaller = new Function0<Unit>(callback, rows, firstLoadPosition, totalCount){
                            final /* synthetic */ PositionalDataSource.LoadInitialCallback<T> $callback;
                            final /* synthetic */ List<T> $rows;
                            final /* synthetic */ int $firstLoadPosition;
                            final /* synthetic */ int $totalCount;
                            {
                                this.$callback = $callback;
                                this.$rows = $rows;
                                this.$firstLoadPosition = $firstLoadPosition;
                                this.$totalCount = $totalCount;
                                super(0);
                            }

                            public final void invoke() {
                                this.$callback.onResult(this.$rows, this.$firstLoadPosition, this.$totalCount);
                            }
                        };
                        Unit unit = Unit.INSTANCE;
                        break block9;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                onResultCaller = new Function0<Unit>(callback, totalCount){
                    final /* synthetic */ PositionalDataSource.LoadInitialCallback<T> $callback;
                    final /* synthetic */ int $totalCount;
                    {
                        this.$callback = $callback;
                        this.$totalCount = $totalCount;
                        super(0);
                    }

                    public final void invoke() {
                        this.$callback.onResult(CollectionsKt.emptyList(), 0, this.$totalCount);
                    }
                };
            }
            finally {
                this.db.endTransaction();
            }
        }
        ((Function0)onResultCaller).invoke();
    }

    public void loadRange(@NotNull PositionalDataSource.LoadRangeParams params, @NotNull PositionalDataSource.LoadRangeCallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        callback.onResult(this.loadRange(params.startPosition, params.loadSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<T> loadRange(int startPosition, int loadCount) {
        List<T> list;
        Closeable closeable;
        RoomSQLiteQuery sqLiteQuery = this.getSQLiteQuery(startPosition, loadCount);
        if (this.inTransaction) {
            this.db.beginTransaction();
            try {
                List<T> list2;
                closeable = (Closeable)this.db.query(sqLiteQuery);
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"cursor");
                    List<T> rows = this.convertRows(cursor2);
                    this.db.setTransactionSuccessful();
                    list2 = rows;
                }
                catch (Throwable cursor2) {
                    try {
                        throwable = cursor2;
                        throw cursor2;
                    }
                    catch (Throwable cursor2) {
                        CloseableKt.closeFinally((Closeable)closeable, throwable);
                        throw cursor2;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                List<T> list3 = list2;
                return list3;
            }
            finally {
                this.db.endTransaction();
            }
        }
        closeable = (Closeable)this.db.query(sqLiteQuery);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
            list = this.convertRows(cursor);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, throwable);
                throw throwable3;
            }
        }
        finally {
            sqLiteQuery.release();
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        List<T> list4 = list;
        return list4;
    }

    private final RoomSQLiteQuery getSQLiteQuery(int startPosition, int loadCount) {
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.limitOffsetQuery, this.sourceQuery.getArgCount() + 2);
        sqLiteQuery.copyArgumentsFrom(this.sourceQuery);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount() - 1, loadCount);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount(), startPosition);
        Intrinsics.checkNotNullExpressionValue((Object)sqLiteQuery, (String)"sqLiteQuery");
        return sqLiteQuery;
    }
}

