/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.room.DatabaseConfiguration;
import androidx.room.DelegatingOpenHelper;
import androidx.room.util.CopyLock;
import androidx.room.util.DBUtil;
import androidx.room.util.FileUtil;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;

class SQLiteCopyOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    @NonNull
    private final Context mContext;
    @Nullable
    private final String mCopyFromAssetPath;
    @Nullable
    private final File mCopyFromFile;
    @Nullable
    private final Callable<InputStream> mCopyFromInputStream;
    private final int mDatabaseVersion;
    @NonNull
    private final SupportSQLiteOpenHelper mDelegate;
    @Nullable
    private DatabaseConfiguration mDatabaseConfiguration;
    private boolean mVerified;

    SQLiteCopyOpenHelper(@NonNull Context context, @Nullable String copyFromAssetPath, @Nullable File copyFromFile, @Nullable Callable<InputStream> copyFromInputStream, int databaseVersion, @NonNull SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        this.mContext = context;
        this.mCopyFromAssetPath = copyFromAssetPath;
        this.mCopyFromFile = copyFromFile;
        this.mCopyFromInputStream = copyFromInputStream;
        this.mDatabaseVersion = databaseVersion;
        this.mDelegate = supportSQLiteOpenHelper;
    }

    public String getDatabaseName() {
        return this.mDelegate.getDatabaseName();
    }

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.mDelegate.setWriteAheadLoggingEnabled(enabled);
    }

    public synchronized SupportSQLiteDatabase getWritableDatabase() {
        if (!this.mVerified) {
            this.verifyDatabaseFile(true);
            this.mVerified = true;
        }
        return this.mDelegate.getWritableDatabase();
    }

    public synchronized SupportSQLiteDatabase getReadableDatabase() {
        if (!this.mVerified) {
            this.verifyDatabaseFile(false);
            this.mVerified = true;
        }
        return this.mDelegate.getReadableDatabase();
    }

    public synchronized void close() {
        this.mDelegate.close();
        this.mVerified = false;
    }

    @Override
    @NonNull
    public SupportSQLiteOpenHelper getDelegate() {
        return this.mDelegate;
    }

    void setDatabaseConfiguration(@Nullable DatabaseConfiguration databaseConfiguration) {
        this.mDatabaseConfiguration = databaseConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyDatabaseFile(boolean writable) {
        String databaseName = this.getDatabaseName();
        File databaseFile = this.mContext.getDatabasePath(databaseName);
        boolean processLevelLock = this.mDatabaseConfiguration == null || this.mDatabaseConfiguration.multiInstanceInvalidation;
        CopyLock copyLock = new CopyLock(databaseName, this.mContext.getFilesDir(), processLevelLock);
        try {
            int currentVersion;
            copyLock.lock();
            if (!databaseFile.exists()) {
                try {
                    this.copyDatabaseFile(databaseFile, writable);
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy database file.", e);
                }
            }
            if (this.mDatabaseConfiguration == null) {
                return;
            }
            try {
                currentVersion = DBUtil.readVersion(databaseFile);
            }
            catch (IOException e) {
                Log.w((String)"ROOM", (String)"Unable to read database version.", (Throwable)e);
                copyLock.unlock();
                return;
            }
            if (currentVersion == this.mDatabaseVersion) {
                return;
            }
            if (this.mDatabaseConfiguration.isMigrationRequired(currentVersion, this.mDatabaseVersion)) {
                return;
            }
            if (this.mContext.deleteDatabase(databaseName)) {
                try {
                    this.copyDatabaseFile(databaseFile, writable);
                    return;
                }
                catch (IOException e) {
                    Log.w((String)"ROOM", (String)"Unable to copy database file.", (Throwable)e);
                    return;
                }
            }
            Log.w((String)"ROOM", (String)("Failed to delete database file (" + databaseName + ") for a copy destructive migration."));
            return;
        }
        finally {
            copyLock.unlock();
        }
    }

    private void copyDatabaseFile(File destinationFile, boolean writable) throws IOException {
        ReadableByteChannel input;
        if (this.mCopyFromAssetPath != null) {
            input = Channels.newChannel(this.mContext.getAssets().open(this.mCopyFromAssetPath));
        } else if (this.mCopyFromFile != null) {
            input = new FileInputStream(this.mCopyFromFile).getChannel();
        } else if (this.mCopyFromInputStream != null) {
            InputStream inputStream;
            try {
                inputStream = this.mCopyFromInputStream.call();
            }
            catch (Exception e) {
                throw new IOException("inputStreamCallable exception on call", e);
            }
            input = Channels.newChannel(inputStream);
        } else {
            throw new IllegalStateException("copyFromAssetPath, copyFromFile and copyFromInputStream are all null!");
        }
        File intermediateFile = File.createTempFile("room-copy-helper", ".tmp", this.mContext.getCacheDir());
        intermediateFile.deleteOnExit();
        FileChannel output = new FileOutputStream(intermediateFile).getChannel();
        FileUtil.copy(input, output);
        File parent = destinationFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directories for " + destinationFile.getAbsolutePath());
        }
        this.dispatchOnOpenPrepackagedDatabase(intermediateFile, writable);
        if (!intermediateFile.renameTo(destinationFile)) {
            throw new IOException("Failed to move intermediate file (" + intermediateFile.getAbsolutePath() + ") to destination (" + destinationFile.getAbsolutePath() + ").");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchOnOpenPrepackagedDatabase(File databaseFile, boolean writable) {
        if (this.mDatabaseConfiguration == null || this.mDatabaseConfiguration.prepackagedDatabaseCallback == null) {
            return;
        }
        try (SupportSQLiteOpenHelper helper = this.createFrameworkOpenHelper(databaseFile);){
            SupportSQLiteDatabase db = writable ? helper.getWritableDatabase() : helper.getReadableDatabase();
            this.mDatabaseConfiguration.prepackagedDatabaseCallback.onOpenPrepackagedDatabase(db);
        }
    }

    private SupportSQLiteOpenHelper createFrameworkOpenHelper(File databaseFile) {
        int version;
        String databaseName = databaseFile.getName();
        try {
            version = DBUtil.readVersion(databaseFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Malformed database file, unable to read version.", e);
        }
        FrameworkSQLiteOpenHelperFactory factory = new FrameworkSQLiteOpenHelperFactory();
        SupportSQLiteOpenHelper.Configuration configuration = SupportSQLiteOpenHelper.Configuration.builder((Context)this.mContext).name(databaseName).callback(new SupportSQLiteOpenHelper.Callback(version){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
            }

            public void onUpgrade(@NonNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            }
        }).build();
        return factory.create(configuration);
    }
}

