/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class EntityDeletionOrUpdateAdapter<T>
extends SharedSQLiteStatement {
    public EntityDeletionOrUpdateAdapter(RoomDatabase database) {
        super(database);
    }

    @Override
    protected abstract String createQuery();

    protected abstract void bind(SupportSQLiteStatement var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handle(T entity) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            this.bind(stmt, entity);
            int n = stmt.executeUpdateDelete();
            return n;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handleMultiple(Iterable<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            int total = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                total += stmt.executeUpdateDelete();
            }
            int n = total;
            return n;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handleMultiple(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            int total = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                total += stmt.executeUpdateDelete();
            }
            int n = total;
            return n;
        }
        finally {
            this.release(stmt);
        }
    }
}

