/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@UnstableApi
public final class DataSpec {
    public static final int FLAG_ALLOW_GZIP = 1;
    public static final int FLAG_DONT_CACHE_IF_LENGTH_UNKNOWN = 2;
    public static final int FLAG_ALLOW_CACHE_FRAGMENTATION = 4;
    public static final int FLAG_MIGHT_NOT_USE_FULL_NETWORK_SPEED = 8;
    public static final int HTTP_METHOD_GET = 1;
    public static final int HTTP_METHOD_POST = 2;
    public static final int HTTP_METHOD_HEAD = 3;
    public final Uri uri;
    public final long uriPositionOffset;
    public final int httpMethod;
    @Nullable
    public final byte[] httpBody;
    public final Map<String, String> httpRequestHeaders;
    @Deprecated
    public final long absoluteStreamPosition;
    public final long position;
    public final long length;
    @Nullable
    public final String key;
    public final int flags;
    @Nullable
    public final Object customData;

    public static String getStringForHttpMethod(int httpMethod) {
        switch (httpMethod) {
            case 1: {
                return "GET";
            }
            case 2: {
                return "POST";
            }
            case 3: {
                return "HEAD";
            }
        }
        throw new IllegalStateException();
    }

    public DataSpec(Uri uri) {
        this(uri, 0L, -1L);
    }

    public DataSpec(Uri uri, long position, long length) {
        this(uri, position, length, null);
    }

    @Deprecated
    public DataSpec(Uri uri, long position, long length, @Nullable String key) {
        this(uri, 0L, 1, null, Collections.emptyMap(), position, length, key, 0, null);
    }

    private DataSpec(Uri uri, long uriPositionOffset, int httpMethod, @Nullable byte[] httpBody, Map<String, String> httpRequestHeaders, long position, long length, @Nullable String key, int flags, @Nullable Object customData) {
        Assertions.checkArgument((uriPositionOffset + position >= 0L ? 1 : 0) != 0);
        Assertions.checkArgument((position >= 0L ? 1 : 0) != 0);
        Assertions.checkArgument((length > 0L || length == -1L ? 1 : 0) != 0);
        this.uri = (Uri)Assertions.checkNotNull((Object)uri);
        this.uriPositionOffset = uriPositionOffset;
        this.httpMethod = httpMethod;
        this.httpBody = httpBody != null && httpBody.length != 0 ? httpBody : null;
        this.httpRequestHeaders = Collections.unmodifiableMap(new HashMap<String, String>(httpRequestHeaders));
        this.position = position;
        this.absoluteStreamPosition = uriPositionOffset + position;
        this.length = length;
        this.key = key;
        this.flags = flags;
        this.customData = customData;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) == flag;
    }

    public final String getHttpMethodString() {
        return DataSpec.getStringForHttpMethod(this.httpMethod);
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public DataSpec subrange(long offset) {
        return this.subrange(offset, this.length == -1L ? -1L : this.length - offset);
    }

    public DataSpec subrange(long offset, long length) {
        if (offset == 0L && this.length == length) {
            return this;
        }
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position + offset, length, this.key, this.flags, this.customData);
    }

    public DataSpec withUri(Uri uri) {
        return new DataSpec(uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
    }

    public DataSpec withRequestHeaders(Map<String, String> httpRequestHeaders) {
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
    }

    public DataSpec withAdditionalHeaders(Map<String, String> additionalHttpRequestHeaders) {
        HashMap<String, String> httpRequestHeaders = new HashMap<String, String>(this.httpRequestHeaders);
        httpRequestHeaders.putAll(additionalHttpRequestHeaders);
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
    }

    public String toString() {
        return "DataSpec[" + this.getHttpMethodString() + " " + this.uri + ", " + this.position + ", " + this.length + ", " + this.key + ", " + this.flags + "]";
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.datasource");
    }

    public static final class Builder {
        @Nullable
        private Uri uri;
        private long uriPositionOffset;
        private int httpMethod;
        @Nullable
        private byte[] httpBody;
        private Map<String, String> httpRequestHeaders;
        private long position;
        private long length;
        @Nullable
        private String key;
        private int flags;
        @Nullable
        private Object customData;

        public Builder() {
            this.httpMethod = 1;
            this.httpRequestHeaders = Collections.emptyMap();
            this.length = -1L;
        }

        private Builder(DataSpec dataSpec) {
            this.uri = dataSpec.uri;
            this.uriPositionOffset = dataSpec.uriPositionOffset;
            this.httpMethod = dataSpec.httpMethod;
            this.httpBody = dataSpec.httpBody;
            this.httpRequestHeaders = dataSpec.httpRequestHeaders;
            this.position = dataSpec.position;
            this.length = dataSpec.length;
            this.key = dataSpec.key;
            this.flags = dataSpec.flags;
            this.customData = dataSpec.customData;
        }

        @CanIgnoreReturnValue
        public Builder setUri(String uriString) {
            this.uri = Uri.parse((String)uriString);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUriPositionOffset(long uriPositionOffset) {
            this.uriPositionOffset = uriPositionOffset;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpMethod(int httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpBody(@Nullable byte[] httpBody) {
            this.httpBody = httpBody;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
            this.httpRequestHeaders = httpRequestHeaders;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPosition(long position) {
            this.position = position;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLength(long length) {
            this.length = length;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCustomData(@Nullable Object customData) {
            this.customData = customData;
            return this;
        }

        public DataSpec build() {
            Assertions.checkStateNotNull((Object)this.uri, (Object)"The uri must be set.");
            return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface HttpMethod {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

