/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import java.io.IOException;

@UnstableApi
public final class ByteArrayDataSource
extends BaseDataSource {
    private final UriResolver uriResolver;
    @Nullable
    private Uri uri;
    @Nullable
    private byte[] data;
    private int readPosition;
    private int bytesRemaining;
    private boolean opened;

    public ByteArrayDataSource(byte[] data) {
        this(unusedUri -> data);
        Assertions.checkArgument((data.length > 0 ? 1 : 0) != 0);
    }

    public ByteArrayDataSource(UriResolver uriResolver) {
        super(false);
        this.uriResolver = (UriResolver)Assertions.checkNotNull((Object)uriResolver);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.transferInitializing(dataSpec);
        this.uri = dataSpec.uri;
        this.data = this.uriResolver.resolve(this.uri);
        if (dataSpec.position > (long)this.data.length) {
            throw new DataSourceException(2008);
        }
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = this.data.length - (int)dataSpec.position;
        if (dataSpec.length != -1L) {
            this.bytesRemaining = (int)Math.min((long)this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : (long)this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        length = Math.min(length, this.bytesRemaining);
        System.arraycopy(Assertions.checkStateNotNull((Object)this.data), this.readPosition, buffer, offset, length);
        this.readPosition += length;
        this.bytesRemaining -= length;
        this.bytesTransferred(length);
        return length;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
        }
        this.uri = null;
        this.data = null;
    }

    public static interface UriResolver {
        public byte[] resolve(Uri var1) throws IOException;
    }
}

