/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.UnstableApi;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@UnstableApi
public final class BitmapUtil {
    private BitmapUtil() {
    }

    public static Bitmap decode(byte[] data, int length, @Nullable BitmapFactory.Options options, int maximumOutputDimension) throws IOException {
        ExifInterface exifInterface;
        if (maximumOutputDimension != -1) {
            if (options == null) {
                options = new BitmapFactory.Options();
            }
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)length, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = 1;
            for (int largerDimensions = Math.max(options.outWidth, options.outHeight); largerDimensions > maximumOutputDimension; largerDimensions /= 2) {
                options.inSampleSize *= 2;
            }
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)length, (BitmapFactory.Options)options);
        if (options != null) {
            options.inSampleSize = 1;
        }
        if (bitmap == null) {
            throw ParserException.createForMalformedContainer((String)"Could not decode image data", (Throwable)new IllegalStateException());
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            exifInterface = new ExifInterface((InputStream)inputStream);
        }
        int rotationDegrees = exifInterface.getRotationDegrees();
        if (rotationDegrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotationDegrees);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        return bitmap;
    }
}

