/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class ViewModel {
    @Nullable
    private final Map<String, Object> mBagOfTags = new HashMap<String, Object>();
    @Nullable
    private final Set<Closeable> mCloseables = new LinkedHashSet<Closeable>();
    private volatile boolean mCleared = false;

    public ViewModel() {
    }

    public ViewModel(Closeable ... closeables) {
        this.mCloseables.addAll(Arrays.asList(closeables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseable(@NonNull Closeable closeable) {
        if (this.mCleared) {
            ViewModel.closeWithRuntimeException(closeable);
            return;
        }
        if (this.mCloseables != null) {
            Set<Closeable> set = this.mCloseables;
            synchronized (set) {
                this.mCloseables.add(closeable);
            }
        }
    }

    protected void onCleared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    final void clear() {
        Object object;
        this.mCleared = true;
        if (this.mBagOfTags != null) {
            object = this.mBagOfTags;
            synchronized (object) {
                for (Object value : this.mBagOfTags.values()) {
                    ViewModel.closeWithRuntimeException(value);
                }
            }
        }
        if (this.mCloseables != null) {
            object = this.mCloseables;
            synchronized (object) {
                for (Closeable closeable : this.mCloseables) {
                    ViewModel.closeWithRuntimeException(closeable);
                }
            }
            this.mCloseables.clear();
        }
        this.onCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCloseable(@NonNull String key, @NonNull Closeable closeable) {
        if (this.mCleared) {
            ViewModel.closeWithRuntimeException(closeable);
            return;
        }
        if (this.mBagOfTags != null) {
            Map<String, Object> map = this.mBagOfTags;
            synchronized (map) {
                this.mBagOfTags.put(key, closeable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends Closeable> T getCloseable(@NonNull String key) {
        if (this.mBagOfTags == null) {
            return null;
        }
        Map<String, Object> map = this.mBagOfTags;
        synchronized (map) {
            return (T)((Closeable)this.mBagOfTags.get(key));
        }
    }

    private static void closeWithRuntimeException(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

