/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleAttacher;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.SavedStateHandlesProvider;
import androidx.lifecycle.SavedStateHandlesVM;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0018H\u0007\u001a\u001f\u0010\u0019\u001a\u00020\u001a\"\f\b\u0000\u0010\u001b*\u00020\u0006*\u00020\t*\u0002H\u001bH\u0007\u00a2\u0006\u0002\u0010\u001c\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"DEFAULT_ARGS_KEY", "Landroidx/lifecycle/viewmodel/CreationExtras$Key;", "Landroid/os/Bundle;", "SAVED_STATE_KEY", "", "SAVED_STATE_REGISTRY_OWNER_KEY", "Landroidx/savedstate/SavedStateRegistryOwner;", "VIEWMODEL_KEY", "VIEW_MODEL_STORE_OWNER_KEY", "Landroidx/lifecycle/ViewModelStoreOwner;", "savedStateHandlesProvider", "Landroidx/lifecycle/SavedStateHandlesProvider;", "getSavedStateHandlesProvider", "(Landroidx/savedstate/SavedStateRegistryOwner;)Landroidx/lifecycle/SavedStateHandlesProvider;", "savedStateHandlesVM", "Landroidx/lifecycle/SavedStateHandlesVM;", "getSavedStateHandlesVM", "(Landroidx/lifecycle/ViewModelStoreOwner;)Landroidx/lifecycle/SavedStateHandlesVM;", "createSavedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "savedStateRegistryOwner", "viewModelStoreOwner", "key", "defaultArgs", "Landroidx/lifecycle/viewmodel/CreationExtras;", "enableSavedStateHandles", "", "T", "(Landroidx/savedstate/SavedStateRegistryOwner;)V", "lifecycle-viewmodel-savedstate_release"})
@JvmName(name="SavedStateHandleSupport")
public final class SavedStateHandleSupport {
    @NotNull
    private static final String VIEWMODEL_KEY = "androidx.lifecycle.internal.SavedStateHandlesVM";
    @NotNull
    private static final String SAVED_STATE_KEY = "androidx.lifecycle.internal.SavedStateHandlesProvider";
    @JvmField
    @NotNull
    public static final CreationExtras.Key<SavedStateRegistryOwner> SAVED_STATE_REGISTRY_OWNER_KEY = (CreationExtras.Key)new CreationExtras.Key<SavedStateRegistryOwner>(){};
    @JvmField
    @NotNull
    public static final CreationExtras.Key<ViewModelStoreOwner> VIEW_MODEL_STORE_OWNER_KEY = (CreationExtras.Key)new CreationExtras.Key<ViewModelStoreOwner>(){};
    @JvmField
    @NotNull
    public static final CreationExtras.Key<Bundle> DEFAULT_ARGS_KEY = (CreationExtras.Key)new CreationExtras.Key<Bundle>(){};

    @MainThread
    public static final <T extends SavedStateRegistryOwner & ViewModelStoreOwner> void enableSavedStateHandles(@NotNull T $this$enableSavedStateHandles) {
        Intrinsics.checkNotNullParameter($this$enableSavedStateHandles, (String)"<this>");
        Lifecycle.State state = $this$enableSavedStateHandles.getLifecycle().getCurrentState();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"lifecycle.currentState");
        Lifecycle.State currentState = state;
        if (!(currentState == Lifecycle.State.INITIALIZED || currentState == Lifecycle.State.CREATED)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$enableSavedStateHandles.getSavedStateRegistry().getSavedStateProvider(SAVED_STATE_KEY) == null) {
            SavedStateHandlesProvider provider = new SavedStateHandlesProvider($this$enableSavedStateHandles.getSavedStateRegistry(), $this$enableSavedStateHandles);
            $this$enableSavedStateHandles.getSavedStateRegistry().registerSavedStateProvider(SAVED_STATE_KEY, (SavedStateRegistry.SavedStateProvider)provider);
            $this$enableSavedStateHandles.getSavedStateRegistry().runOnNextRecreation(SavedStateHandleAttacher.class);
        }
    }

    private static final SavedStateHandle createSavedStateHandle(SavedStateRegistryOwner savedStateRegistryOwner, ViewModelStoreOwner viewModelStoreOwner, String key, Bundle defaultArgs) {
        SavedStateHandle savedStateHandle;
        SavedStateHandlesProvider provider = SavedStateHandleSupport.getSavedStateHandlesProvider(savedStateRegistryOwner);
        SavedStateHandlesVM viewModel2 = SavedStateHandleSupport.getSavedStateHandlesVM(viewModelStoreOwner);
        SavedStateHandle savedStateHandle2 = viewModel2.getHandles().get(key);
        if (savedStateHandle2 == null) {
            SavedStateHandle savedStateHandle3;
            SavedStateHandle it = savedStateHandle3 = SavedStateHandle.Companion.createHandle(provider.consumeRestoredStateForKey(key), defaultArgs);
            boolean bl = false;
            viewModel2.getHandles().put(key, it);
            savedStateHandle = savedStateHandle3;
        } else {
            savedStateHandle = savedStateHandle2;
        }
        return savedStateHandle;
    }

    @MainThread
    @NotNull
    public static final SavedStateHandle createSavedStateHandle(@NotNull CreationExtras $this$createSavedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)$this$createSavedStateHandle, (String)"<this>");
        SavedStateRegistryOwner savedStateRegistryOwner = (SavedStateRegistryOwner)$this$createSavedStateHandle.get(SAVED_STATE_REGISTRY_OWNER_KEY);
        if (savedStateRegistryOwner == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `SAVED_STATE_REGISTRY_OWNER_KEY`");
        }
        SavedStateRegistryOwner savedStateRegistryOwner2 = savedStateRegistryOwner;
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$createSavedStateHandle.get(VIEW_MODEL_STORE_OWNER_KEY);
        if (viewModelStoreOwner == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `VIEW_MODEL_STORE_OWNER_KEY`");
        }
        ViewModelStoreOwner viewModelStateRegistryOwner = viewModelStoreOwner;
        Bundle defaultArgs = (Bundle)$this$createSavedStateHandle.get(DEFAULT_ARGS_KEY);
        String string = (String)$this$createSavedStateHandle.get(ViewModelProvider.NewInstanceFactory.VIEW_MODEL_KEY);
        if (string == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `VIEW_MODEL_KEY`");
        }
        String key = string;
        return SavedStateHandleSupport.createSavedStateHandle(savedStateRegistryOwner2, viewModelStateRegistryOwner, key, defaultArgs);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SavedStateHandlesVM getSavedStateHandlesVM(@NotNull ViewModelStoreOwner $this$savedStateHandlesVM) {
        void $this$initializer$iv;
        void $this$_get_savedStateHandlesVM__u24lambda_u2d1;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$savedStateHandlesVM, (String)"<this>");
        boolean $i$f$viewModelFactory = false;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
        ViewModelStoreOwner viewModelStoreOwner = $this$savedStateHandlesVM;
        boolean bl = false;
        void var5_6 = $this$_get_savedStateHandlesVM__u24lambda_u2d1;
        Function1 initializer$iv = savedStateHandlesVM.1.1.INSTANCE;
        boolean $i$f$initializer = false;
        $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(SavedStateHandlesVM.class), initializer$iv);
        ViewModelProvider.Factory factory = initializerViewModelFactoryBuilder.build();
        ViewModelStoreOwner viewModelStoreOwner2 = viewModelStoreOwner;
        return (SavedStateHandlesVM)new ViewModelProvider(viewModelStoreOwner2, factory).get(VIEWMODEL_KEY, SavedStateHandlesVM.class);
    }

    @NotNull
    public static final SavedStateHandlesProvider getSavedStateHandlesProvider(@NotNull SavedStateRegistryOwner $this$savedStateHandlesProvider) {
        SavedStateHandlesProvider savedStateHandlesProvider;
        Intrinsics.checkNotNullParameter((Object)$this$savedStateHandlesProvider, (String)"<this>");
        SavedStateRegistry.SavedStateProvider savedStateProvider = $this$savedStateHandlesProvider.getSavedStateRegistry().getSavedStateProvider(SAVED_STATE_KEY);
        SavedStateHandlesProvider savedStateHandlesProvider2 = savedStateHandlesProvider = savedStateProvider instanceof SavedStateHandlesProvider ? (SavedStateHandlesProvider)savedStateProvider : null;
        if (savedStateHandlesProvider == null) {
            throw new IllegalStateException("enableSavedStateHandles() wasn't called prior to createSavedStateHandle() call");
        }
        return savedStateHandlesProvider;
    }
}

