/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.savedstate.SavedStateRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SavedStateHandle {
    final Map<String, Object> mRegular;
    private final Map<String, SavingStateLiveData<?>> mLiveDatas = new HashMap();
    private static final String VALUES = "values";
    private static final String KEYS = "keys";
    private final SavedStateRegistry.SavedStateProvider mSavedStateProvider = new SavedStateRegistry.SavedStateProvider(){

        @NonNull
        public Bundle saveState() {
            Set<String> keySet = SavedStateHandle.this.mRegular.keySet();
            ArrayList<String> keys = new ArrayList<String>(keySet.size());
            ArrayList<Object> value = new ArrayList<Object>(keys.size());
            for (String key : keySet) {
                keys.add(key);
                value.add(SavedStateHandle.this.mRegular.get(key));
            }
            Bundle res = new Bundle();
            res.putParcelableArrayList(SavedStateHandle.KEYS, keys);
            res.putParcelableArrayList(SavedStateHandle.VALUES, value);
            return res;
        }
    };
    private static final Class[] ACCEPTABLE_CLASSES = new Class[]{Boolean.TYPE, boolean[].class, Double.TYPE, double[].class, Integer.TYPE, int[].class, Long.TYPE, long[].class, String.class, String[].class, Binder.class, Bundle.class, Byte.TYPE, byte[].class, Character.TYPE, char[].class, CharSequence.class, CharSequence[].class, ArrayList.class, Float.TYPE, float[].class, Parcelable.class, Parcelable[].class, Serializable.class, Short.TYPE, short[].class, SparseArray.class, Build.VERSION.SDK_INT >= 21 ? Size.class : Integer.TYPE, Build.VERSION.SDK_INT >= 21 ? SizeF.class : Integer.TYPE};

    public SavedStateHandle(@NonNull Map<String, Object> initialState) {
        this.mRegular = new HashMap<String, Object>(initialState);
    }

    public SavedStateHandle() {
        this.mRegular = new HashMap<String, Object>();
    }

    static SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
        if (restoredState == null && defaultState == null) {
            return new SavedStateHandle();
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        if (defaultState != null) {
            for (String key : defaultState.keySet()) {
                state.put(key, defaultState.get(key));
            }
        }
        if (restoredState == null) {
            return new SavedStateHandle(state);
        }
        ArrayList keys = restoredState.getParcelableArrayList(KEYS);
        ArrayList values = restoredState.getParcelableArrayList(VALUES);
        if (keys == null || values == null || keys.size() != values.size()) {
            throw new IllegalStateException("Invalid bundle passed as restored state");
        }
        for (int i = 0; i < keys.size(); ++i) {
            state.put((String)keys.get(i), values.get(i));
        }
        return new SavedStateHandle(state);
    }

    @NonNull
    SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.mSavedStateProvider;
    }

    @MainThread
    public boolean contains(@NonNull String key) {
        return this.mRegular.containsKey(key);
    }

    @MainThread
    @NonNull
    public <T> MutableLiveData<T> getLiveData(@NonNull String key) {
        return this.getLiveDataInternal(key, false, null);
    }

    @MainThread
    @NonNull
    public <T> MutableLiveData<T> getLiveData(@NonNull String key, @SuppressLint(value={"UnknownNullness"}) T initialValue) {
        return this.getLiveDataInternal(key, true, initialValue);
    }

    @NonNull
    private <T> MutableLiveData<T> getLiveDataInternal(@NonNull String key, boolean hasInitialValue, @Nullable T initialValue) {
        MutableLiveData liveData = this.mLiveDatas.get(key);
        if (liveData != null) {
            return liveData;
        }
        SavingStateLiveData<Object> mutableLd = this.mRegular.containsKey(key) ? new SavingStateLiveData<Object>(this, key, this.mRegular.get(key)) : (hasInitialValue ? new SavingStateLiveData<T>(this, key, initialValue) : new SavingStateLiveData(this, key));
        this.mLiveDatas.put(key, mutableLd);
        return mutableLd;
    }

    @MainThread
    @NonNull
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.mRegular.keySet());
    }

    @MainThread
    @Nullable
    public <T> T get(@NonNull String key) {
        return (T)this.mRegular.get(key);
    }

    @MainThread
    public <T> void set(@NonNull String key, @Nullable T value) {
        SavedStateHandle.validateValue(value);
        MutableLiveData mutableLiveData = this.mLiveDatas.get(key);
        if (mutableLiveData != null) {
            mutableLiveData.setValue(value);
        } else {
            this.mRegular.put(key, value);
        }
    }

    private static void validateValue(Object value) {
        if (value == null) {
            return;
        }
        for (Class cl : ACCEPTABLE_CLASSES) {
            if (!cl.isInstance(value)) continue;
            return;
        }
        throw new IllegalArgumentException("Can't put value with type " + value.getClass() + " into saved state");
    }

    @MainThread
    @Nullable
    public <T> T remove(@NonNull String key) {
        Object latestValue = this.mRegular.remove(key);
        SavingStateLiveData<?> liveData = this.mLiveDatas.remove(key);
        if (liveData != null) {
            liveData.detach();
        }
        return (T)latestValue;
    }

    static class SavingStateLiveData<T>
    extends MutableLiveData<T> {
        private String mKey;
        private SavedStateHandle mHandle;

        SavingStateLiveData(SavedStateHandle handle, String key, T value) {
            super(value);
            this.mKey = key;
            this.mHandle = handle;
        }

        SavingStateLiveData(SavedStateHandle handle, String key) {
            this.mKey = key;
            this.mHandle = handle;
        }

        public void setValue(T value) {
            if (this.mHandle != null) {
                this.mHandle.mRegular.put(this.mKey, value);
            }
            super.setValue(value);
        }

        void detach() {
            this.mHandle = null;
        }
    }
}

