/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;

public abstract class AbstractSavedStateViewModelFactory
extends ViewModelProvider.KeyedFactory {
    static final String TAG_SAVED_STATE_HANDLE_CONTROLLER = "androidx.lifecycle.savedstate.vm.tag";
    private final SavedStateRegistry mSavedStateRegistry;
    private final Lifecycle mLifecycle;
    private final Bundle mDefaultArgs;

    public AbstractSavedStateViewModelFactory(@NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
        this.mSavedStateRegistry = owner.getSavedStateRegistry();
        this.mLifecycle = owner.getLifecycle();
        this.mDefaultArgs = defaultArgs;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public final <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass) {
        Bundle restoredState = this.mSavedStateRegistry.consumeRestoredStateForKey(key);
        SavedStateHandle handle = SavedStateHandle.createHandle(restoredState, this.mDefaultArgs);
        SavedStateHandleController controller = new SavedStateHandleController(key, handle);
        controller.attachToLifecycle(this.mSavedStateRegistry, this.mLifecycle);
        T viewmodel = this.create(key, modelClass, handle);
        viewmodel.setTagIfAbsent(TAG_SAVED_STATE_HANDLE_CONTROLLER, (Object)controller);
        this.mSavedStateRegistry.runOnNextRecreation(OnRecreation.class);
        return viewmodel;
    }

    @NonNull
    public final <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        String canonicalName = modelClass.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        return this.create(canonicalName, modelClass);
    }

    @NonNull
    protected abstract <T extends ViewModel> T create(@NonNull String var1, @NonNull Class<T> var2, @NonNull SavedStateHandle var3);

    static final class SavedStateHandleController
    implements LifecycleEventObserver {
        private final String mKey;
        boolean mIsAttached = false;
        private final SavedStateHandle mHandle;

        SavedStateHandleController(String key, SavedStateHandle handle) {
            this.mKey = key;
            this.mHandle = handle;
        }

        boolean isAttached() {
            return this.mIsAttached;
        }

        void attachToLifecycle(SavedStateRegistry registry, Lifecycle lifecycle) {
            if (this.mIsAttached) {
                throw new IllegalStateException("Already attached to lifecycleOwner");
            }
            this.mIsAttached = true;
            lifecycle.addObserver((LifecycleObserver)this);
            registry.registerSavedStateProvider(this.mKey, this.mHandle.savedStateProvider());
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_DESTROY) {
                this.mIsAttached = false;
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }

    static final class OnRecreation
    implements SavedStateRegistry.AutoRecreated {
        OnRecreation() {
        }

        public void onRecreated(@NonNull SavedStateRegistryOwner owner) {
            if (!(owner instanceof ViewModelStoreOwner)) {
                throw new IllegalStateException("Internal error: OnRecreation should be registered only on componentsthat implement ViewModelStoreOwner");
            }
            ViewModelStore viewModelStore = ((ViewModelStoreOwner)owner).getViewModelStore();
            SavedStateRegistry savedStateRegistry = owner.getSavedStateRegistry();
            for (String key : viewModelStore.keys()) {
                ViewModel viewModel = viewModelStore.get(key);
                SavedStateHandleController controller = (SavedStateHandleController)viewModel.getTag(AbstractSavedStateViewModelFactory.TAG_SAVED_STATE_HANDLE_CONTROLLER);
                if (controller == null || controller.isAttached()) continue;
                controller.attachToLifecycle(owner.getSavedStateRegistry(), owner.getLifecycle());
            }
            if (!viewModelStore.keys().isEmpty()) {
                savedStateRegistry.runOnNextRecreation(OnRecreation.class);
            }
        }
    }
}

