/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.LifecycleRegistryOwner;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/lifecycle/ReportFragment;", "Landroid/app/Fragment;", "()V", "processListener", "Landroidx/lifecycle/ReportFragment$ActivityInitializationListener;", "dispatch", "", "event", "Landroidx/lifecycle/Lifecycle$Event;", "dispatchCreate", "listener", "dispatchResume", "dispatchStart", "onActivityCreated", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onResume", "onStart", "onStop", "setProcessListener", "ActivityInitializationListener", "Companion", "LifecycleCallbacks", "lifecycle-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ReportFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ActivityInitializationListener processListener;
    @NotNull
    private static final String REPORT_FRAGMENT_TAG = "androidx.lifecycle.LifecycleDispatcher.report_fragment_tag";

    private final void dispatchCreate(ActivityInitializationListener listener) {
        block0: {
            ActivityInitializationListener activityInitializationListener = listener;
            if (activityInitializationListener == null) break block0;
            activityInitializationListener.onCreate();
        }
    }

    private final void dispatchStart(ActivityInitializationListener listener) {
        block0: {
            ActivityInitializationListener activityInitializationListener = listener;
            if (activityInitializationListener == null) break block0;
            activityInitializationListener.onStart();
        }
    }

    private final void dispatchResume(ActivityInitializationListener listener) {
        block0: {
            ActivityInitializationListener activityInitializationListener = listener;
            if (activityInitializationListener == null) break block0;
            activityInitializationListener.onResume();
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.dispatchCreate(this.processListener);
        this.dispatch(Lifecycle.Event.ON_CREATE);
    }

    public void onStart() {
        super.onStart();
        this.dispatchStart(this.processListener);
        this.dispatch(Lifecycle.Event.ON_START);
    }

    public void onResume() {
        super.onResume();
        this.dispatchResume(this.processListener);
        this.dispatch(Lifecycle.Event.ON_RESUME);
    }

    public void onPause() {
        super.onPause();
        this.dispatch(Lifecycle.Event.ON_PAUSE);
    }

    public void onStop() {
        super.onStop();
        this.dispatch(Lifecycle.Event.ON_STOP);
    }

    public void onDestroy() {
        super.onDestroy();
        this.dispatch(Lifecycle.Event.ON_DESTROY);
        this.processListener = null;
    }

    private final void dispatch(Lifecycle.Event event) {
        if (Build.VERSION.SDK_INT < 29) {
            Activity activity = this.getActivity();
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, event);
        }
    }

    public final void setProcessListener(@Nullable ActivityInitializationListener processListener) {
        this.processListener = processListener;
    }

    @JvmStatic
    public static final void injectIfNeededIn(@NotNull Activity activity) {
        Companion.injectIfNeededIn(activity);
    }

    @JvmStatic
    public static final void dispatch$lifecycle_runtime_release(@NotNull Activity activity, @NotNull Lifecycle.Event event) {
        Companion.dispatch$lifecycle_runtime_release(activity, event);
    }

    @JvmName(name="get")
    @NotNull
    public static final ReportFragment get(@NotNull Activity $this$get) {
        return Companion.get($this$get);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Landroidx/lifecycle/ReportFragment$ActivityInitializationListener;", "", "onCreate", "", "onResume", "onStart", "lifecycle-runtime_release"})
    public static interface ActivityInitializationListener {
        public void onCreate();

        public void onStart();

        public void onResume();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00078GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Landroidx/lifecycle/ReportFragment$Companion;", "", "()V", "REPORT_FRAGMENT_TAG", "", "reportFragment", "Landroidx/lifecycle/ReportFragment;", "Landroid/app/Activity;", "get$annotations", "(Landroid/app/Activity;)V", "get", "(Landroid/app/Activity;)Landroidx/lifecycle/ReportFragment;", "dispatch", "", "activity", "event", "Landroidx/lifecycle/Lifecycle$Event;", "dispatch$lifecycle_runtime_release", "injectIfNeededIn", "lifecycle-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void injectIfNeededIn(@NotNull Activity activity) {
            FragmentManager manager;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (Build.VERSION.SDK_INT >= 29) {
                LifecycleCallbacks.Companion.registerIn(activity);
            }
            if ((manager = activity.getFragmentManager()).findFragmentByTag(ReportFragment.REPORT_FRAGMENT_TAG) == null) {
                manager.beginTransaction().add((Fragment)new ReportFragment(), ReportFragment.REPORT_FRAGMENT_TAG).commit();
                manager.executePendingTransactions();
            }
        }

        @JvmStatic
        public final void dispatch$lifecycle_runtime_release(@NotNull Activity activity, @NotNull Lifecycle.Event event) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (activity instanceof LifecycleRegistryOwner) {
                ((LifecycleRegistryOwner)activity).getLifecycle().handleLifecycleEvent(event);
                return;
            }
            if (activity instanceof LifecycleOwner) {
                Lifecycle lifecycle = ((LifecycleOwner)activity).getLifecycle();
                Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"activity as LifecycleOwner).lifecycle");
                Lifecycle lifecycle2 = lifecycle;
                if (lifecycle2 instanceof LifecycleRegistry) {
                    ((LifecycleRegistry)lifecycle2).handleLifecycleEvent(event);
                }
            }
        }

        @JvmName(name="get")
        @NotNull
        public final ReportFragment get(@NotNull Activity $this$reportFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$reportFragment, (String)"<this>");
            Fragment fragment = $this$reportFragment.getFragmentManager().findFragmentByTag(ReportFragment.REPORT_FRAGMENT_TAG);
            Intrinsics.checkNotNull((Object)fragment, (String)"null cannot be cast to non-null type androidx.lifecycle.ReportFragment");
            return (ReportFragment)fragment;
        }

        @JvmStatic
        public static /* synthetic */ void get$annotations(Activity activity) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/lifecycle/ReportFragment$LifecycleCallbacks;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "bundle", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityPostCreated", "savedInstanceState", "onActivityPostResumed", "onActivityPostStarted", "onActivityPreDestroyed", "onActivityPrePaused", "onActivityPreStopped", "onActivityResumed", "onActivitySaveInstanceState", "onActivityStarted", "onActivityStopped", "Companion", "lifecycle-runtime_release"})
    @RequiresApi(value=29)
    public static final class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPostCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_CREATE);
        }

        public void onActivityStarted(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPostStarted(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_START);
        }

        public void onActivityResumed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPostResumed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_RESUME);
        }

        public void onActivityPrePaused(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_PAUSE);
        }

        public void onActivityPaused(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPreStopped(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_STOP);
        }

        public void onActivityStopped(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        }

        public void onActivityPreDestroyed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Companion.dispatch$lifecycle_runtime_release(activity, Lifecycle.Event.ON_DESTROY);
        }

        public void onActivityDestroyed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        @JvmStatic
        public static final void registerIn(@NotNull Activity activity) {
            Companion.registerIn(activity);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/ReportFragment$LifecycleCallbacks$Companion;", "", "()V", "registerIn", "", "activity", "Landroid/app/Activity;", "lifecycle-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final void registerIn(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                activity.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

