/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0006H\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0003J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/lifecycle/DispatchQueue;", "", "()V", "consumer", "Ljava/lang/Runnable;", "finished", "", "paused", "queue", "Ljava/util/Queue;", "canRun", "enqueue", "", "runnable", "finish", "maybeEnqueueConsumer", "pause", "resume", "runOrEnqueue", "lifecycle-runtime-ktx_release"})
public final class DispatchQueue {
    private boolean paused = true;
    private boolean finished;
    private final Queue<Runnable> queue = new ArrayDeque();
    private final Runnable consumer = new Runnable(this){
        final /* synthetic */ DispatchQueue this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            if (!DispatchQueue.access$canRun(this.this$0)) {
                return;
            }
            Runnable runnable = (Runnable)DispatchQueue.access$getQueue$p(this.this$0).poll();
            if (runnable == null) {
                return;
            }
            Runnable next = runnable;
            try {
                next.run();
            }
            finally {
                this.this$0.maybeEnqueueConsumer();
            }
        }
        {
            this.this$0 = dispatchQueue;
        }
    };

    @MainThread
    public final void pause() {
        this.paused = true;
    }

    @MainThread
    public final void resume() {
        boolean bl;
        if (!this.paused) {
            return;
        }
        boolean bl2 = bl = !this.finished;
        if (!bl) {
            boolean bl3 = false;
            String string = "Cannot resume a finished dispatcher";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.paused = false;
        this.maybeEnqueueConsumer();
    }

    @MainThread
    public final void finish() {
        this.finished = true;
        this.maybeEnqueueConsumer();
    }

    @MainThread
    public final void maybeEnqueueConsumer() {
        Collection collection = this.queue;
        if (!collection.isEmpty()) {
            Dispatchers.getMain().dispatch((CoroutineContext)EmptyCoroutineContext.INSTANCE, this.consumer);
        }
    }

    @MainThread
    private final boolean canRun() {
        return this.finished || !this.paused;
    }

    @AnyThread
    @SuppressLint(value={"WrongThread"})
    public final void runOrEnqueue(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        Dispatchers.getMain().getImmediate().dispatch((CoroutineContext)EmptyCoroutineContext.INSTANCE, new Runnable(this, runnable){
            final /* synthetic */ DispatchQueue this$0;
            final /* synthetic */ Runnable $runnable;

            public final void run() {
                DispatchQueue.access$enqueue(this.this$0, this.$runnable);
            }
            {
                this.this$0 = dispatchQueue;
                this.$runnable = runnable;
            }
        });
    }

    @MainThread
    private final void enqueue(Runnable runnable) {
        boolean bl = this.queue.offer(runnable);
        if (!bl) {
            boolean bl2 = false;
            String string = "cannot enqueue any more runnables";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.maybeEnqueueConsumer();
    }

    public static final /* synthetic */ void access$enqueue(DispatchQueue $this, Runnable runnable) {
        $this.enqueue(runnable);
    }

    public static final /* synthetic */ boolean access$canRun(DispatchQueue $this) {
        return $this.canRun();
    }

    public static final /* synthetic */ Queue access$getQueue$p(DispatchQueue $this) {
        return $this.queue;
    }
}

