/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import java.util.Map;

public abstract class LiveData<T> {
    final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    static final Object NOT_SET = new Object();
    private SafeIterableMap<Observer<? super T>, ObserverWrapper> mObservers = new SafeIterableMap();
    int mActiveCount = 0;
    private volatile Object mData;
    volatile Object mPendingData = NOT_SET;
    private int mVersion;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;
    private final Runnable mPostValueRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object newValue;
            Object object = LiveData.this.mDataLock;
            synchronized (object) {
                newValue = LiveData.this.mPendingData;
                LiveData.this.mPendingData = NOT_SET;
            }
            LiveData.this.setValue(newValue);
        }
    };

    public LiveData(T value) {
        this.mData = value;
        this.mVersion = 0;
    }

    public LiveData() {
        this.mData = NOT_SET;
        this.mVersion = -1;
    }

    private void considerNotify(ObserverWrapper observer) {
        if (!observer.mActive) {
            return;
        }
        if (!observer.shouldBeActive()) {
            observer.activeStateChanged(false);
            return;
        }
        if (observer.mLastVersion >= this.mVersion) {
            return;
        }
        observer.mLastVersion = this.mVersion;
        observer.mObserver.onChanged(this.mData);
    }

    void dispatchingValue(@Nullable ObserverWrapper initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            SafeIterableMap.IteratorWithAdditions iterator = this.mObservers.iteratorWithAdditions();
            while (iterator.hasNext()) {
                this.considerNotify((ObserverWrapper)((Map.Entry)iterator.next()).getValue());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @MainThread
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<? super T> observer) {
        LiveData.assertMainThread("observe");
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner, observer);
        ObserverWrapper existing = (ObserverWrapper)this.mObservers.putIfAbsent(observer, (Object)wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void observeForever(@NonNull Observer<? super T> observer) {
        LiveData.assertMainThread("observeForever");
        AlwaysActiveObserver wrapper = new AlwaysActiveObserver(observer);
        ObserverWrapper existing = (ObserverWrapper)this.mObservers.putIfAbsent(observer, (Object)wrapper);
        if (existing instanceof LifecycleBoundObserver) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void removeObserver(@NonNull Observer<? super T> observer) {
        LiveData.assertMainThread("removeObserver");
        ObserverWrapper removed = (ObserverWrapper)this.mObservers.remove(observer);
        if (removed == null) {
            return;
        }
        removed.detachObserver();
        removed.activeStateChanged(false);
    }

    @MainThread
    public void removeObservers(@NonNull LifecycleOwner owner) {
        LiveData.assertMainThread("removeObservers");
        for (Map.Entry entry : this.mObservers) {
            if (!((ObserverWrapper)entry.getValue()).isAttachedTo(owner)) continue;
            this.removeObserver((Observer)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postValue(T value) {
        boolean postTask;
        Object object = this.mDataLock;
        synchronized (object) {
            postTask = this.mPendingData == NOT_SET;
            this.mPendingData = value;
        }
        if (!postTask) {
            return;
        }
        ArchTaskExecutor.getInstance().postToMainThread(this.mPostValueRunnable);
    }

    @MainThread
    protected void setValue(T value) {
        LiveData.assertMainThread("setValue");
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasObservers() {
        return this.mObservers.size() > 0;
    }

    public boolean hasActiveObservers() {
        return this.mActiveCount > 0;
    }

    static void assertMainThread(String methodName) {
        if (!ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot invoke " + methodName + " on a background thread");
        }
    }

    private class AlwaysActiveObserver
    extends ObserverWrapper {
        AlwaysActiveObserver(Observer<? super T> observer) {
            super(observer);
        }

        @Override
        boolean shouldBeActive() {
            return true;
        }
    }

    private abstract class ObserverWrapper {
        final Observer<? super T> mObserver;
        boolean mActive;
        int mLastVersion = -1;

        ObserverWrapper(Observer<? super T> observer) {
            this.mObserver = observer;
        }

        abstract boolean shouldBeActive();

        boolean isAttachedTo(LifecycleOwner owner) {
            return false;
        }

        void detachObserver() {
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.mActive) {
                return;
            }
            this.mActive = newActive;
            boolean wasInactive = LiveData.this.mActiveCount == 0;
            LiveData.this.mActiveCount = LiveData.this.mActiveCount + (this.mActive ? 1 : -1);
            if (wasInactive && this.mActive) {
                LiveData.this.onActive();
            }
            if (LiveData.this.mActiveCount == 0 && !this.mActive) {
                LiveData.this.onInactive();
            }
            if (this.mActive) {
                LiveData.this.dispatchingValue(this);
            }
        }
    }

    class LifecycleBoundObserver
    extends ObserverWrapper
    implements LifecycleEventObserver {
        @NonNull
        final LifecycleOwner mOwner;

        LifecycleBoundObserver(LifecycleOwner owner, Observer<? super T> observer) {
            super(observer);
            this.mOwner = owner;
        }

        @Override
        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        }

        public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
            if (this.mOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                LiveData.this.removeObserver(this.mObserver);
                return;
            }
            this.activeStateChanged(this.shouldBeActive());
        }

        @Override
        boolean isAttachedTo(LifecycleOwner owner) {
            return this.mOwner == owner;
        }

        @Override
        void detachObserver() {
            this.mOwner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }
}

