/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.lifecycle.Elements_extKt;
import androidx.lifecycle.ErrorMessages;
import androidx.lifecycle.model.AdapterClass;
import androidx.lifecycle.model.EventMethod;
import androidx.lifecycle.model.EventMethodCall;
import androidx.lifecycle.model.InputModel;
import androidx.lifecycle.model.LifecycleObserverInfo;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u001a:\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002\u001a\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0012\u001a(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"flattenObservers", "", "Landroidx/lifecycle/model/LifecycleObserverInfo;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "world", "", "Ljavax/lang/model/element/TypeElement;", "mergeAndVerifyMethods", "Landroidx/lifecycle/model/EventMethod;", "type", "classMethods", "parentMethods", "needsSyntheticAccess", "", "eventMethod", "transformToOutput", "Landroidx/lifecycle/model/AdapterClass;", "Landroidx/lifecycle/model/InputModel;", "validateMethod", "lifecycle-compiler"})
public final class TransformationKt {
    /*
     * WARNING - void declaration
     */
    private static final List<EventMethod> mergeAndVerifyMethods(ProcessingEnvironment processingEnv, TypeElement type, List<EventMethod> classMethods, List<EventMethod> parentMethods) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = parentMethods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EventMethod eventMethod;
            Object v0;
            void parentMethod;
            block6: {
                EventMethod eventMethod2 = (EventMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = classMethods;
                for (Object t : iterable2) {
                    EventMethod eventMethod3 = (EventMethod)t;
                    boolean bl2 = false;
                    ExecutableElement method = eventMethod3.component1();
                    if (!processingEnv.getElementUtils().overrides(method, parentMethod.getMethod(), type)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            EventMethod overrideMethod = v0;
            if (overrideMethod != null) {
                if (!Intrinsics.areEqual((Object)overrideMethod.getOnLifecycleEvent(), (Object)parentMethod.getOnLifecycleEvent())) {
                    processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "overridden method must handle the same onState changes as original method", overrideMethod.getMethod());
                }
                eventMethod = overrideMethod;
            } else {
                eventMethod = parentMethod;
            }
            collection.add(eventMethod);
        }
        List updatedParentMethods = (List)destination$iv$iv;
        $this$map$iv = classMethods;
        collection = updatedParentMethods;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            EventMethod it = (EventMethod)element$iv$iv;
            boolean bl = false;
            if (updatedParentMethods.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<LifecycleObserverInfo> flattenObservers(@NotNull ProcessingEnvironment processingEnv, @NotNull Map<TypeElement, LifecycleObserverInfo> world) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter(world, (String)"world");
        Map flattened = new LinkedHashMap();
        Iterable $this$forEach$iv = world.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifecycleObserverInfo p0 = (LifecycleObserverInfo)element$iv;
            boolean bl = false;
            TransformationKt.flattenObservers$traverse(flattened, processingEnv, p0);
        }
        return CollectionsKt.toList((Iterable)flattened.values());
    }

    private static final boolean needsSyntheticAccess(TypeElement type, EventMethod eventMethod) {
        ExecutableElement executable = eventMethod.getMethod();
        return !Intrinsics.areEqual((Object)Elements_extKt.getPackageQName(type), (Object)eventMethod.packageName()) && (Elements_extKt.isPackagePrivate(executable) || Elements_extKt.isProtected(executable));
    }

    private static final boolean validateMethod(ProcessingEnvironment processingEnv, InputModel world, TypeElement type, EventMethod eventMethod) {
        if (!TransformationKt.needsSyntheticAccess(type, eventMethod)) {
            return true;
        }
        if (world.isRootType(eventMethod.getType())) {
            return true;
        }
        if (world.hasSyntheticAccessorFor(eventMethod)) {
            return true;
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, ErrorMessages.INSTANCE.failedToGenerateAdapter(type, eventMethod), type);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AdapterClass> transformToOutput(@NotNull ProcessingEnvironment processingEnv, @NotNull InputModel world) {
        Map adapterCalls;
        Set $this$forEach$iv;
        Collection collection;
        Map $this$mapTo$iv$iv;
        Map $this$map$iv;
        List<EventMethod> methods;
        TypeElement type;
        boolean bl;
        Object object;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        List<LifecycleObserverInfo> flatObservers = TransformationKt.flattenObservers(processingEnv, world.getObserversInfo());
        HashMultimap syntheticMethods = HashMultimap.create();
        Iterable iterable = flatObservers;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            object = (LifecycleObserverInfo)t;
            bl = false;
            type = ((LifecycleObserverInfo)object).component1();
            if (!world.isRootType(type)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            boolean bl2;
            block13: {
                object = (LifecycleObserverInfo)t;
                boolean bl22 = false;
                type = ((LifecycleObserverInfo)object).component1();
                methods = ((LifecycleObserverInfo)object).component2();
                Iterable $this$all$iv = methods;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        EventMethod eventMethod = (EventMethod)element$iv;
                        boolean bl3 = false;
                        if (TransformationKt.validateMethod(processingEnv, world, type, eventMethod)) continue;
                        bl2 = false;
                        break block13;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Iterator $this$filterTo$iv$iv2;
            Iterable $this$mapTo$iv$iv2;
            Object t = iterator.next();
            object = (LifecycleObserverInfo)t;
            collection = destination$iv$iv;
            bl = false;
            type = ((LifecycleObserverInfo)object).component1();
            methods = ((LifecycleObserverInfo)object).component2();
            Iterable $this$map$iv2 = methods;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void eventMethod;
                EventMethod eventMethod2 = (EventMethod)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(TransformationKt.needsSyntheticAccess(type, (EventMethod)eventMethod) ? new EventMethodCall((EventMethod)eventMethod, eventMethod.getType()) : new EventMethodCall((EventMethod)eventMethod, null, 2, null));
            }
            List calls = (List)destination$iv$iv2;
            Iterable $this$filter$iv2 = calls;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator bl3 = $this$filterTo$iv$iv2.iterator();
            while (bl3.hasNext()) {
                Object element$iv$iv = bl3.next();
                EventMethodCall it = (EventMethodCall)element$iv$iv;
                boolean bl5 = false;
                if (!(it.getSyntheticAccess() != null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Object element$iv;
                element$iv = $this$filterTo$iv$iv2.next();
                EventMethodCall eventMethod = (EventMethodCall)element$iv;
                boolean bl6 = false;
                syntheticMethods.put((Object)eventMethod.getMethod().getType(), (Object)eventMethod);
            }
            collection.add(TuplesKt.to((Object)type, (Object)calls));
        }
        $this$map$iv = adapterCalls = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            void $this$mapTo$iv$iv3;
            Set set;
            object = entry;
            collection = destination$iv$iv;
            bl = false;
            type = (TypeElement)object.getKey();
            List calls = (List)object.getValue();
            Set set2 = $this$forEach$iv = syntheticMethods.get((Object)type);
            if (set2 == null) {
                set = SetsKt.emptySet();
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"syntheticMethods.get(type) ?: emptySet()");
                set = $this$forEach$iv;
            }
            Set methods2 = set;
            Iterable $this$map$iv3 = methods2;
            boolean $i$f$map3 = false;
            Iterable eventMethod = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void eventMethod3;
                EventMethodCall bl5 = (EventMethodCall)item$iv$iv3;
                Collection collection3 = destination$iv$iv3;
                boolean bl7 = false;
                void v3 = eventMethod3;
                Intrinsics.checkNotNull((Object)v3);
                collection3.add(v3.getMethod().getMethod());
            }
            Set synthetic = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            collection.add(new AdapterClass(type, calls, synthetic));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void flattenObservers$traverse(Map<LifecycleObserverInfo, LifecycleObserverInfo> flattened, ProcessingEnvironment $processingEnv, LifecycleObserverInfo observer) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object element$iv2;
        if (flattened.containsKey(observer)) {
            return;
        }
        if (observer.getParents().isEmpty()) {
            flattened.put(observer, observer);
            return;
        }
        Iterable $this$forEach$iv = observer.getParents();
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            LifecycleObserverInfo p0 = (LifecycleObserverInfo)element$iv2;
            boolean bl = false;
            TransformationKt.flattenObservers$traverse(flattened, $processingEnv, p0);
        }
        Iterable $i$f$forEach22 = observer.getParents();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            LifecycleObserverInfo lifecycleObserverInfo = (LifecycleObserverInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(flattened.get(p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        List<EventMethod> initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List<EventMethod> accumulator$iv = initial$iv;
        for (Object element$iv3 : $this$fold$iv) {
            void parentObserver;
            Object item$iv$iv;
            item$iv$iv = (LifecycleObserverInfo)element$iv3;
            List<EventMethod> list = accumulator$iv;
            boolean bl = false;
            TypeElement typeElement = observer.getType();
            void v1 = parentObserver;
            Intrinsics.checkNotNull((Object)v1);
            accumulator$iv = TransformationKt.mergeAndVerifyMethods($processingEnv, typeElement, v1.getMethods(), list);
        }
        List<EventMethod> methods = accumulator$iv;
        flattened.put(observer, new LifecycleObserverInfo(observer.getType(), TransformationKt.mergeAndVerifyMethods($processingEnv, observer.getType(), observer.getMethods(), methods), null, 4, null));
    }
}

