/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import android.util.Log;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.databinding.DataBinderMapper;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.ViewDataBinding;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MergedDataBinderMapper
extends DataBinderMapper {
    private static final String TAG = "MergedDataBinderMapper";
    private Set<Class<? extends DataBinderMapper>> mExistingMappers = new HashSet<Class<? extends DataBinderMapper>>();
    private List<DataBinderMapper> mMappers = new CopyOnWriteArrayList<DataBinderMapper>();
    private List<String> mFeatureBindingMappers = new CopyOnWriteArrayList<String>();

    public void addMapper(DataBinderMapper mapper) {
        Class<?> mapperClass = mapper.getClass();
        if (this.mExistingMappers.add(mapperClass)) {
            this.mMappers.add(mapper);
            List<DataBinderMapper> dependencies = mapper.collectDependencies();
            for (DataBinderMapper dependency : dependencies) {
                this.addMapper(dependency);
            }
        }
    }

    protected void addMapper(String featureMapper) {
        this.mFeatureBindingMappers.add(featureMapper + ".DataBinderMapperImpl");
    }

    @Override
    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View view, int layoutId) {
        for (DataBinderMapper mapper : this.mMappers) {
            ViewDataBinding result = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getDataBinder(bindingComponent, view, layoutId);
        }
        return null;
    }

    @Override
    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View[] view, int layoutId) {
        for (DataBinderMapper mapper : this.mMappers) {
            ViewDataBinding result = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getDataBinder(bindingComponent, view, layoutId);
        }
        return null;
    }

    @Override
    public int getLayoutId(String tag) {
        for (DataBinderMapper mapper : this.mMappers) {
            int result = mapper.getLayoutId(tag);
            if (result == 0) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getLayoutId(tag);
        }
        return 0;
    }

    @Override
    public String convertBrIdToString(int id2) {
        for (DataBinderMapper mapper : this.mMappers) {
            String result = mapper.convertBrIdToString(id2);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.convertBrIdToString(id2);
        }
        return null;
    }

    private boolean loadFeatures() {
        boolean found = false;
        for (String mapper : this.mFeatureBindingMappers) {
            try {
                Class<?> aClass = Class.forName(mapper);
                if (!DataBinderMapper.class.isAssignableFrom(aClass)) continue;
                this.addMapper((DataBinderMapper)aClass.newInstance());
                this.mFeatureBindingMappers.remove(mapper);
                found = true;
            }
            catch (ClassNotFoundException aClass) {
            }
            catch (IllegalAccessException exception) {
                Log.e((String)TAG, (String)("unable to add feature mapper for " + mapper), (Throwable)exception);
            }
            catch (InstantiationException exception) {
                Log.e((String)TAG, (String)("unable to add feature mapper for " + mapper), (Throwable)exception);
            }
        }
        return found;
    }
}

