/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.databinding.BaseObservable;
import androidx.databinding.CallbackRegistry;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.Observable;
import androidx.databinding.ObservableList;
import androidx.databinding.ObservableMap;
import androidx.databinding.OnRebindCallback;
import androidx.databinding.library.R;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;

public abstract class ViewDataBinding
extends BaseObservable {
    static int SDK_INT = Build.VERSION.SDK_INT;
    private static final int REBIND = 1;
    private static final int HALTED = 2;
    private static final int REBOUND = 3;
    public static final String BINDING_TAG_PREFIX = "binding_";
    private static final int BINDING_NUMBER_START = "binding_".length();
    private static final boolean USE_CHOREOGRAPHER = SDK_INT >= 16;
    private static final CreateWeakListener CREATE_PROPERTY_LISTENER = new CreateWeakListener(){

        @Override
        public WeakListener create(ViewDataBinding viewDataBinding, int localFieldId) {
            return new WeakPropertyListener(viewDataBinding, localFieldId).getListener();
        }
    };
    private static final CreateWeakListener CREATE_LIST_LISTENER = new CreateWeakListener(){

        @Override
        public WeakListener create(ViewDataBinding viewDataBinding, int localFieldId) {
            return new WeakListListener(viewDataBinding, localFieldId).getListener();
        }
    };
    private static final CreateWeakListener CREATE_MAP_LISTENER = new CreateWeakListener(){

        @Override
        public WeakListener create(ViewDataBinding viewDataBinding, int localFieldId) {
            return new WeakMapListener(viewDataBinding, localFieldId).getListener();
        }
    };
    private static final CreateWeakListener CREATE_LIVE_DATA_LISTENER = new CreateWeakListener(){

        @Override
        public WeakListener create(ViewDataBinding viewDataBinding, int localFieldId) {
            return new LiveDataListener(viewDataBinding, localFieldId).getListener();
        }
    };
    private static final CallbackRegistry.NotifierCallback<OnRebindCallback, ViewDataBinding, Void> REBIND_NOTIFIER = new CallbackRegistry.NotifierCallback<OnRebindCallback, ViewDataBinding, Void>(){

        public void onNotifyCallback(OnRebindCallback callback, ViewDataBinding sender, int mode, Void arg2) {
            switch (mode) {
                case 1: {
                    if (callback.onPreBind(sender)) break;
                    sender.mRebindHalted = true;
                    break;
                }
                case 2: {
                    callback.onCanceled(sender);
                    break;
                }
                case 3: {
                    callback.onBound(sender);
                }
            }
        }
    };
    private static final ReferenceQueue<ViewDataBinding> sReferenceQueue = new ReferenceQueue();
    private static final View.OnAttachStateChangeListener ROOT_REATTACHED_LISTENER = Build.VERSION.SDK_INT < 19 ? null : new View.OnAttachStateChangeListener(){

        @TargetApi(value=19)
        public void onViewAttachedToWindow(View v) {
            ViewDataBinding binding = ViewDataBinding.getBinding(v);
            binding.mRebindRunnable.run();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewDetachedFromWindow(View v) {
        }
    };
    private final Runnable mRebindRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            7 var1_1 = this;
            synchronized (var1_1) {
                ViewDataBinding.this.mPendingRebind = false;
            }
            ViewDataBinding.processReferenceQueue();
            if (Build.VERSION.SDK_INT >= 19 && !ViewDataBinding.this.mRoot.isAttachedToWindow()) {
                ViewDataBinding.this.mRoot.removeOnAttachStateChangeListener(ROOT_REATTACHED_LISTENER);
                ViewDataBinding.this.mRoot.addOnAttachStateChangeListener(ROOT_REATTACHED_LISTENER);
                return;
            }
            ViewDataBinding.this.executePendingBindings();
        }
    };
    private boolean mPendingRebind = false;
    private boolean mRebindHalted = false;
    private WeakListener[] mLocalFieldObservers;
    private final View mRoot;
    private CallbackRegistry<OnRebindCallback, ViewDataBinding, Void> mRebindCallbacks;
    private boolean mIsExecutingPendingBindings;
    private Choreographer mChoreographer;
    private final Choreographer.FrameCallback mFrameCallback;
    private Handler mUIThreadHandler;
    protected final DataBindingComponent mBindingComponent;
    private ViewDataBinding mContainingBinding;
    private LifecycleOwner mLifecycleOwner;
    private OnStartListener mOnStartListener;
    private boolean mInLiveDataRegisterObserver;

    protected ViewDataBinding(DataBindingComponent bindingComponent, View root, int localFieldCount) {
        this.mBindingComponent = bindingComponent;
        this.mLocalFieldObservers = new WeakListener[localFieldCount];
        this.mRoot = root;
        if (Looper.myLooper() == null) {
            throw new IllegalStateException("DataBinding must be created in view's UI Thread");
        }
        if (USE_CHOREOGRAPHER) {
            this.mChoreographer = Choreographer.getInstance();
            this.mFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    ViewDataBinding.this.mRebindRunnable.run();
                }
            };
        } else {
            this.mFrameCallback = null;
            this.mUIThreadHandler = new Handler(Looper.myLooper());
        }
    }

    protected void setRootTag(View view) {
        view.setTag(R.id.dataBinding, (Object)this);
    }

    protected void setRootTag(View[] views) {
        for (View view : views) {
            view.setTag(R.id.dataBinding, (Object)this);
        }
    }

    public static int getBuildSdkInt() {
        return SDK_INT;
    }

    protected abstract boolean onFieldChange(int var1, Object var2, int var3);

    public abstract boolean setVariable(int var1, @Nullable Object var2);

    @MainThread
    public void setLifecycleOwner(@Nullable LifecycleOwner lifecycleOwner) {
        if (this.mLifecycleOwner == lifecycleOwner) {
            return;
        }
        if (this.mLifecycleOwner != null) {
            this.mLifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this.mOnStartListener);
        }
        this.mLifecycleOwner = lifecycleOwner;
        if (lifecycleOwner != null) {
            if (this.mOnStartListener == null) {
                this.mOnStartListener = new OnStartListener();
            }
            lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this.mOnStartListener);
        }
        for (WeakListener weakListener : this.mLocalFieldObservers) {
            if (weakListener == null) continue;
            weakListener.setLifecycleOwner(lifecycleOwner);
        }
    }

    public void addOnRebindCallback(@NonNull OnRebindCallback listener) {
        if (this.mRebindCallbacks == null) {
            this.mRebindCallbacks = new CallbackRegistry(REBIND_NOTIFIER);
        }
        this.mRebindCallbacks.add((Object)listener);
    }

    public void removeOnRebindCallback(@NonNull OnRebindCallback listener) {
        if (this.mRebindCallbacks != null) {
            this.mRebindCallbacks.remove((Object)listener);
        }
    }

    public void executePendingBindings() {
        if (this.mContainingBinding == null) {
            this.executeBindingsInternal();
        } else {
            this.mContainingBinding.executePendingBindings();
        }
    }

    private void executeBindingsInternal() {
        if (this.mIsExecutingPendingBindings) {
            this.requestRebind();
            return;
        }
        if (!this.hasPendingBindings()) {
            return;
        }
        this.mIsExecutingPendingBindings = true;
        this.mRebindHalted = false;
        if (this.mRebindCallbacks != null) {
            this.mRebindCallbacks.notifyCallbacks((Object)this, 1, null);
            if (this.mRebindHalted) {
                this.mRebindCallbacks.notifyCallbacks((Object)this, 2, null);
            }
        }
        if (!this.mRebindHalted) {
            this.executeBindings();
            if (this.mRebindCallbacks != null) {
                this.mRebindCallbacks.notifyCallbacks((Object)this, 3, null);
            }
        }
        this.mIsExecutingPendingBindings = false;
    }

    protected static void executeBindingsOn(ViewDataBinding other) {
        other.executeBindingsInternal();
    }

    void forceExecuteBindings() {
        this.executeBindings();
    }

    protected abstract void executeBindings();

    public abstract void invalidateAll();

    public abstract boolean hasPendingBindings();

    public void unbind() {
        for (WeakListener weakListener : this.mLocalFieldObservers) {
            if (weakListener == null) continue;
            weakListener.unregister();
        }
    }

    static ViewDataBinding getBinding(View v) {
        if (v != null) {
            return (ViewDataBinding)v.getTag(R.id.dataBinding);
        }
        return null;
    }

    @NonNull
    public View getRoot() {
        return this.mRoot;
    }

    private void handleFieldChange(int mLocalFieldId, Object object, int fieldId) {
        if (this.mInLiveDataRegisterObserver) {
            return;
        }
        boolean result = this.onFieldChange(mLocalFieldId, object, fieldId);
        if (result) {
            this.requestRebind();
        }
    }

    protected boolean unregisterFrom(int localFieldId) {
        WeakListener listener = this.mLocalFieldObservers[localFieldId];
        if (listener != null) {
            return listener.unregister();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestRebind() {
        if (this.mContainingBinding != null) {
            this.mContainingBinding.requestRebind();
        } else {
            Lifecycle.State state;
            ViewDataBinding viewDataBinding = this;
            synchronized (viewDataBinding) {
                if (this.mPendingRebind) {
                    return;
                }
                this.mPendingRebind = true;
            }
            if (this.mLifecycleOwner != null && !(state = this.mLifecycleOwner.getLifecycle().getCurrentState()).isAtLeast(Lifecycle.State.STARTED)) {
                return;
            }
            if (USE_CHOREOGRAPHER) {
                this.mChoreographer.postFrameCallback(this.mFrameCallback);
            } else {
                this.mUIThreadHandler.post(this.mRebindRunnable);
            }
        }
    }

    protected Object getObservedField(int localFieldId) {
        WeakListener listener = this.mLocalFieldObservers[localFieldId];
        if (listener == null) {
            return null;
        }
        return listener.getTarget();
    }

    private boolean updateRegistration(int localFieldId, Object observable, CreateWeakListener listenerCreator) {
        if (observable == null) {
            return this.unregisterFrom(localFieldId);
        }
        WeakListener listener = this.mLocalFieldObservers[localFieldId];
        if (listener == null) {
            this.registerTo(localFieldId, observable, listenerCreator);
            return true;
        }
        if (listener.getTarget() == observable) {
            return false;
        }
        this.unregisterFrom(localFieldId);
        this.registerTo(localFieldId, observable, listenerCreator);
        return true;
    }

    protected boolean updateRegistration(int localFieldId, Observable observable) {
        return this.updateRegistration(localFieldId, observable, CREATE_PROPERTY_LISTENER);
    }

    protected boolean updateRegistration(int localFieldId, ObservableList observable) {
        return this.updateRegistration(localFieldId, observable, CREATE_LIST_LISTENER);
    }

    protected boolean updateRegistration(int localFieldId, ObservableMap observable) {
        return this.updateRegistration(localFieldId, observable, CREATE_MAP_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLiveDataRegistration(int localFieldId, LiveData<?> observable) {
        this.mInLiveDataRegisterObserver = true;
        try {
            boolean bl = this.updateRegistration(localFieldId, observable, CREATE_LIVE_DATA_LISTENER);
            return bl;
        }
        finally {
            this.mInLiveDataRegisterObserver = false;
        }
    }

    protected void ensureBindingComponentIsNotNull(Class<?> oneExample) {
        if (this.mBindingComponent == null) {
            String errorMessage = "Required DataBindingComponent is null in class " + this.getClass().getSimpleName() + ". A BindingAdapter in " + oneExample.getCanonicalName() + " is not static and requires an object to use, retrieved from the DataBindingComponent. If you don't use an inflation method taking a DataBindingComponent, use DataBindingUtil.setDefaultComponent or make all BindingAdapter methods static.";
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void registerTo(int localFieldId, Object observable, CreateWeakListener listenerCreator) {
        if (observable == null) {
            return;
        }
        WeakListener listener = this.mLocalFieldObservers[localFieldId];
        if (listener == null) {
            this.mLocalFieldObservers[localFieldId] = listener = listenerCreator.create(this, localFieldId);
            if (this.mLifecycleOwner != null) {
                listener.setLifecycleOwner(this.mLifecycleOwner);
            }
        }
        listener.setTarget(observable);
    }

    protected static ViewDataBinding bind(DataBindingComponent bindingComponent, View view, int layoutId) {
        return DataBindingUtil.bind(bindingComponent, view, layoutId);
    }

    protected static Object[] mapBindings(DataBindingComponent bindingComponent, View root, int numBindings, IncludedLayouts includes, SparseIntArray viewsWithIds) {
        Object[] bindings = new Object[numBindings];
        ViewDataBinding.mapBindings(bindingComponent, root, bindings, includes, viewsWithIds, true);
        return bindings;
    }

    protected static boolean parse(String str, boolean fallback) {
        if (str == null) {
            return fallback;
        }
        return Boolean.parseBoolean(str);
    }

    protected static byte parse(String str, byte fallback) {
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static short parse(String str, short fallback) {
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static int parse(String str, int fallback) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static long parse(String str, long fallback) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static float parse(String str, float fallback) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static double parse(String str, double fallback) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    protected static char parse(String str, char fallback) {
        if (str == null || str.isEmpty()) {
            return fallback;
        }
        return str.charAt(0);
    }

    protected static int getColorFromResource(View view, int resourceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return view.getContext().getColor(resourceId);
        }
        return view.getResources().getColor(resourceId);
    }

    protected static ColorStateList getColorStateListFromResource(View view, int resourceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return view.getContext().getColorStateList(resourceId);
        }
        return view.getResources().getColorStateList(resourceId);
    }

    protected static Drawable getDrawableFromResource(View view, int resourceId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return view.getContext().getDrawable(resourceId);
        }
        return view.getResources().getDrawable(resourceId);
    }

    protected static <T> T getFromArray(T[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return null;
        }
        return arr[index];
    }

    protected static <T> void setTo(T[] arr, int index, T value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static boolean getFromArray(boolean[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return false;
        }
        return arr[index];
    }

    protected static void setTo(boolean[] arr, int index, boolean value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static byte getFromArray(byte[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0;
        }
        return arr[index];
    }

    protected static void setTo(byte[] arr, int index, byte value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static short getFromArray(short[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0;
        }
        return arr[index];
    }

    protected static void setTo(short[] arr, int index, short value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static char getFromArray(char[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return '\u0000';
        }
        return arr[index];
    }

    protected static void setTo(char[] arr, int index, char value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static int getFromArray(int[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0;
        }
        return arr[index];
    }

    protected static void setTo(int[] arr, int index, int value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static long getFromArray(long[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0L;
        }
        return arr[index];
    }

    protected static void setTo(long[] arr, int index, long value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static float getFromArray(float[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0.0f;
        }
        return arr[index];
    }

    protected static void setTo(float[] arr, int index, float value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static double getFromArray(double[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return 0.0;
        }
        return arr[index];
    }

    protected static void setTo(double[] arr, int index, double value) {
        if (arr == null || index < 0 || index >= arr.length) {
            return;
        }
        arr[index] = value;
    }

    protected static <T> T getFromList(List<T> list, int index) {
        if (list == null || index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    protected static <T> void setTo(List<T> list, int index, T value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.set(index, value);
    }

    protected static <T> T getFromList(SparseArray<T> list, int index) {
        if (list == null || index < 0) {
            return null;
        }
        return (T)list.get(index);
    }

    protected static <T> void setTo(SparseArray<T> list, int index, T value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put(index, value);
    }

    @TargetApi(value=16)
    protected static <T> T getFromList(android.util.LongSparseArray<T> list, int index) {
        if (list == null || index < 0) {
            return null;
        }
        return (T)list.get((long)index);
    }

    @TargetApi(value=16)
    protected static <T> void setTo(android.util.LongSparseArray<T> list, int index, T value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put((long)index, value);
    }

    protected static <T> T getFromList(LongSparseArray<T> list, int index) {
        if (list == null || index < 0) {
            return null;
        }
        return (T)list.get((long)index);
    }

    protected static <T> void setTo(LongSparseArray<T> list, int index, T value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put((long)index, value);
    }

    protected static boolean getFromList(SparseBooleanArray list, int index) {
        if (list == null || index < 0) {
            return false;
        }
        return list.get(index);
    }

    protected static void setTo(SparseBooleanArray list, int index, boolean value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put(index, value);
    }

    protected static int getFromList(SparseIntArray list, int index) {
        if (list == null || index < 0) {
            return 0;
        }
        return list.get(index);
    }

    protected static void setTo(SparseIntArray list, int index, int value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put(index, value);
    }

    @TargetApi(value=18)
    protected static long getFromList(SparseLongArray list, int index) {
        if (list == null || index < 0) {
            return 0L;
        }
        return list.get(index);
    }

    @TargetApi(value=18)
    protected static void setTo(SparseLongArray list, int index, long value) {
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        list.put(index, value);
    }

    protected static <K, T> T getFrom(Map<K, T> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    protected static <K, T> void setTo(Map<K, T> map, K key, T value) {
        if (map == null) {
            return;
        }
        map.put(key, value);
    }

    protected static void setBindingInverseListener(ViewDataBinding binder, InverseBindingListener oldListener, PropertyChangedInverseListener listener) {
        if (oldListener != listener) {
            if (oldListener != null) {
                binder.removeOnPropertyChangedCallback((PropertyChangedInverseListener)oldListener);
            }
            if (listener != null) {
                binder.addOnPropertyChangedCallback(listener);
            }
        }
    }

    protected static int safeUnbox(Integer boxed) {
        return boxed == null ? 0 : boxed;
    }

    protected static long safeUnbox(Long boxed) {
        return boxed == null ? 0L : boxed;
    }

    protected static short safeUnbox(Short boxed) {
        return boxed == null ? (short)0 : boxed;
    }

    protected static byte safeUnbox(Byte boxed) {
        return boxed == null ? (byte)0 : boxed;
    }

    protected static char safeUnbox(Character boxed) {
        return boxed == null ? (char)'\u0000' : boxed.charValue();
    }

    protected static double safeUnbox(Double boxed) {
        return boxed == null ? 0.0 : boxed;
    }

    protected static float safeUnbox(Float boxed) {
        return boxed == null ? 0.0f : boxed.floatValue();
    }

    protected static boolean safeUnbox(Boolean boxed) {
        return boxed == null ? false : boxed;
    }

    protected void setContainedBinding(ViewDataBinding included) {
        if (included != null) {
            included.mContainingBinding = this;
        }
    }

    protected static Object[] mapBindings(DataBindingComponent bindingComponent, View[] roots, int numBindings, IncludedLayouts includes, SparseIntArray viewsWithIds) {
        Object[] bindings = new Object[numBindings];
        for (int i = 0; i < roots.length; ++i) {
            ViewDataBinding.mapBindings(bindingComponent, roots[i], bindings, includes, viewsWithIds, true);
        }
        return bindings;
    }

    private static void mapBindings(DataBindingComponent bindingComponent, View view, Object[] bindings, IncludedLayouts includes, SparseIntArray viewsWithIds, boolean isRoot) {
        int id2;
        int indexInIncludes;
        int index;
        ViewDataBinding existingBinding = ViewDataBinding.getBinding(view);
        if (existingBinding != null) {
            return;
        }
        Object objTag = view.getTag();
        String tag = objTag instanceof String ? (String)objTag : null;
        boolean isBound = false;
        if (isRoot && tag != null && tag.startsWith("layout")) {
            int underscoreIndex = tag.lastIndexOf(95);
            if (underscoreIndex > 0 && ViewDataBinding.isNumeric(tag, underscoreIndex + 1)) {
                index = ViewDataBinding.parseTagInt(tag, underscoreIndex + 1);
                if (bindings[index] == null) {
                    bindings[index] = view;
                }
                indexInIncludes = includes == null ? -1 : index;
                isBound = true;
            } else {
                indexInIncludes = -1;
            }
        } else if (tag != null && tag.startsWith(BINDING_TAG_PREFIX)) {
            int tagIndex = ViewDataBinding.parseTagInt(tag, BINDING_NUMBER_START);
            if (bindings[tagIndex] == null) {
                bindings[tagIndex] = view;
            }
            isBound = true;
            indexInIncludes = includes == null ? -1 : tagIndex;
        } else {
            indexInIncludes = -1;
        }
        if (!isBound && (id2 = view.getId()) > 0 && viewsWithIds != null && (index = viewsWithIds.get(id2, -1)) >= 0 && bindings[index] == null) {
            bindings[index] = view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            int minInclude = 0;
            for (int i = 0; i < count; ++i) {
                int includeIndex;
                String childTag;
                View child = viewGroup.getChildAt(i);
                boolean isInclude = false;
                if (indexInIncludes >= 0 && child.getTag() instanceof String && (childTag = (String)child.getTag()).endsWith("_0") && childTag.startsWith("layout") && childTag.indexOf(47) > 0 && (includeIndex = ViewDataBinding.findIncludeIndex(childTag, minInclude, includes, indexInIncludes)) >= 0) {
                    isInclude = true;
                    minInclude = includeIndex + 1;
                    int index2 = includes.indexes[indexInIncludes][includeIndex];
                    int layoutId = includes.layoutIds[indexInIncludes][includeIndex];
                    int lastMatchingIndex = ViewDataBinding.findLastMatching(viewGroup, i);
                    if (lastMatchingIndex == i) {
                        bindings[index2] = DataBindingUtil.bind(bindingComponent, child, layoutId);
                    } else {
                        int includeCount = lastMatchingIndex - i + 1;
                        View[] included = new View[includeCount];
                        for (int j = 0; j < includeCount; ++j) {
                            included[j] = viewGroup.getChildAt(i + j);
                        }
                        bindings[index2] = DataBindingUtil.bind(bindingComponent, included, layoutId);
                        i += includeCount - 1;
                    }
                }
                if (isInclude) continue;
                ViewDataBinding.mapBindings(bindingComponent, child, bindings, includes, viewsWithIds, false);
            }
        }
    }

    private static int findIncludeIndex(String tag, int minInclude, IncludedLayouts included, int includedIndex) {
        int slashIndex = tag.indexOf(47);
        CharSequence layoutName = tag.subSequence(slashIndex + 1, tag.length() - 2);
        String[] layouts = included.layouts[includedIndex];
        int length = layouts.length;
        for (int i = minInclude; i < length; ++i) {
            String layout = layouts[i];
            if (!TextUtils.equals((CharSequence)layoutName, (CharSequence)layout)) continue;
            return i;
        }
        return -1;
    }

    private static int findLastMatching(ViewGroup viewGroup, int firstIncludedIndex) {
        View firstView = viewGroup.getChildAt(firstIncludedIndex);
        String firstViewTag = (String)firstView.getTag();
        String tagBase = firstViewTag.substring(0, firstViewTag.length() - 1);
        int tagSequenceIndex = tagBase.length();
        int count = viewGroup.getChildCount();
        int max = firstIncludedIndex;
        for (int i = firstIncludedIndex + 1; i < count; ++i) {
            String tag;
            View view = viewGroup.getChildAt(i);
            Object objTag = view.getTag();
            String string = tag = objTag instanceof String ? (String)view.getTag() : null;
            if (tag == null || !tag.startsWith(tagBase)) continue;
            if (tag.length() == firstViewTag.length() && tag.charAt(tag.length() - 1) == '0') {
                return max;
            }
            if (!ViewDataBinding.isNumeric(tag, tagSequenceIndex)) continue;
            max = i;
        }
        return max;
    }

    private static boolean isNumeric(String tag, int startIndex) {
        int length = tag.length();
        if (length == startIndex) {
            return false;
        }
        for (int i = startIndex; i < length; ++i) {
            if (Character.isDigit(tag.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int parseTagInt(String str, int startIndex) {
        int end = str.length();
        int val = 0;
        for (int i = startIndex; i < end; ++i) {
            val *= 10;
            char c = str.charAt(i);
            val += c - 48;
        }
        return val;
    }

    private static void processReferenceQueue() {
        Reference<ViewDataBinding> ref;
        while ((ref = sReferenceQueue.poll()) != null) {
            if (!(ref instanceof WeakListener)) continue;
            WeakListener listener = (WeakListener)ref;
            listener.unregister();
        }
    }

    public class OnStartListener
    implements LifecycleObserver {
        private OnStartListener() {
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        public void onStart() {
            ViewDataBinding.this.executePendingBindings();
        }
    }

    protected static abstract class PropertyChangedInverseListener
    extends Observable.OnPropertyChangedCallback
    implements InverseBindingListener {
        final int mPropertyId;

        public PropertyChangedInverseListener(int propertyId) {
            this.mPropertyId = propertyId;
        }

        public void onPropertyChanged(Observable sender, int propertyId) {
            if (propertyId == this.mPropertyId || propertyId == 0) {
                this.onChange();
            }
        }
    }

    protected static class IncludedLayouts {
        public final String[][] layouts;
        public final int[][] indexes;
        public final int[][] layoutIds;

        public IncludedLayouts(int bindingCount) {
            this.layouts = new String[bindingCount][];
            this.indexes = new int[bindingCount][];
            this.layoutIds = new int[bindingCount][];
        }

        public void setIncludes(int index, String[] layouts, int[] indexes, int[] layoutIds) {
            this.layouts[index] = layouts;
            this.indexes[index] = indexes;
            this.layoutIds[index] = layoutIds;
        }
    }

    private static interface CreateWeakListener {
        public WeakListener create(ViewDataBinding var1, int var2);
    }

    private static class LiveDataListener
    implements Observer,
    ObservableReference<LiveData<?>> {
        final WeakListener<LiveData<?>> mListener;
        LifecycleOwner mLifecycleOwner;

        public LiveDataListener(ViewDataBinding binder, int localFieldId) {
            this.mListener = new WeakListener(binder, localFieldId, this);
        }

        @Override
        public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
            LifecycleOwner owner = lifecycleOwner;
            LiveData<?> liveData = this.mListener.getTarget();
            if (liveData != null) {
                if (this.mLifecycleOwner != null) {
                    liveData.removeObserver((Observer)this);
                }
                if (lifecycleOwner != null) {
                    liveData.observe(owner, (Observer)this);
                }
            }
            this.mLifecycleOwner = owner;
        }

        @Override
        public WeakListener<LiveData<?>> getListener() {
            return this.mListener;
        }

        @Override
        public void addListener(LiveData<?> target) {
            if (this.mLifecycleOwner != null) {
                target.observe(this.mLifecycleOwner, (Observer)this);
            }
        }

        @Override
        public void removeListener(LiveData<?> target) {
            target.removeObserver((Observer)this);
        }

        public void onChanged(@Nullable Object o) {
            ViewDataBinding binder = this.mListener.getBinder();
            binder.handleFieldChange(this.mListener.mLocalFieldId, this.mListener.getTarget(), 0);
        }
    }

    private static class WeakMapListener
    extends ObservableMap.OnMapChangedCallback
    implements ObservableReference<ObservableMap> {
        final WeakListener<ObservableMap> mListener;

        public WeakMapListener(ViewDataBinding binder, int localFieldId) {
            this.mListener = new WeakListener<ObservableMap>(binder, localFieldId, this);
        }

        @Override
        public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        }

        @Override
        public WeakListener<ObservableMap> getListener() {
            return this.mListener;
        }

        @Override
        public void addListener(ObservableMap target) {
            target.addOnMapChangedCallback((ObservableMap.OnMapChangedCallback)this);
        }

        @Override
        public void removeListener(ObservableMap target) {
            target.removeOnMapChangedCallback((ObservableMap.OnMapChangedCallback)this);
        }

        public void onMapChanged(ObservableMap sender, Object key) {
            ViewDataBinding binder = this.mListener.getBinder();
            if (binder == null || sender != this.mListener.getTarget()) {
                return;
            }
            binder.handleFieldChange(this.mListener.mLocalFieldId, sender, 0);
        }
    }

    private static class WeakListListener
    extends ObservableList.OnListChangedCallback
    implements ObservableReference<ObservableList> {
        final WeakListener<ObservableList> mListener;

        public WeakListListener(ViewDataBinding binder, int localFieldId) {
            this.mListener = new WeakListener<ObservableList>(binder, localFieldId, this);
        }

        @Override
        public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        }

        @Override
        public WeakListener<ObservableList> getListener() {
            return this.mListener;
        }

        @Override
        public void addListener(ObservableList target) {
            target.addOnListChangedCallback((ObservableList.OnListChangedCallback)this);
        }

        @Override
        public void removeListener(ObservableList target) {
            target.removeOnListChangedCallback((ObservableList.OnListChangedCallback)this);
        }

        public void onChanged(ObservableList sender) {
            ViewDataBinding binder = this.mListener.getBinder();
            if (binder == null) {
                return;
            }
            ObservableList target = this.mListener.getTarget();
            if (target != sender) {
                return;
            }
            binder.handleFieldChange(this.mListener.mLocalFieldId, target, 0);
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }
    }

    private static class WeakPropertyListener
    extends Observable.OnPropertyChangedCallback
    implements ObservableReference<Observable> {
        final WeakListener<Observable> mListener;

        public WeakPropertyListener(ViewDataBinding binder, int localFieldId) {
            this.mListener = new WeakListener<Observable>(binder, localFieldId, this);
        }

        @Override
        public WeakListener<Observable> getListener() {
            return this.mListener;
        }

        @Override
        public void addListener(Observable target) {
            target.addOnPropertyChangedCallback((Observable.OnPropertyChangedCallback)this);
        }

        @Override
        public void removeListener(Observable target) {
            target.removeOnPropertyChangedCallback((Observable.OnPropertyChangedCallback)this);
        }

        @Override
        public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        }

        public void onPropertyChanged(Observable sender, int propertyId) {
            ViewDataBinding binder = this.mListener.getBinder();
            if (binder == null) {
                return;
            }
            Observable obj = this.mListener.getTarget();
            if (obj != sender) {
                return;
            }
            binder.handleFieldChange(this.mListener.mLocalFieldId, sender, propertyId);
        }
    }

    private static class WeakListener<T>
    extends WeakReference<ViewDataBinding> {
        private final ObservableReference<T> mObservable;
        protected final int mLocalFieldId;
        private T mTarget;

        public WeakListener(ViewDataBinding binder, int localFieldId, ObservableReference<T> observable) {
            super(binder, sReferenceQueue);
            this.mLocalFieldId = localFieldId;
            this.mObservable = observable;
        }

        public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
            this.mObservable.setLifecycleOwner(lifecycleOwner);
        }

        public void setTarget(T object) {
            this.unregister();
            this.mTarget = object;
            if (this.mTarget != null) {
                this.mObservable.addListener(this.mTarget);
            }
        }

        public boolean unregister() {
            boolean unregistered = false;
            if (this.mTarget != null) {
                this.mObservable.removeListener(this.mTarget);
                unregistered = true;
            }
            this.mTarget = null;
            return unregistered;
        }

        public T getTarget() {
            return this.mTarget;
        }

        protected ViewDataBinding getBinder() {
            ViewDataBinding binder = (ViewDataBinding)this.get();
            if (binder == null) {
                this.unregister();
            }
            return binder;
        }
    }

    private static interface ObservableReference<T> {
        public WeakListener<T> getListener();

        public void addListener(T var1);

        public void removeListener(T var1);

        public void setLifecycleOwner(LifecycleOwner var1);
    }
}

