/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.InverseBinding;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.MethodBaseExpr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.TwoWayListenerExpr;
import android.databinding.tool.expr.ViewFieldExpr;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.BrNameUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import android.databinding.tool.writer.KCode;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldAccessExpr
extends MethodBaseExpr {
    String mBrName;
    Callable mGetter;
    boolean mIsListener;
    boolean mIsViewAttributeAccess;
    boolean mIsMap;
    FieldAccessExpr[] mDependencies;
    HashSet<FieldAccessExpr> mTransitiveDependencies = new HashSet();
    HashSet<FieldAccessExpr> mDependents = new HashSet();

    FieldAccessExpr(Expr parent, String name) {
        super(parent, name);
        this.mName = name;
    }

    public Callable getGetter() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        return this.mGetter;
    }

    @Override
    protected void resetResolvedType() {
        super.resetResolvedType();
        this.mGetter = null;
    }

    @Override
    public String getInvertibleError() {
        if (this.getGetter() == null) {
            return "Listeners do not support two-way binding";
        }
        if (this.mGetter.setterName == null && this.mGetter.type == Callable.Type.METHOD) {
            return "Two-way binding cannot resolve a setter for " + this.getResolvedType().toJavaCode() + " property '" + this.mName + "'";
        }
        if (!this.mGetter.isDynamic()) {
            return "Cannot change a final field in " + this.getResolvedType().toJavaCode() + " property " + this.mName;
        }
        return null;
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    public int getMinApi() {
        return this.mGetter == null ? 0 : this.mGetter.getMinApi();
    }

    @Override
    public boolean isDynamic() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        if (this.mGetter == null || this.mGetter.type == Callable.Type.METHOD) {
            return true;
        }
        if (this.getTarget().isDynamic()) {
            return !this.mGetter.isStatic() || this.mGetter.isDynamic();
        }
        if (this.mIsViewAttributeAccess) {
            return true;
        }
        return this.mGetter.isDynamic();
    }

    public boolean hasBindableAnnotations() {
        return this.mGetter != null && this.mGetter.canBeInvalidated();
    }

    @Override
    public Expr resolveListeners(ModelClass listener, Expr parent) {
        ModelClass targetType = this.getTarget().getResolvedType();
        if (!(this.getGetter() != null || listener != null && this.mIsListener || this.mIsMap)) {
            L.e((String)"Could not resolve %s.%s as an accessor or listener on the attribute.", (Object[])new Object[]{targetType.getCanonicalName(), this.mName});
            return this;
        }
        try {
            Expr listenerExpr = this.resolveListenersAsMethodReference(listener, parent);
            L.w((String)"Method references using '.' is deprecated. Instead of '%s', use '%s::%s'", (Object[])new Object[]{this.toString(), this.getTarget(), this.getName()});
            return listenerExpr;
        }
        catch (IllegalStateException e) {
            if (this.getGetter() == null && !this.mIsMap) {
                L.e((String)"%s", (Object[])new Object[]{e.getMessage()});
            }
            return this;
        }
    }

    @Override
    protected String computeUniqueKey() {
        if (this.mName.isEmpty()) {
            return FieldAccessExpr.join(this.getTarget(), ".get-()");
        }
        return FieldAccessExpr.join(this.getTarget(), Character.valueOf('.'), this.mName);
    }

    public String getBrName() {
        if (this.mIsListener) {
            return null;
        }
        try {
            Scope.enter((ScopeProvider)this);
            Preconditions.checkNotNull((Object)this.mGetter, (String)"cannot get br name before resolving the getter", (Object[])new Object[0]);
            String string = this.mBrName;
            return string;
        }
        finally {
            Scope.exit();
        }
    }

    public String[] getDirtyingProperties() {
        String br;
        String[] names = this.mDependencies != null ? (String[])this.mTransitiveDependencies.stream().map(dep -> dep.getBrName()).filter(brName -> brName != null).toArray(String[]::new) : ((br = this.getBrName()) == null ? new String[]{} : new String[]{br});
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies() {
        if (this.mGetter != null && this.mGetter.canBeInvalidated()) {
            if (this.mGetter.type == Callable.Type.FIELD) {
                if (this.mGetter.bindableAnnotation != null && this.mGetter.bindableAnnotation.getDependencies().length != 0) {
                    L.e((String)"Bindable annotation with property names is only supported on methods. Field '%s.%s' has @Bindable(\"%s\")", (Object[])new Object[]{this.getTarget().getResolvedType().toJavaCode(), this.mGetter.name, StringUtils.join((CharSequence[])this.mGetter.bindableAnnotation.getDependencies(), (String)"\", \"")});
                }
            } else if (this.mGetter.method != null && this.mGetter.canBeInvalidated() && this.mGetter.bindableAnnotation != null) {
                try {
                    Scope.enter((ScopeProvider)this);
                    String[] dependencyArray = this.mGetter.bindableAnnotation.getDependencies();
                    Expr target = this.getTarget();
                    ModelClass resolvedType = target.getResolvedType();
                    L.d((String)"resolving %s. Resolved class type: %s", (Object[])new Object[]{this, resolvedType});
                    boolean isStatic = target instanceof StaticIdentifierExpr;
                    for (String dependency : dependencyArray) {
                        Callable getter = resolvedType.findGetterOrField(dependency, isStatic);
                        if (getter == null) {
                            L.e((String)"Could not find dependent property '%s' referenced in @Bindable annotation on %s.%s", (Object[])new Object[]{dependency, this.mGetter.method.getDeclaringClass().toJavaCode(), this.mGetter.method.getName()});
                            continue;
                        }
                        if (getter.canBeInvalidated() || getter.resolvedType.isObservableField()) continue;
                        L.e((String)"The dependent property '%s' referenced in @Bindable annotation on %s.%s must be annotated with @Bindable", (Object[])new Object[]{dependency, this.mGetter.method.getDeclaringClass().toJavaCode(), this.mGetter.method.getName()});
                    }
                    this.mDependencies = new FieldAccessExpr[dependencyArray.length];
                    for (int i = 0; i < dependencyArray.length; ++i) {
                        this.mDependencies[i] = this.getModel().field(target, dependencyArray[i]);
                        this.mDependencies[i].getResolvedType();
                        this.getModel().bindingExpr(this.mDependencies[i]);
                    }
                    this.resolveDependencies(this.mTransitiveDependencies);
                    for (FieldAccessExpr expr : this.mTransitiveDependencies) {
                        expr.addBindableDependent(this);
                    }
                    this.mTransitiveDependencies.add(this);
                }
                finally {
                    Scope.exit();
                }
            }
        }
    }

    private void resolveDependencies(HashSet<FieldAccessExpr> dependencies) {
        if (this.mDependencies != null) {
            for (FieldAccessExpr expr : this.mDependencies) {
                if (dependencies.contains(expr)) continue;
                dependencies.add(expr);
                expr.resolveDependencies(dependencies);
            }
        }
    }

    private void addBindableDependent(FieldAccessExpr expr) {
        if (expr != this && !this.mDependents.contains(expr)) {
            this.mDependents.add(expr);
            for (FieldAccessExpr dep : this.mTransitiveDependencies) {
                dep.addBindableDependent(expr);
            }
        }
    }

    public Set<FieldAccessExpr> getBindableDependents() {
        return this.mDependents;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mIsListener) {
            return modelAnalyzer.findClass(Object.class);
        }
        if (this.mGetter == null) {
            Expr target = this.getTarget();
            this.mIsMap = target.getResolvedType().isMap();
            boolean isStatic = target instanceof StaticIdentifierExpr;
            ModelClass resolvedType = target.getResolvedType();
            L.d((String)"resolving %s. Resolved class type: %s", (Object[])new Object[]{this, resolvedType});
            this.mGetter = resolvedType.findGetterOrField(this.mName, isStatic);
            if (this.mGetter == null) {
                boolean bl = this.mIsListener = !resolvedType.findMethods(this.mName, isStatic).isEmpty();
                if (!this.mIsListener && !this.mIsMap) {
                    L.e((String)"Could not find accessor %s.%s", (Object[])new Object[]{resolvedType.getCanonicalName(), this.mName});
                } else {
                    if (this.mIsMap) {
                        return target.getResolvedType().getComponentType();
                    }
                    return modelAnalyzer.findClass(Object.class);
                }
            }
            if (this.mGetter.isStatic() && !isStatic) {
                this.replaceStaticIdentifier(resolvedType);
                target = this.getTarget();
            }
            if (this.hasBindableAnnotations()) {
                this.mBrName = ExtKt.br((String)BrNameUtil.brKey(this.mGetter));
            }
            this.resolveDependencies();
        }
        return this.mGetter.resolvedType;
    }

    protected void replaceStaticIdentifier(ModelClass staticIdentifierType) {
        this.getTarget().getParents().remove(this);
        this.getChildren().remove(this.getTarget());
        StaticIdentifierExpr staticId = this.getModel().staticIdentifierFor(staticIdentifierType);
        this.getChildren().add(staticId);
        staticId.getParents().add(this);
    }

    @Override
    public Expr resolveTwoWayExpressions(Expr parent) {
        ModelClass targetClass;
        Expr child = this.getTarget();
        if (!(child instanceof ViewFieldExpr)) {
            return super.resolveTwoWayExpressions(parent);
        }
        ViewFieldExpr expr = (ViewFieldExpr)child;
        BindingTarget bindingTarget = expr.getBindingTarget();
        for (Binding binding : bindingTarget.getBindings()) {
            if (!FieldAccessExpr.attributeMatchesName(binding.getName(), this.mName)) continue;
            Expr replacement = binding.getExpr().cloneToModel(this.getModel());
            this.replaceExpression(parent, replacement);
            return replacement;
        }
        SetterStore setterStore = SetterStore.get();
        SetterStore.BindingGetterCall getter = setterStore.getGetterCall(this.mName, targetClass = expr.getResolvedType(), null, null);
        if (getter == null && (getter = setterStore.getGetterCall("android:" + this.mName, targetClass, null, null)) == null) {
            L.e((String)"Could not resolve the two-way binding attribute '%s' on type '%s'", (Object[])new Object[]{this.mName, targetClass});
        }
        InverseBinding inverseBinding = null;
        for (Binding binding : bindingTarget.getBindings()) {
            Expr testExpr = binding.getExpr();
            if (!(testExpr instanceof TwoWayListenerExpr) || !getter.getEventAttribute().equals(binding.getName())) continue;
            inverseBinding = ((TwoWayListenerExpr)testExpr).mInverseBinding;
            break;
        }
        if (inverseBinding == null) {
            inverseBinding = bindingTarget.addInverseBinding(this.mName, getter);
        }
        inverseBinding.addChainedExpression(this);
        this.mIsViewAttributeAccess = true;
        this.enableDirectInvalidation();
        return this;
    }

    private static boolean attributeMatchesName(String attribute, String field) {
        int colonIndex = attribute.indexOf(58);
        return attribute.substring(colonIndex + 1).equals(field);
    }

    private void replaceExpression(Expr parent, Expr replacement) {
        if (parent != null) {
            int index;
            List<Expr> children = parent.getChildren();
            while ((index = children.indexOf(this)) >= 0) {
                children.set(index, replacement);
                replacement.getParents().add(parent);
            }
            while (this.getParents().remove(parent)) {
            }
        }
        if (this.getParents().isEmpty()) {
            this.getModel().removeExpr(this);
        }
    }

    @Override
    protected String asPackage() {
        String parentPackage = this.getTarget().asPackage();
        return parentPackage == null ? null : parentPackage + "." + this.mName;
    }

    @Override
    protected KCode generateCode() {
        Callable getter = this.getGetter();
        if (!this.mIsMap) {
            Preconditions.checkNotNull((Object)getter, (String)"Cannot resolve type '%s'", (Object[])new Object[]{this});
        }
        KCode code = new KCode().app("", this.getTarget().toCode()).app(".");
        if (getter == null && this.mIsMap) {
            return code.app("get(\"").app(this.mName).app("\")");
        }
        if (getter.type == Callable.Type.FIELD) {
            return code.app(getter.name);
        }
        return code.app(getter.name).app("()");
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        Expr result;
        Expr castExpr = model.castExpr(this.getResolvedType().toJavaCode(), value);
        Expr target = this.getTarget().cloneToModel(model);
        if (this.mName.isEmpty()) {
            result = model.methodCall(target, "set", Lists.newArrayList((Object[])new Expr[]{castExpr}));
            result.setUnwrapObservableFields(false);
        } else {
            result = this.getGetter().type == Callable.Type.FIELD ? model.assignment(target, this.mName, castExpr) : model.methodCall(target, this.mGetter.setterName, Lists.newArrayList((Object[])new Expr[]{castExpr}));
        }
        return result;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        Expr clonedTarget = this.getTarget().cloneToModel(model);
        return model.field(clonedTarget, this.mName);
    }

    @Override
    public String toString() {
        String name = this.mName.isEmpty() ? "get()" : this.mName;
        return this.getTarget().toString() + '.' + name;
    }
}

