/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.widget.CompoundButton;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@BindingMethods(value={@BindingMethod(type=CompoundButton.class, attribute="android:buttonTint", method="setButtonTintList"), @BindingMethod(type=CompoundButton.class, attribute="android:onCheckedChanged", method="setOnCheckedChangeListener")})
@InverseBindingMethods(value={@InverseBindingMethod(type=CompoundButton.class, attribute="android:checked")})
public class CompoundButtonBindingAdapter {
    @BindingAdapter(value={"android:checked"})
    public static void setChecked(CompoundButton view, boolean checked) {
        if (view.isChecked() != checked) {
            view.setChecked(checked);
        }
    }

    @BindingAdapter(value={"android:onCheckedChanged", "android:checkedAttrChanged"}, requireAll=false)
    public static void setListeners(CompoundButton view, final CompoundButton.OnCheckedChangeListener listener, final InverseBindingListener attrChange) {
        if (attrChange == null) {
            view.setOnCheckedChangeListener(listener);
        } else {
            view.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (listener != null) {
                        listener.onCheckedChanged(buttonView, isChecked);
                    }
                    attrChange.onChange();
                }
            });
        }
    }
}

