/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.Chain;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

public class WidgetGroup {
    private static final boolean DEBUG = false;
    ArrayList<ConstraintWidget> mWidgets = new ArrayList();
    static int sCount = 0;
    int mId = sCount++;
    boolean mAuthoritative = false;
    int mOrientation = 0;
    ArrayList<MeasureResult> mResults = null;
    private int mMoveTo = -1;

    public WidgetGroup(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getId() {
        return this.mId;
    }

    public boolean add(ConstraintWidget widget) {
        if (this.mWidgets.contains(widget)) {
            return false;
        }
        this.mWidgets.add(widget);
        return true;
    }

    public void setAuthoritative(boolean isAuthoritative) {
        this.mAuthoritative = isAuthoritative;
    }

    public boolean isAuthoritative() {
        return this.mAuthoritative;
    }

    private String getOrientationString() {
        if (this.mOrientation == 0) {
            return "Horizontal";
        }
        if (this.mOrientation == 1) {
            return "Vertical";
        }
        if (this.mOrientation == 2) {
            return "Both";
        }
        return "Unknown";
    }

    public String toString() {
        String ret = this.getOrientationString() + " [" + this.mId + "] <";
        for (ConstraintWidget widget : this.mWidgets) {
            ret = ret + " " + widget.getDebugName();
        }
        ret = ret + " >";
        return ret;
    }

    public void moveTo(int orientation, WidgetGroup widgetGroup) {
        for (ConstraintWidget widget : this.mWidgets) {
            widgetGroup.add(widget);
            if (orientation == 0) {
                widget.horizontalGroup = widgetGroup.getId();
                continue;
            }
            widget.verticalGroup = widgetGroup.getId();
        }
        this.mMoveTo = widgetGroup.mId;
    }

    public void clear() {
        this.mWidgets.clear();
    }

    private int measureWrap(int orientation, ConstraintWidget widget) {
        ConstraintWidget.DimensionBehaviour behaviour = widget.getDimensionBehaviour(orientation);
        if (behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || behaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || behaviour == ConstraintWidget.DimensionBehaviour.FIXED) {
            int dimension = orientation == 0 ? widget.getWidth() : widget.getHeight();
            return dimension;
        }
        return -1;
    }

    public int measureWrap(LinearSystem system, int orientation) {
        int count = this.mWidgets.size();
        if (count == 0) {
            return 0;
        }
        return this.solverMeasure(system, this.mWidgets, orientation);
    }

    private int solverMeasure(LinearSystem system, ArrayList<ConstraintWidget> widgets, int orientation) {
        ConstraintWidget widget;
        ConstraintWidgetContainer container = (ConstraintWidgetContainer)widgets.get(0).getParent();
        system.reset();
        boolean prevDebug = false;
        container.addToSolver(system, false);
        for (int i = 0; i < widgets.size(); ++i) {
            widget = widgets.get(i);
            widget.addToSolver(system, false);
        }
        if (orientation == 0 && container.mHorizontalChainsSize > 0) {
            Chain.applyChainConstraints(container, system, widgets, 0);
        }
        if (orientation == 1 && container.mVerticalChainsSize > 0) {
            Chain.applyChainConstraints(container, system, widgets, 1);
        }
        try {
            system.minimize();
        }
        catch (Exception e) {
            System.err.println(e.toString() + "\n" + Arrays.toString(e.getStackTrace()).replace("[", "   at ").replace(",", "\n   at").replace("]", ""));
        }
        this.mResults = new ArrayList();
        for (int i = 0; i < widgets.size(); ++i) {
            widget = widgets.get(i);
            MeasureResult result = new MeasureResult(widget, system, orientation);
            this.mResults.add(result);
        }
        if (orientation == 0) {
            int left = system.getObjectVariableValue(container.mLeft);
            int right = system.getObjectVariableValue(container.mRight);
            system.reset();
            return right - left;
        }
        int top = system.getObjectVariableValue(container.mTop);
        int bottom = system.getObjectVariableValue(container.mBottom);
        system.reset();
        return bottom - top;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public void apply() {
        if (this.mResults == null) {
            return;
        }
        if (!this.mAuthoritative) {
            return;
        }
        for (int i = 0; i < this.mResults.size(); ++i) {
            MeasureResult result = this.mResults.get(i);
            result.apply();
        }
    }

    public boolean intersectWith(WidgetGroup group) {
        for (int i = 0; i < this.mWidgets.size(); ++i) {
            ConstraintWidget widget = this.mWidgets.get(i);
            if (!group.contains(widget)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(ConstraintWidget widget) {
        return this.mWidgets.contains(widget);
    }

    public int size() {
        return this.mWidgets.size();
    }

    public void cleanup(ArrayList<WidgetGroup> dependencyLists) {
        int count = this.mWidgets.size();
        if (this.mMoveTo != -1 && count > 0) {
            for (int i = 0; i < dependencyLists.size(); ++i) {
                WidgetGroup group = dependencyLists.get(i);
                if (this.mMoveTo != group.mId) continue;
                this.moveTo(this.mOrientation, group);
            }
        }
        if (count == 0) {
            dependencyLists.remove(this);
            return;
        }
    }

    static class MeasureResult {
        WeakReference<ConstraintWidget> mWidgetRef;
        int mLeft;
        int mTop;
        int mRight;
        int mBottom;
        int mBaseline;
        int mOrientation;

        MeasureResult(ConstraintWidget widget, LinearSystem system, int orientation) {
            this.mWidgetRef = new WeakReference<ConstraintWidget>(widget);
            this.mLeft = system.getObjectVariableValue(widget.mLeft);
            this.mTop = system.getObjectVariableValue(widget.mTop);
            this.mRight = system.getObjectVariableValue(widget.mRight);
            this.mBottom = system.getObjectVariableValue(widget.mBottom);
            this.mBaseline = system.getObjectVariableValue(widget.mBaseline);
            this.mOrientation = orientation;
        }

        public void apply() {
            ConstraintWidget widget = (ConstraintWidget)this.mWidgetRef.get();
            if (widget != null) {
                widget.setFinalFrame(this.mLeft, this.mTop, this.mRight, this.mBottom, this.mBaseline, this.mOrientation);
            }
        }
    }
}

