/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLParser;
import java.util.Arrays;
import java.util.Objects;

public class CLElement
implements Cloneable {
    private final char[] mContent;
    protected long mStart = -1L;
    protected long mEnd = Long.MAX_VALUE;
    protected CLContainer mContainer;
    private int mLine;
    protected static int sMaxLine = 80;
    protected static int sBaseIndent = 2;

    public CLElement(char[] content) {
        this.mContent = content;
    }

    public boolean notStarted() {
        return this.mStart == -1L;
    }

    public void setLine(int line) {
        this.mLine = line;
    }

    public int getLine() {
        return this.mLine;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public void setEnd(long end) {
        if (this.mEnd != Long.MAX_VALUE) {
            return;
        }
        this.mEnd = end;
        if (CLParser.sDebug) {
            System.out.println("closing " + this.hashCode() + " -> " + this);
        }
        if (this.mContainer != null) {
            this.mContainer.add(this);
        }
    }

    protected void addIndent(StringBuilder builder, int indent) {
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
    }

    public String toString() {
        if (this.mStart > this.mEnd || this.mEnd == Long.MAX_VALUE) {
            return this.getClass() + " (INVALID, " + this.mStart + "-" + this.mEnd + ")";
        }
        String content = new String(this.mContent);
        content = content.substring((int)this.mStart, (int)this.mEnd + 1);
        return this.getStrClass() + " (" + this.mStart + " : " + this.mEnd + ") <<" + content + ">>";
    }

    protected String getStrClass() {
        String myClass = this.getClass().toString();
        return myClass.substring(myClass.lastIndexOf(46) + 1);
    }

    protected String getDebugName() {
        if (CLParser.sDebug) {
            return this.getStrClass() + " -> ";
        }
        return "";
    }

    public String content() {
        String content = new String(this.mContent);
        if (this.mEnd == Long.MAX_VALUE || this.mEnd < this.mStart) {
            return content.substring((int)this.mStart, (int)this.mStart + 1);
        }
        return content.substring((int)this.mStart, (int)this.mEnd + 1);
    }

    public boolean hasContent() {
        return this.mContent != null && this.mContent.length >= 1;
    }

    public boolean isDone() {
        return this.mEnd != Long.MAX_VALUE;
    }

    public void setContainer(CLContainer element) {
        this.mContainer = element;
    }

    public CLElement getContainer() {
        return this.mContainer;
    }

    public boolean isStarted() {
        return this.mStart > -1L;
    }

    protected String toJSON() {
        return "";
    }

    protected String toFormattedJSON(int indent, int forceIndent) {
        return "";
    }

    public int getInt() {
        if (this instanceof CLNumber) {
            return ((CLNumber)this).getInt();
        }
        return 0;
    }

    public float getFloat() {
        if (this instanceof CLNumber) {
            return ((CLNumber)this).getFloat();
        }
        return Float.NaN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CLElement)) {
            return false;
        }
        CLElement clElement = (CLElement)o;
        if (this.mStart != clElement.mStart) {
            return false;
        }
        if (this.mEnd != clElement.mEnd) {
            return false;
        }
        if (this.mLine != clElement.mLine) {
            return false;
        }
        if (!Arrays.equals(this.mContent, clElement.mContent)) {
            return false;
        }
        return Objects.equals(this.mContainer, clElement.mContainer);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mContent);
        result = 31 * result + (int)(this.mStart ^ this.mStart >>> 32);
        result = 31 * result + (int)(this.mEnd ^ this.mEnd >>> 32);
        result = 31 * result + (this.mContainer != null ? this.mContainer.hashCode() : 0);
        result = 31 * result + this.mLine;
        return result;
    }

    public CLElement clone() {
        try {
            CLElement clone = (CLElement)super.clone();
            if (this.mContainer != null) {
                clone.mContainer = this.mContainer.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

