/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.helpers.ChainReference;

public class VerticalChainReference
extends ChainReference {
    public VerticalChainReference(State state) {
        super(state, State.Helper.VERTICAL_CHAIN);
    }

    @Override
    public void apply() {
        ConstraintReference reference;
        ConstraintReference first = null;
        ConstraintReference previous = null;
        for (Object key : this.mReferences) {
            reference = this.mState.constraints(key);
            reference.clearVertical();
        }
        for (Object key : this.mReferences) {
            float weight;
            reference = this.mState.constraints(key);
            if (first == null) {
                first = reference;
                if (this.mTopToTop != null) {
                    first.topToTop(this.mTopToTop).margin(this.mMarginTop).marginGone(this.mMarginTopGone);
                } else if (this.mTopToBottom != null) {
                    first.topToBottom(this.mTopToBottom).margin(this.mMarginTop).marginGone(this.mMarginTopGone);
                } else {
                    String refKey = reference.getKey().toString();
                    first.topToTop(State.PARENT).margin(Float.valueOf(this.getPreMargin(refKey)));
                }
            }
            if (previous != null) {
                String preKey = previous.getKey().toString();
                String refKey = reference.getKey().toString();
                previous.bottomToTop(reference.getKey()).margin(Float.valueOf(this.getPostMargin(preKey)));
                reference.topToBottom(previous.getKey()).margin(Float.valueOf(this.getPreMargin(refKey)));
            }
            if ((weight = this.getWeight(key.toString())) != -1.0f) {
                reference.setVerticalChainWeight(weight);
            }
            previous = reference;
        }
        if (previous != null) {
            if (this.mBottomToTop != null) {
                previous.bottomToTop(this.mBottomToTop).margin(this.mMarginBottom).marginGone(this.mMarginBottomGone);
            } else if (this.mBottomToBottom != null) {
                previous.bottomToBottom(this.mBottomToBottom).margin(this.mMarginBottom).marginGone(this.mMarginBottomGone);
            } else {
                String preKey = previous.getKey().toString();
                previous.bottomToBottom(State.PARENT).margin(Float.valueOf(this.getPostMargin(preKey)));
            }
        }
        if (first == null) {
            return;
        }
        if (this.mBias != 0.5f) {
            first.verticalBias(this.mBias);
        }
        switch (this.mStyle) {
            case SPREAD: {
                first.setVerticalChainStyle(0);
                break;
            }
            case SPREAD_INSIDE: {
                first.setVerticalChainStyle(1);
                break;
            }
            case PACKED: {
                first.setVerticalChainStyle(2);
            }
        }
    }
}

