/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.helpers.ChainReference;

public class HorizontalChainReference
extends ChainReference {
    public HorizontalChainReference(State state) {
        super(state, State.Helper.HORIZONTAL_CHAIN);
    }

    @Override
    public void apply() {
        ConstraintReference reference;
        ConstraintReference first = null;
        ConstraintReference previous = null;
        for (Object key : this.mReferences) {
            reference = this.mState.constraints(key);
            reference.clearHorizontal();
        }
        for (Object key : this.mReferences) {
            float weight;
            reference = this.mState.constraints(key);
            if (first == null) {
                first = reference;
                if (this.mStartToStart != null) {
                    first.startToStart(this.mStartToStart).margin(this.mMarginStart).marginGone(this.mMarginStartGone);
                } else if (this.mStartToEnd != null) {
                    first.startToEnd(this.mStartToEnd).margin(this.mMarginStart).marginGone(this.mMarginStartGone);
                } else if (this.mLeftToLeft != null) {
                    first.startToStart(this.mLeftToLeft).margin(this.mMarginLeft).marginGone(this.mMarginLeftGone);
                } else if (this.mLeftToRight != null) {
                    first.startToEnd(this.mLeftToRight).margin(this.mMarginLeft).marginGone(this.mMarginLeftGone);
                } else {
                    String refKey = reference.getKey().toString();
                    first.startToStart(State.PARENT).margin(Float.valueOf(this.getPreMargin(refKey)));
                }
            }
            if (previous != null) {
                String preKey = previous.getKey().toString();
                String refKey = reference.getKey().toString();
                previous.endToStart(reference.getKey()).margin(Float.valueOf(this.getPostMargin(preKey)));
                reference.startToEnd(previous.getKey()).margin(Float.valueOf(this.getPreMargin(refKey)));
            }
            if ((weight = this.getWeight(key.toString())) != -1.0f) {
                reference.setHorizontalChainWeight(weight);
            }
            previous = reference;
        }
        if (previous != null) {
            if (this.mEndToStart != null) {
                previous.endToStart(this.mEndToStart).margin(this.mMarginEnd).marginGone(this.mMarginEndGone);
            } else if (this.mEndToEnd != null) {
                previous.endToEnd(this.mEndToEnd).margin(this.mMarginEnd).marginGone(this.mMarginEndGone);
            } else if (this.mRightToLeft != null) {
                previous.endToStart(this.mRightToLeft).margin(this.mMarginRight).marginGone(this.mMarginRightGone);
            } else if (this.mRightToRight != null) {
                previous.endToEnd(this.mRightToRight).margin(this.mMarginRight).marginGone(this.mMarginRightGone);
            } else {
                String preKey = previous.getKey().toString();
                previous.endToEnd(State.PARENT).margin(Float.valueOf(this.getPostMargin(preKey)));
            }
        }
        if (first == null) {
            return;
        }
        if (this.mBias != 0.5f) {
            first.horizontalBias(this.mBias);
        }
        switch (this.mStyle) {
            case SPREAD: {
                first.setHorizontalChainStyle(0);
                break;
            }
            case SPREAD_INSIDE: {
                first.setHorizontalChainStyle(1);
                break;
            }
            case PACKED: {
                first.setHorizontalChainStyle(2);
            }
        }
    }
}

