/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.CoreMotionScene;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.ChainReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ConstraintSetParser {
    private static final boolean PARSER_DEBUG = false;

    public static void parseJSON(String content, Transition transition, int state) {
        try {
            CLObject json = CLParser.parse(content);
            ArrayList<String> elements = json.names();
            if (elements == null) {
                return;
            }
            for (String elementName : elements) {
                CLObject element;
                CLObject customProperties;
                CLElement base_element = json.get(elementName);
                if (!(base_element instanceof CLObject) || (customProperties = (element = (CLObject)base_element).getObjectOrNull("custom")) == null) continue;
                ArrayList<String> properties = customProperties.names();
                for (String property : properties) {
                    long color;
                    CLElement value = customProperties.get(property);
                    if (value instanceof CLNumber) {
                        transition.addCustomFloat(state, elementName, property, value.getFloat());
                        continue;
                    }
                    if (!(value instanceof CLString) || (color = ConstraintSetParser.parseColorString(value.content())) == -1L) continue;
                    transition.addCustomColor(state, elementName, property, (int)color);
                }
            }
        }
        catch (CLParsingException e) {
            System.err.println("Error parsing JSON " + e);
        }
    }

    public static void parseMotionSceneJSON(CoreMotionScene scene, String content) {
        try {
            CLObject json = CLParser.parse(content);
            ArrayList<String> elements = json.names();
            if (elements == null) {
                return;
            }
            for (String elementName : elements) {
                CLElement element = json.get(elementName);
                if (!(element instanceof CLObject)) continue;
                CLObject clObject = (CLObject)element;
                switch (elementName) {
                    case "ConstraintSets": {
                        ConstraintSetParser.parseConstraintSets(scene, clObject);
                        break;
                    }
                    case "Transitions": {
                        ConstraintSetParser.parseTransitions(scene, clObject);
                        break;
                    }
                    case "Header": {
                        ConstraintSetParser.parseHeader(scene, clObject);
                    }
                }
            }
        }
        catch (CLParsingException e) {
            System.err.println("Error parsing JSON " + e);
        }
    }

    static void parseConstraintSets(CoreMotionScene scene, CLObject json) throws CLParsingException {
        ArrayList<String> constraintSetNames = json.names();
        if (constraintSetNames == null) {
            return;
        }
        for (String csName : constraintSetNames) {
            CLObject constraintSet = json.getObject(csName);
            boolean added = false;
            String ext = constraintSet.getStringOrNull("Extends");
            if (ext != null && !ext.isEmpty()) {
                String base = scene.getConstraintSet(ext);
                if (base == null) continue;
                CLObject baseJson = CLParser.parse(base);
                ArrayList<String> widgetsOverride = constraintSet.names();
                if (widgetsOverride == null) continue;
                for (String widgetOverrideName : widgetsOverride) {
                    CLElement value = constraintSet.get(widgetOverrideName);
                    if (!(value instanceof CLObject)) continue;
                    ConstraintSetParser.override(baseJson, widgetOverrideName, (CLObject)value);
                }
                scene.setConstraintSetContent(csName, baseJson.toJSON());
                added = true;
            }
            if (added) continue;
            scene.setConstraintSetContent(csName, constraintSet.toJSON());
        }
    }

    static void override(CLObject baseJson, String name, CLObject overrideValue) throws CLParsingException {
        if (!baseJson.has(name)) {
            baseJson.put(name, overrideValue);
        } else {
            CLObject base = baseJson.getObject(name);
            ArrayList<String> keys = overrideValue.names();
            for (String key : keys) {
                if (!key.equals("clear")) {
                    base.put(key, overrideValue.get(key));
                    continue;
                }
                CLArray toClear = overrideValue.getArray("clear");
                block11: for (int i = 0; i < toClear.size(); ++i) {
                    String clearedKey = toClear.getStringOrNull(i);
                    if (clearedKey == null) continue;
                    switch (clearedKey) {
                        case "dimensions": {
                            base.remove("width");
                            base.remove("height");
                            continue block11;
                        }
                        case "constraints": {
                            base.remove("start");
                            base.remove("end");
                            base.remove("top");
                            base.remove("bottom");
                            base.remove("baseline");
                            base.remove("center");
                            base.remove("centerHorizontally");
                            base.remove("centerVertically");
                            continue block11;
                        }
                        case "transforms": {
                            base.remove("visibility");
                            base.remove("alpha");
                            base.remove("pivotX");
                            base.remove("pivotY");
                            base.remove("rotationX");
                            base.remove("rotationY");
                            base.remove("rotationZ");
                            base.remove("scaleX");
                            base.remove("scaleY");
                            base.remove("translationX");
                            base.remove("translationY");
                            continue block11;
                        }
                        default: {
                            base.remove(clearedKey);
                        }
                    }
                }
            }
        }
    }

    static void parseTransitions(CoreMotionScene scene, CLObject json) throws CLParsingException {
        ArrayList<String> elements = json.names();
        if (elements == null) {
            return;
        }
        for (String elementName : elements) {
            scene.setTransitionContent(elementName, json.getObject(elementName).toJSON());
        }
    }

    static void parseHeader(CoreMotionScene scene, CLObject json) {
        String name = json.getStringOrNull("export");
        if (name != null) {
            scene.setDebugName(name);
        }
    }

    public static void parseJSON(String content, State state, LayoutVariables layoutVariables) throws CLParsingException {
        try {
            CLObject json = CLParser.parse(content);
            ArrayList<String> elements = json.names();
            if (elements == null) {
                return;
            }
            block25: for (String elementName : elements) {
                CLElement element = json.get(elementName);
                switch (elementName) {
                    case "Variables": {
                        if (!(element instanceof CLObject)) continue block25;
                        ConstraintSetParser.parseVariables(state, layoutVariables, (CLObject)element);
                        continue block25;
                    }
                    case "Helpers": {
                        if (!(element instanceof CLArray)) continue block25;
                        ConstraintSetParser.parseHelpers(state, layoutVariables, (CLArray)element);
                        continue block25;
                    }
                    case "Generate": {
                        if (!(element instanceof CLObject)) continue block25;
                        ConstraintSetParser.parseGenerate(state, layoutVariables, (CLObject)element);
                        continue block25;
                    }
                }
                if (element instanceof CLObject) {
                    String type = ConstraintSetParser.lookForType((CLObject)element);
                    if (type != null) {
                        switch (type) {
                            case "hGuideline": {
                                ConstraintSetParser.parseGuidelineParams(0, state, elementName, (CLObject)element);
                                break;
                            }
                            case "vGuideline": {
                                ConstraintSetParser.parseGuidelineParams(1, state, elementName, (CLObject)element);
                                break;
                            }
                            case "barrier": {
                                ConstraintSetParser.parseBarrier(state, elementName, (CLObject)element);
                                break;
                            }
                            case "vChain": 
                            case "hChain": {
                                ConstraintSetParser.parseChainType(type, state, elementName, layoutVariables, (CLObject)element);
                            }
                        }
                        continue;
                    }
                    ConstraintSetParser.parseWidget(state, layoutVariables, elementName, (CLObject)element);
                    continue;
                }
                if (!(element instanceof CLNumber)) continue;
                layoutVariables.put(elementName, element.getInt());
            }
        }
        catch (CLParsingException e) {
            System.err.println("Error parsing JSON " + e);
        }
    }

    private static void parseVariables(State state, LayoutVariables layoutVariables, CLObject json) throws CLParsingException {
        ArrayList<String> elements = json.names();
        if (elements == null) {
            return;
        }
        for (String elementName : elements) {
            ArrayList<String> arrayIds;
            CLElement element = json.get(elementName);
            if (element instanceof CLNumber) {
                layoutVariables.put(elementName, element.getInt());
                continue;
            }
            if (!(element instanceof CLObject)) continue;
            CLObject obj = (CLObject)element;
            if (obj.has("from") && obj.has("to")) {
                float from = layoutVariables.get(obj.get("from"));
                float to = layoutVariables.get(obj.get("to"));
                String prefix = obj.getStringOrNull("prefix");
                String postfix = obj.getStringOrNull("postfix");
                layoutVariables.put(elementName, from, to, 1.0f, prefix, postfix);
                continue;
            }
            if (obj.has("from") && obj.has("step")) {
                float start = layoutVariables.get(obj.get("from"));
                float increment = layoutVariables.get(obj.get("step"));
                layoutVariables.put(elementName, start, increment);
                continue;
            }
            if (obj.has("ids")) {
                CLArray ids = obj.getArray("ids");
                arrayIds = new ArrayList();
                for (int i = 0; i < ids.size(); ++i) {
                    arrayIds.add(ids.getString(i));
                }
                layoutVariables.put(elementName, arrayIds);
                continue;
            }
            if (!obj.has("tag")) continue;
            arrayIds = state.getIdsForTag(obj.getString("tag"));
            layoutVariables.put(elementName, arrayIds);
        }
    }

    public static void parseDesignElementsJSON(String content, ArrayList<DesignElement> list) throws CLParsingException {
        block10: {
            CLObject json = CLParser.parse(content);
            ArrayList<String> elements = json.names();
            if (elements == null) {
                return;
            }
            int i = 0;
            if (i >= elements.size()) break block10;
            String elementName = elements.get(i);
            CLElement element = json.get(elementName);
            switch (elementName) {
                case "Design": {
                    if (!(element instanceof CLObject)) {
                        return;
                    }
                    CLObject obj = (CLObject)element;
                    elements = obj.names();
                    for (int j = 0; j < elements.size(); ++j) {
                        String designElementName = elements.get(j);
                        CLObject designElement = (CLObject)((CLObject)element).get(designElementName);
                        System.out.printf("element found " + designElementName, new Object[0]);
                        String type = designElement.getStringOrNull("type");
                        if (type == null) continue;
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        int size = designElement.size();
                        for (int k = 0; k < size; ++k) {
                            CLKey key = (CLKey)designElement.get(j);
                            String paramName = key.content();
                            String paramValue = key.getValue().content();
                            if (paramValue == null) continue;
                            parameters.put(paramName, paramValue);
                        }
                        list.add(new DesignElement(elementName, type, parameters));
                    }
                    break;
                }
            }
        }
    }

    static void parseHelpers(State state, LayoutVariables layoutVariables, CLArray element) throws CLParsingException {
        block12: for (int i = 0; i < element.size(); ++i) {
            CLArray array;
            CLElement helper = element.get(i);
            if (!(helper instanceof CLArray) || (array = (CLArray)helper).size() <= 1) continue;
            switch (array.getString(0)) {
                case "hChain": {
                    ConstraintSetParser.parseChain(0, state, layoutVariables, array);
                    continue block12;
                }
                case "vChain": {
                    ConstraintSetParser.parseChain(1, state, layoutVariables, array);
                    continue block12;
                }
                case "hGuideline": {
                    ConstraintSetParser.parseGuideline(0, state, array);
                    continue block12;
                }
                case "vGuideline": {
                    ConstraintSetParser.parseGuideline(1, state, array);
                }
            }
        }
    }

    static void parseGenerate(State state, LayoutVariables layoutVariables, CLObject json) throws CLParsingException {
        ArrayList<String> elements = json.names();
        if (elements == null) {
            return;
        }
        for (String elementName : elements) {
            CLElement element = json.get(elementName);
            ArrayList<String> arrayIds = layoutVariables.getList(elementName);
            if (arrayIds == null || !(element instanceof CLObject)) continue;
            for (String id : arrayIds) {
                ConstraintSetParser.parseWidget(state, layoutVariables, id, (CLObject)element);
            }
        }
    }

    static void parseChain(int orientation, State state, LayoutVariables margins, CLArray helper) throws CLParsingException {
        ChainReference chain = orientation == 0 ? state.horizontalChain() : state.verticalChain();
        CLElement refs = helper.get(1);
        if (!(refs instanceof CLArray) || ((CLArray)refs).size() < 1) {
            return;
        }
        for (int i = 0; i < ((CLArray)refs).size(); ++i) {
            chain.add(((CLArray)refs).getString(i));
        }
        if (helper.size() > 2) {
            CLElement params = helper.get(2);
            if (!(params instanceof CLObject)) {
                return;
            }
            CLObject obj = (CLObject)params;
            ArrayList<String> constraints = obj.names();
            Iterator<String> iterator = constraints.iterator();
            while (iterator.hasNext()) {
                String constraintName;
                block3 : switch (constraintName = iterator.next()) {
                    case "style": {
                        String styleValue;
                        CLElement styleObject = ((CLObject)params).get(constraintName);
                        if (styleObject instanceof CLArray && ((CLArray)styleObject).size() > 1) {
                            styleValue = ((CLArray)styleObject).getString(0);
                            float biasValue = ((CLArray)styleObject).getFloat(1);
                            chain.bias(biasValue);
                        } else {
                            styleValue = styleObject.content();
                        }
                        switch (styleValue) {
                            case "packed": {
                                chain.style(State.Chain.PACKED);
                                break block3;
                            }
                            case "spread_inside": {
                                chain.style(State.Chain.SPREAD_INSIDE);
                                break block3;
                            }
                        }
                        chain.style(State.Chain.SPREAD);
                        break;
                    }
                    default: {
                        ConstraintSetParser.parseConstraint(state, margins, (CLObject)params, chain, constraintName);
                    }
                }
            }
        }
    }

    private static float toPix(State state, float dp) {
        return state.getDpToPixel().toPixels(dp);
    }

    private static void parseChainType(String orientation, State state, String chainName, LayoutVariables margins, CLObject object) throws CLParsingException {
        ChainReference chain = orientation.charAt(0) == 'h' ? state.horizontalChain() : state.verticalChain();
        chain.setKey(chainName);
        Iterator<String> iterator = object.names().iterator();
        block28: while (iterator.hasNext()) {
            String params;
            block10 : switch (params = iterator.next()) {
                case "contains": {
                    CLElement refs = object.get(params);
                    if (!(refs instanceof CLArray) || ((CLArray)refs).size() < 1) {
                        System.err.println(chainName + " contains should be an array \"" + refs.content() + "\"");
                        return;
                    }
                    for (int i = 0; i < ((CLArray)refs).size(); ++i) {
                        CLElement chainElement = ((CLArray)refs).get(i);
                        if (chainElement instanceof CLArray) {
                            CLArray array = (CLArray)chainElement;
                            if (array.size() <= 0) continue;
                            String id = array.get(0).content();
                            float weight = Float.NaN;
                            float preMargin = Float.NaN;
                            float postMargin = Float.NaN;
                            switch (array.size()) {
                                case 2: {
                                    weight = array.getFloat(1);
                                    break;
                                }
                                case 3: {
                                    weight = array.getFloat(1);
                                    postMargin = preMargin = ConstraintSetParser.toPix(state, array.getFloat(2));
                                    break;
                                }
                                case 4: {
                                    weight = array.getFloat(1);
                                    preMargin = ConstraintSetParser.toPix(state, array.getFloat(2));
                                    postMargin = ConstraintSetParser.toPix(state, array.getFloat(3));
                                }
                            }
                            chain.addChainElement(id, weight, preMargin, postMargin);
                            continue;
                        }
                        chain.add(chainElement.content());
                    }
                    continue block28;
                }
                case "start": 
                case "end": 
                case "top": 
                case "bottom": 
                case "left": 
                case "right": {
                    ConstraintSetParser.parseConstraint(state, margins, object, chain, params);
                    break;
                }
                case "style": {
                    String styleValue;
                    CLElement styleObject = object.get(params);
                    if (styleObject instanceof CLArray && ((CLArray)styleObject).size() > 1) {
                        styleValue = ((CLArray)styleObject).getString(0);
                        float biasValue = ((CLArray)styleObject).getFloat(1);
                        chain.bias(biasValue);
                    } else {
                        styleValue = styleObject.content();
                    }
                    switch (styleValue) {
                        case "packed": {
                            chain.style(State.Chain.PACKED);
                            break block10;
                        }
                        case "spread_inside": {
                            chain.style(State.Chain.SPREAD_INSIDE);
                            break block10;
                        }
                    }
                    chain.style(State.Chain.SPREAD);
                }
            }
        }
    }

    static void parseGuideline(int orientation, State state, CLArray helper) throws CLParsingException {
        CLElement params = helper.get(1);
        if (!(params instanceof CLObject)) {
            return;
        }
        String guidelineId = ((CLObject)params).getStringOrNull("id");
        if (guidelineId == null) {
            return;
        }
        ConstraintSetParser.parseGuidelineParams(orientation, state, guidelineId, (CLObject)params);
    }

    static void parseGuidelineParams(int orientation, State state, String guidelineId, CLObject params) throws CLParsingException {
        ArrayList<String> constraints = params.names();
        if (constraints == null) {
            return;
        }
        ConstraintReference reference = state.constraints(guidelineId);
        if (orientation == 0) {
            state.horizontalGuideline(guidelineId);
        } else {
            state.verticalGuideline(guidelineId);
        }
        GuidelineReference guidelineReference = (GuidelineReference)reference.getFacade();
        Iterator<String> iterator = constraints.iterator();
        while (iterator.hasNext()) {
            String constraintName;
            switch (constraintName = iterator.next()) {
                case "start": {
                    int margin = state.convertDimension(Float.valueOf(params.getFloat(constraintName)));
                    guidelineReference.start(Float.valueOf(state.getDpToPixel().toPixels(margin)));
                    break;
                }
                case "end": {
                    int margin = state.convertDimension(Float.valueOf(params.getFloat(constraintName)));
                    guidelineReference.end(Float.valueOf(state.getDpToPixel().toPixels(margin)));
                    break;
                }
                case "percent": {
                    guidelineReference.percent(params.getFloat(constraintName));
                }
            }
        }
    }

    static void parseBarrier(State state, String elementName, CLObject element) throws CLParsingException {
        BarrierReference reference = state.barrier(elementName, State.Direction.END);
        ArrayList<String> constraints = element.names();
        if (constraints == null) {
            return;
        }
        Iterator<String> iterator = constraints.iterator();
        while (iterator.hasNext()) {
            String constraintName;
            block5 : switch (constraintName = iterator.next()) {
                case "direction": {
                    switch (element.getString(constraintName)) {
                        case "start": {
                            reference.setBarrierDirection(State.Direction.START);
                            break block5;
                        }
                        case "end": {
                            reference.setBarrierDirection(State.Direction.END);
                            break block5;
                        }
                        case "left": {
                            reference.setBarrierDirection(State.Direction.LEFT);
                            break block5;
                        }
                        case "right": {
                            reference.setBarrierDirection(State.Direction.RIGHT);
                            break block5;
                        }
                        case "top": {
                            reference.setBarrierDirection(State.Direction.TOP);
                            break block5;
                        }
                        case "bottom": {
                            reference.setBarrierDirection(State.Direction.BOTTOM);
                        }
                    }
                    break;
                }
                case "margin": {
                    float margin = element.getFloatOrNaN(constraintName);
                    if (Float.isNaN(margin)) break;
                    reference.margin(Float.valueOf(margin));
                    break;
                }
                case "contains": {
                    CLArray list = element.getArrayOrNull(constraintName);
                    if (list == null) break;
                    for (int j = 0; j < list.size(); ++j) {
                        String elementNameReference = list.get(j).content();
                        ConstraintReference elementReference = state.constraints(elementNameReference);
                        reference.add(elementReference);
                    }
                    break;
                }
            }
        }
    }

    static void parseWidget(State state, LayoutVariables layoutVariables, String elementName, CLObject element) throws CLParsingException {
        ArrayList<String> constraints;
        ConstraintReference reference = state.constraints(elementName);
        if (reference.getWidth() == null) {
            reference.setWidth(Dimension.createWrap());
        }
        if (reference.getHeight() == null) {
            reference.setHeight(Dimension.createWrap());
        }
        if ((constraints = element.names()) == null) {
            return;
        }
        Iterator<String> iterator = constraints.iterator();
        block60: while (iterator.hasNext()) {
            String constraintName;
            switch (constraintName = iterator.next()) {
                case "width": {
                    reference.setWidth(ConstraintSetParser.parseDimension(element, constraintName, state, state.getDpToPixel()));
                    continue block60;
                }
                case "height": {
                    reference.setHeight(ConstraintSetParser.parseDimension(element, constraintName, state, state.getDpToPixel()));
                    continue block60;
                }
                case "center": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.equals("parent") ? state.constraints(State.PARENT) : state.constraints(target);
                    reference.startToStart(targetReference);
                    reference.endToEnd(targetReference);
                    reference.topToTop(targetReference);
                    reference.bottomToBottom(targetReference);
                    continue block60;
                }
                case "centerHorizontally": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.equals("parent") ? state.constraints(State.PARENT) : state.constraints(target);
                    reference.startToStart(targetReference);
                    reference.endToEnd(targetReference);
                    continue block60;
                }
                case "centerVertically": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.equals("parent") ? state.constraints(State.PARENT) : state.constraints(target);
                    reference.topToTop(targetReference);
                    reference.bottomToBottom(targetReference);
                    continue block60;
                }
                case "alpha": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.alpha(value);
                    continue block60;
                }
                case "scaleX": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.scaleX(value);
                    continue block60;
                }
                case "scaleY": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.scaleY(value);
                    continue block60;
                }
                case "translationX": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.translationX(value);
                    continue block60;
                }
                case "translationY": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.translationY(value);
                    continue block60;
                }
                case "translationZ": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.translationZ(value);
                    continue block60;
                }
                case "pivotX": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.pivotX(value);
                    continue block60;
                }
                case "pivotY": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.pivotY(value);
                    continue block60;
                }
                case "rotationX": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.rotationX(value);
                    continue block60;
                }
                case "rotationY": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.rotationY(value);
                    continue block60;
                }
                case "rotationZ": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.rotationZ(value);
                    continue block60;
                }
                case "visibility": {
                    switch (element.getString(constraintName)) {
                        case "visible": {
                            reference.visibility(0);
                            break;
                        }
                        case "invisible": {
                            reference.visibility(4);
                            break;
                        }
                        case "gone": {
                            reference.visibility(8);
                        }
                    }
                    continue block60;
                }
                case "vBias": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.verticalBias(value);
                    continue block60;
                }
                case "hBias": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.horizontalBias(value);
                    continue block60;
                }
                case "vWeight": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.setVerticalChainWeight(value);
                    continue block60;
                }
                case "hWeight": {
                    float value = layoutVariables.get(element.get(constraintName));
                    reference.setHorizontalChainWeight(value);
                    continue block60;
                }
                case "custom": {
                    ConstraintSetParser.parseCustomProperties(element, reference, constraintName);
                    continue block60;
                }
                case "motion": {
                    ConstraintSetParser.parseMotionProperties(element.get(constraintName), reference);
                    continue block60;
                }
            }
            ConstraintSetParser.parseConstraint(state, layoutVariables, element, reference, constraintName);
        }
    }

    static void parseCustomProperties(CLObject element, ConstraintReference reference, String constraintName) throws CLParsingException {
        CLObject json = element.getObjectOrNull(constraintName);
        if (json == null) {
            return;
        }
        ArrayList<String> properties = json.names();
        if (properties == null) {
            return;
        }
        for (String property : properties) {
            long it;
            CLElement value = json.get(property);
            if (value instanceof CLNumber) {
                reference.addCustomFloat(property, value.getFloat());
                continue;
            }
            if (!(value instanceof CLString) || (it = ConstraintSetParser.parseColorString(value.content())) == -1L) continue;
            reference.addCustomColor(property, (int)it);
        }
    }

    private static int indexOf(String val, String ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(val)) continue;
            return i;
        }
        return -1;
    }

    private static void parseMotionProperties(CLElement element, ConstraintReference reference) throws CLParsingException {
        if (!(element instanceof CLObject)) {
            return;
        }
        CLObject obj = (CLObject)element;
        TypedBundle bundle = new TypedBundle();
        ArrayList<String> constraints = obj.names();
        if (constraints == null) {
            return;
        }
        Iterator<String> iterator = constraints.iterator();
        block14: while (iterator.hasNext()) {
            String constraintName;
            switch (constraintName = iterator.next()) {
                case "pathArc": {
                    String val = obj.getString(constraintName);
                    int ord = ConstraintSetParser.indexOf(val, "none", "startVertical", "startHorizontal", "flip");
                    if (ord == -1) {
                        System.err.println(obj.getLine() + " pathArc = '" + val + "'");
                        break;
                    }
                    bundle.add(607, ord);
                    break;
                }
                case "relativeTo": {
                    bundle.add(605, obj.getString(constraintName));
                    break;
                }
                case "easing": {
                    bundle.add(603, obj.getString(constraintName));
                    break;
                }
                case "stagger": {
                    bundle.add(600, obj.getFloat(constraintName));
                    break;
                }
                case "quantize": {
                    CLElement quant = obj.get(constraintName);
                    if (quant instanceof CLArray) {
                        CLArray array = (CLArray)quant;
                        int len = array.size();
                        if (len <= 0) continue block14;
                        bundle.add(610, array.getInt(0));
                        if (len <= 1) continue block14;
                        bundle.add(611, array.getString(1));
                        if (len <= 2) continue block14;
                        bundle.add(602, array.getFloat(2));
                        break;
                    }
                    bundle.add(610, obj.getInt(constraintName));
                }
            }
        }
        reference.mMotionProperties = bundle;
    }

    static void parseConstraint(State state, LayoutVariables layoutVariables, CLObject element, ConstraintReference reference, String constraintName) throws CLParsingException {
        CLArray constraint = element.getArrayOrNull(constraintName);
        if (constraint != null && constraint.size() > 1) {
            CLElement arg2;
            String target = constraint.getString(0);
            String anchor = constraint.getStringOrNull(1);
            float margin = 0.0f;
            float marginGone = 0.0f;
            if (constraint.size() > 2) {
                arg2 = constraint.getOrNull(2);
                margin = layoutVariables.get(arg2);
                margin = state.convertDimension(Float.valueOf(state.getDpToPixel().toPixels(margin)));
            }
            if (constraint.size() > 3) {
                arg2 = constraint.getOrNull(3);
                marginGone = layoutVariables.get(arg2);
                marginGone = state.convertDimension(Float.valueOf(state.getDpToPixel().toPixels(margin)));
            }
            ConstraintReference targetReference = target.equals("parent") ? state.constraints(State.PARENT) : state.constraints(target);
            block10 : switch (constraintName) {
                case "circular": {
                    float angle = layoutVariables.get(constraint.get(1));
                    reference.circularConstraint(targetReference, angle, 0.0f);
                    break;
                }
                case "start": {
                    switch (anchor) {
                        case "start": {
                            reference.startToStart(targetReference);
                            break;
                        }
                        case "end": {
                            reference.startToEnd(targetReference);
                        }
                    }
                    break;
                }
                case "end": {
                    switch (anchor) {
                        case "start": {
                            reference.endToStart(targetReference);
                            break;
                        }
                        case "end": {
                            reference.endToEnd(targetReference);
                        }
                    }
                    break;
                }
                case "left": {
                    switch (anchor) {
                        case "left": {
                            reference.leftToLeft(targetReference);
                            break;
                        }
                        case "right": {
                            reference.leftToRight(targetReference);
                        }
                    }
                    break;
                }
                case "right": {
                    switch (anchor) {
                        case "left": {
                            reference.rightToLeft(targetReference);
                            break;
                        }
                        case "right": {
                            reference.rightToRight(targetReference);
                        }
                    }
                    break;
                }
                case "top": {
                    switch (anchor) {
                        case "top": {
                            reference.topToTop(targetReference);
                            break;
                        }
                        case "bottom": {
                            reference.topToBottom(targetReference);
                        }
                    }
                    break;
                }
                case "bottom": {
                    switch (anchor) {
                        case "top": {
                            reference.bottomToTop(targetReference);
                            break;
                        }
                        case "bottom": {
                            reference.bottomToBottom(targetReference);
                        }
                    }
                    break;
                }
                case "baseline": {
                    switch (anchor) {
                        case "baseline": {
                            state.baselineNeededFor(reference.getKey());
                            state.baselineNeededFor(targetReference.getKey());
                            reference.baselineToBaseline(targetReference);
                            break block10;
                        }
                        case "top": {
                            state.baselineNeededFor(reference.getKey());
                            state.baselineNeededFor(targetReference.getKey());
                            reference.baselineToTop(targetReference);
                            break block10;
                        }
                        case "bottom": {
                            state.baselineNeededFor(reference.getKey());
                            state.baselineNeededFor(targetReference.getKey());
                            reference.baselineToBottom(targetReference);
                        }
                    }
                }
            }
            reference.margin(Float.valueOf(margin)).marginGone(Float.valueOf(marginGone));
        } else {
            String target = element.getStringOrNull(constraintName);
            if (target != null) {
                ConstraintReference targetReference = target.equals("parent") ? state.constraints(State.PARENT) : state.constraints(target);
                switch (constraintName) {
                    case "start": {
                        reference.startToStart(targetReference);
                        break;
                    }
                    case "end": {
                        reference.endToEnd(targetReference);
                        break;
                    }
                    case "top": {
                        reference.topToTop(targetReference);
                        break;
                    }
                    case "bottom": {
                        reference.bottomToBottom(targetReference);
                        break;
                    }
                    case "baseline": {
                        state.baselineNeededFor(reference.getKey());
                        state.baselineNeededFor(targetReference.getKey());
                        reference.baselineToBaseline(targetReference);
                    }
                }
            }
        }
    }

    static Dimension parseDimensionMode(String dimensionString) {
        Dimension dimension = Dimension.createFixed(0);
        switch (dimensionString) {
            case "wrap": {
                dimension = Dimension.createWrap();
                break;
            }
            case "preferWrap": {
                dimension = Dimension.createSuggested(Dimension.WRAP_DIMENSION);
                break;
            }
            case "spread": {
                dimension = Dimension.createSuggested(Dimension.SPREAD_DIMENSION);
                break;
            }
            case "parent": {
                dimension = Dimension.createParent();
                break;
            }
            default: {
                if (dimensionString.endsWith("%")) {
                    String percentString = dimensionString.substring(0, dimensionString.indexOf(37));
                    float percentValue = Float.parseFloat(percentString) / 100.0f;
                    dimension = Dimension.createPercent(0, percentValue).suggested(0);
                    break;
                }
                if (!dimensionString.contains(":")) break;
                dimension = Dimension.createRatio(dimensionString).suggested(Dimension.SPREAD_DIMENSION);
            }
        }
        return dimension;
    }

    static Dimension parseDimension(CLObject element, String constraintName, State state, CorePixelDp dpToPixels) throws CLParsingException {
        CLElement dimensionElement = element.get(constraintName);
        Dimension dimension = Dimension.createFixed(0);
        if (dimensionElement instanceof CLString) {
            dimension = ConstraintSetParser.parseDimensionMode(dimensionElement.content());
        } else if (dimensionElement instanceof CLNumber) {
            dimension = Dimension.createFixed(state.convertDimension(Float.valueOf(dpToPixels.toPixels(element.getFloat(constraintName)))));
        } else if (dimensionElement instanceof CLObject) {
            CLElement maxEl;
            CLElement minEl;
            CLObject obj = (CLObject)dimensionElement;
            String mode = obj.getStringOrNull("value");
            if (mode != null) {
                dimension = ConstraintSetParser.parseDimensionMode(mode);
            }
            if ((minEl = obj.getOrNull("min")) != null) {
                if (minEl instanceof CLNumber) {
                    float min = ((CLNumber)minEl).getFloat();
                    dimension.min(state.convertDimension(Float.valueOf(dpToPixels.toPixels(min))));
                } else if (minEl instanceof CLString) {
                    dimension.min(Dimension.WRAP_DIMENSION);
                }
            }
            if ((maxEl = obj.getOrNull("max")) != null) {
                if (maxEl instanceof CLNumber) {
                    float max = ((CLNumber)maxEl).getFloat();
                    dimension.max(state.convertDimension(Float.valueOf(dpToPixels.toPixels(max))));
                } else if (maxEl instanceof CLString) {
                    dimension.max(Dimension.WRAP_DIMENSION);
                }
            }
        }
        return dimension;
    }

    static long parseColorString(String value) {
        Object str = value;
        if (((String)str).startsWith("#")) {
            if (((String)(str = ((String)str).substring(1))).length() == 6) {
                str = "FF" + (String)str;
            }
            return Long.parseLong((String)str, 16);
        }
        return -1L;
    }

    static String lookForType(CLObject element) throws CLParsingException {
        ArrayList<String> constraints = element.names();
        for (String constraintName : constraints) {
            if (!constraintName.equals("type")) continue;
            return element.getString("type");
        }
        return null;
    }

    public static enum MotionLayoutDebugFlags {
        NONE,
        SHOW_ALL,
        UNKNOWN;

    }

    static class OverrideValue
    implements GeneratedValue {
        float mValue;

        OverrideValue(float value) {
            this.mValue = value;
        }

        @Override
        public float value() {
            return this.mValue;
        }
    }

    static class FiniteGenerator
    implements GeneratedValue {
        float mFrom = 0.0f;
        float mTo = 0.0f;
        float mStep = 0.0f;
        boolean mStop = false;
        String mPrefix;
        String mPostfix;
        float mCurrent = 0.0f;
        float mInitial;
        float mMax;

        FiniteGenerator(float from, float to, float step, String prefix, String postfix) {
            this.mFrom = from;
            this.mTo = to;
            this.mStep = step;
            this.mPrefix = prefix == null ? "" : prefix;
            this.mPostfix = postfix == null ? "" : postfix;
            this.mMax = to;
            this.mInitial = from;
        }

        @Override
        public float value() {
            if (this.mCurrent >= this.mMax) {
                this.mStop = true;
            }
            if (!this.mStop) {
                this.mCurrent += this.mStep;
            }
            return this.mCurrent;
        }

        public ArrayList<String> array() {
            ArrayList<String> array = new ArrayList<String>();
            int value = (int)this.mInitial;
            int maxInt = (int)this.mMax;
            for (int i = value; i <= maxInt; ++i) {
                array.add(this.mPrefix + value + this.mPostfix);
                value = (int)((float)value + this.mStep);
            }
            return array;
        }
    }

    static class Generator
    implements GeneratedValue {
        float mStart = 0.0f;
        float mIncrementBy = 0.0f;
        float mCurrent = 0.0f;
        boolean mStop = false;

        Generator(float start, float incrementBy) {
            this.mStart = start;
            this.mIncrementBy = incrementBy;
            this.mCurrent = start;
        }

        @Override
        public float value() {
            if (!this.mStop) {
                this.mCurrent += this.mIncrementBy;
            }
            return this.mCurrent;
        }
    }

    static interface GeneratedValue {
        public float value();
    }

    public static class LayoutVariables {
        HashMap<String, Integer> mMargins = new HashMap();
        HashMap<String, GeneratedValue> mGenerators = new HashMap();
        HashMap<String, ArrayList<String>> mArrayIds = new HashMap();

        void put(String elementName, int element) {
            this.mMargins.put(elementName, element);
        }

        void put(String elementName, float start, float incrementBy) {
            if (this.mGenerators.containsKey(elementName) && this.mGenerators.get(elementName) instanceof OverrideValue) {
                return;
            }
            this.mGenerators.put(elementName, new Generator(start, incrementBy));
        }

        void put(String elementName, float from, float to, float step, String prefix, String postfix) {
            if (this.mGenerators.containsKey(elementName) && this.mGenerators.get(elementName) instanceof OverrideValue) {
                return;
            }
            FiniteGenerator generator = new FiniteGenerator(from, to, step, prefix, postfix);
            this.mGenerators.put(elementName, generator);
            this.mArrayIds.put(elementName, generator.array());
        }

        public void putOverride(String elementName, float value) {
            OverrideValue generator = new OverrideValue(value);
            this.mGenerators.put(elementName, generator);
        }

        float get(Object elementName) {
            if (elementName instanceof CLString) {
                String stringValue = ((CLString)elementName).content();
                if (this.mGenerators.containsKey(stringValue)) {
                    return this.mGenerators.get(stringValue).value();
                }
                if (this.mMargins.containsKey(stringValue)) {
                    return this.mMargins.get(stringValue).floatValue();
                }
            } else if (elementName instanceof CLNumber) {
                return ((CLNumber)elementName).getFloat();
            }
            return 0.0f;
        }

        ArrayList<String> getList(String elementName) {
            if (this.mArrayIds.containsKey(elementName)) {
                return this.mArrayIds.get(elementName);
            }
            return null;
        }

        void put(String elementName, ArrayList<String> elements) {
            this.mArrayIds.put(elementName, elements);
        }
    }

    public static class DesignElement {
        String mId;
        String mType;
        HashMap<String, String> mParams;

        public String getId() {
            return this.mId;
        }

        public String getType() {
            return this.mType;
        }

        public HashMap<String, String> getParams() {
            return this.mParams;
        }

        DesignElement(String id, String type, HashMap<String, String> params) {
            this.mId = id;
            this.mType = type;
            this.mParams = params;
        }
    }
}

