/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.HashMap;
import java.util.Set;

public class WidgetFrame {
    private static final boolean OLD_SYSTEM = true;
    public ConstraintWidget widget = null;
    public int left = 0;
    public int top = 0;
    public int right = 0;
    public int bottom = 0;
    public float pivotX = Float.NaN;
    public float pivotY = Float.NaN;
    public float rotationX = Float.NaN;
    public float rotationY = Float.NaN;
    public float rotationZ = Float.NaN;
    public float translationX = Float.NaN;
    public float translationY = Float.NaN;
    public float translationZ = Float.NaN;
    public static float phone_orientation = Float.NaN;
    public float scaleX = Float.NaN;
    public float scaleY = Float.NaN;
    public float alpha = Float.NaN;
    public float interpolatedPos = Float.NaN;
    public int visibility = 0;
    public final HashMap<String, CustomVariable> mCustom = new HashMap();
    public String name = null;

    public int width() {
        return Math.max(0, this.right - this.left);
    }

    public int height() {
        return Math.max(0, this.bottom - this.top);
    }

    public WidgetFrame() {
    }

    public WidgetFrame(ConstraintWidget widget) {
        this.widget = widget;
    }

    public WidgetFrame(WidgetFrame frame) {
        this.widget = frame.widget;
        this.left = frame.left;
        this.top = frame.top;
        this.right = frame.right;
        this.bottom = frame.bottom;
        this.updateAttributes(frame);
    }

    public void updateAttributes(WidgetFrame frame) {
        this.pivotX = frame.pivotX;
        this.pivotY = frame.pivotY;
        this.rotationX = frame.rotationX;
        this.rotationY = frame.rotationY;
        this.rotationZ = frame.rotationZ;
        this.translationX = frame.translationX;
        this.translationY = frame.translationY;
        this.translationZ = frame.translationZ;
        this.scaleX = frame.scaleX;
        this.scaleY = frame.scaleY;
        this.alpha = frame.alpha;
        this.visibility = frame.visibility;
        this.mCustom.clear();
        if (frame != null) {
            for (CustomVariable c : frame.mCustom.values()) {
                this.mCustom.put(c.getName(), c.copy());
            }
        }
    }

    public boolean isDefaultTransform() {
        return Float.isNaN(this.rotationX) && Float.isNaN(this.rotationY) && Float.isNaN(this.rotationZ) && Float.isNaN(this.translationX) && Float.isNaN(this.translationY) && Float.isNaN(this.translationZ) && Float.isNaN(this.scaleX) && Float.isNaN(this.scaleY) && Float.isNaN(this.alpha);
    }

    public static void interpolate(int parentWidth, int parentHeight, WidgetFrame frame, WidgetFrame start, WidgetFrame end, Transition transition, float progress) {
        int frameNumber = (int)(progress * 100.0f);
        int startX = start.left;
        int startY = start.top;
        int endX = end.left;
        int endY = end.top;
        int startWidth = start.right - start.left;
        int startHeight = start.bottom - start.top;
        int endWidth = end.right - end.left;
        int endHeight = end.bottom - end.top;
        float progressPosition = progress;
        float startAlpha = start.alpha;
        float endAlpha = end.alpha;
        if (start.visibility == 8) {
            startX = (int)((float)startX - (float)endWidth / 2.0f);
            startY = (int)((float)startY - (float)endHeight / 2.0f);
            startWidth = endWidth;
            startHeight = endHeight;
            if (Float.isNaN(startAlpha)) {
                startAlpha = 0.0f;
            }
        }
        if (end.visibility == 8) {
            endX = (int)((float)endX - (float)startWidth / 2.0f);
            endY = (int)((float)endY - (float)startHeight / 2.0f);
            endWidth = startWidth;
            endHeight = startHeight;
            if (Float.isNaN(endAlpha)) {
                endAlpha = 0.0f;
            }
        }
        if (Float.isNaN(startAlpha) && !Float.isNaN(endAlpha)) {
            startAlpha = 1.0f;
        }
        if (!Float.isNaN(startAlpha) && Float.isNaN(endAlpha)) {
            endAlpha = 1.0f;
        }
        if (frame.widget != null && transition.hasPositionKeyframes()) {
            Transition.KeyPosition lastPosition;
            Transition.KeyPosition firstPosition = transition.findPreviousPosition(frame.widget.stringId, frameNumber);
            if (firstPosition == (lastPosition = transition.findNextPosition(frame.widget.stringId, frameNumber))) {
                lastPosition = null;
            }
            int interpolateStartFrame = 0;
            int interpolateEndFrame = 100;
            if (firstPosition != null) {
                startX = (int)(firstPosition.x * (float)parentWidth);
                startY = (int)(firstPosition.y * (float)parentHeight);
                interpolateStartFrame = firstPosition.frame;
            }
            if (lastPosition != null) {
                endX = (int)(lastPosition.x * (float)parentWidth);
                endY = (int)(lastPosition.y * (float)parentHeight);
                interpolateEndFrame = lastPosition.frame;
            }
            progressPosition = (progress * 100.0f - (float)interpolateStartFrame) / (float)(interpolateEndFrame - interpolateStartFrame);
        }
        frame.widget = start.widget;
        frame.left = (int)((float)startX + progressPosition * (float)(endX - startX));
        frame.top = (int)((float)startY + progressPosition * (float)(endY - startY));
        int width = (int)((1.0f - progress) * (float)startWidth + progress * (float)endWidth);
        int height = (int)((1.0f - progress) * (float)startHeight + progress * (float)endHeight);
        frame.right = frame.left + width;
        frame.bottom = frame.top + height;
        frame.pivotX = WidgetFrame.interpolate(start.pivotX, end.pivotX, 0.5f, progress);
        frame.pivotY = WidgetFrame.interpolate(start.pivotY, end.pivotY, 0.5f, progress);
        frame.rotationX = WidgetFrame.interpolate(start.rotationX, end.rotationX, 0.0f, progress);
        frame.rotationY = WidgetFrame.interpolate(start.rotationY, end.rotationY, 0.0f, progress);
        frame.rotationZ = WidgetFrame.interpolate(start.rotationZ, end.rotationZ, 0.0f, progress);
        frame.scaleX = WidgetFrame.interpolate(start.scaleX, end.scaleX, 1.0f, progress);
        frame.scaleY = WidgetFrame.interpolate(start.scaleY, end.scaleY, 1.0f, progress);
        frame.translationX = WidgetFrame.interpolate(start.translationX, end.translationX, 0.0f, progress);
        frame.translationY = WidgetFrame.interpolate(start.translationY, end.translationY, 0.0f, progress);
        frame.translationZ = WidgetFrame.interpolate(start.translationZ, end.translationZ, 0.0f, progress);
        frame.alpha = WidgetFrame.interpolate(startAlpha, endAlpha, 1.0f, progress);
    }

    private static float interpolate(float start, float end, float defaultValue, float progress) {
        boolean isStartUnset = Float.isNaN(start);
        boolean isEndUnset = Float.isNaN(end);
        if (isStartUnset && isEndUnset) {
            return Float.NaN;
        }
        if (isStartUnset) {
            start = defaultValue;
        }
        if (isEndUnset) {
            end = defaultValue;
        }
        return start + progress * (end - start);
    }

    public float centerX() {
        return (float)this.left + (float)(this.right - this.left) / 2.0f;
    }

    public float centerY() {
        return (float)this.top + (float)(this.bottom - this.top) / 2.0f;
    }

    public WidgetFrame update() {
        if (this.widget != null) {
            this.left = this.widget.getLeft();
            this.top = this.widget.getTop();
            this.right = this.widget.getRight();
            this.bottom = this.widget.getBottom();
            WidgetFrame frame = this.widget.frame;
            this.updateAttributes(frame);
        }
        return this;
    }

    public WidgetFrame update(ConstraintWidget widget) {
        if (widget == null) {
            return this;
        }
        this.widget = widget;
        this.update();
        return this;
    }

    public void addCustomColor(String name, int color) {
        this.setCustomAttribute(name, 902, color);
    }

    public int getCustomColor(String name) {
        if (this.mCustom.containsKey(name)) {
            int color = this.mCustom.get(name).getColorValue();
            return color;
        }
        return -21880;
    }

    public void addCustomFloat(String name, float value) {
        this.setCustomAttribute(name, 901, value);
    }

    public float getCustomFloat(String name) {
        if (this.mCustom.containsKey(name)) {
            return this.mCustom.get(name).getFloatValue();
        }
        return Float.NaN;
    }

    public void setCustomAttribute(String name, int type, float value) {
        if (this.mCustom.containsKey(name)) {
            this.mCustom.get(name).setFloatValue(value);
        } else {
            this.mCustom.put(name, new CustomVariable(name, type, value));
        }
    }

    public void setCustomAttribute(String name, int type, int value) {
        if (this.mCustom.containsKey(name)) {
            this.mCustom.get(name).setIntValue(value);
        } else {
            this.mCustom.put(name, new CustomVariable(name, type, value));
        }
    }

    public void setCustomAttribute(String name, int type, boolean value) {
        if (this.mCustom.containsKey(name)) {
            this.mCustom.get(name).setBooleanValue(value);
        } else {
            this.mCustom.put(name, new CustomVariable(name, type, value));
        }
    }

    public void setCustomAttribute(String name, int type, String value) {
        if (this.mCustom.containsKey(name)) {
            this.mCustom.get(name).setStringValue(value);
        } else {
            this.mCustom.put(name, new CustomVariable(name, type, value));
        }
    }

    public CustomVariable getCustomAttribute(String name) {
        return this.mCustom.get(name);
    }

    public Set<String> getCustomAttributeNames() {
        return this.mCustom.keySet();
    }

    public boolean setValue(String key, CLElement value) throws CLParsingException {
        switch (key) {
            case "pivotX": {
                this.pivotX = value.getFloat();
                break;
            }
            case "pivotY": {
                this.pivotY = value.getFloat();
                break;
            }
            case "rotationX": {
                this.rotationX = value.getFloat();
                break;
            }
            case "rotationY": {
                this.rotationY = value.getFloat();
                break;
            }
            case "rotationZ": {
                this.rotationZ = value.getFloat();
                break;
            }
            case "translationX": {
                this.translationX = value.getFloat();
                break;
            }
            case "translationY": {
                this.translationY = value.getFloat();
                break;
            }
            case "translationZ": {
                this.translationZ = value.getFloat();
                break;
            }
            case "scaleX": {
                this.scaleX = value.getFloat();
                break;
            }
            case "scaleY": {
                this.scaleY = value.getFloat();
                break;
            }
            case "alpha": {
                this.alpha = value.getFloat();
                break;
            }
            case "interpolatedPos": {
                this.interpolatedPos = value.getFloat();
                break;
            }
            case "phone_orientation": {
                phone_orientation = value.getFloat();
                break;
            }
            case "top": {
                this.top = value.getInt();
                break;
            }
            case "left": {
                this.left = value.getInt();
                break;
            }
            case "right": {
                this.right = value.getInt();
                break;
            }
            case "bottom": {
                this.bottom = value.getInt();
                break;
            }
            case "custom": {
                this.parseCustom(value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void parseCustom(CLElement custom) throws CLParsingException {
        CLObject obj = (CLObject)custom;
        int n = obj.size();
        for (int i = 0; i < n; ++i) {
            CLElement tmp = obj.get(i);
            CLKey k = (CLKey)tmp;
            String name = k.content();
            CLElement v = k.getValue();
            String vStr = v.content();
            if (vStr.matches("#[0-9a-fA-F]+")) {
                int color = Integer.parseInt(vStr.substring(1), 16);
                this.setCustomAttribute(k.content(), 902, color);
                continue;
            }
            if (v instanceof CLNumber) {
                this.setCustomAttribute(k.content(), 901, v.getFloat());
                continue;
            }
            this.setCustomAttribute(k.content(), 903, vStr);
        }
    }

    public StringBuilder serialize(StringBuilder ret) {
        return this.serialize(ret, false);
    }

    public StringBuilder serialize(StringBuilder ret, boolean sendPhoneOrientation) {
        WidgetFrame frame = this;
        ret.append("{\n");
        WidgetFrame.add(ret, "left", frame.left);
        WidgetFrame.add(ret, "top", frame.top);
        WidgetFrame.add(ret, "right", frame.right);
        WidgetFrame.add(ret, "bottom", frame.bottom);
        WidgetFrame.add(ret, "pivotX", frame.pivotX);
        WidgetFrame.add(ret, "pivotY", frame.pivotY);
        WidgetFrame.add(ret, "rotationX", frame.rotationX);
        WidgetFrame.add(ret, "rotationY", frame.rotationY);
        WidgetFrame.add(ret, "rotationZ", frame.rotationZ);
        WidgetFrame.add(ret, "translationX", frame.translationX);
        WidgetFrame.add(ret, "translationY", frame.translationY);
        WidgetFrame.add(ret, "translationZ", frame.translationZ);
        WidgetFrame.add(ret, "scaleX", frame.scaleX);
        WidgetFrame.add(ret, "scaleY", frame.scaleY);
        WidgetFrame.add(ret, "alpha", frame.alpha);
        WidgetFrame.add(ret, "visibility", frame.left);
        WidgetFrame.add(ret, "interpolatedPos", frame.interpolatedPos);
        if (sendPhoneOrientation) {
            WidgetFrame.add(ret, "phone_orientation", phone_orientation);
        }
        if (sendPhoneOrientation) {
            WidgetFrame.add(ret, "phone_orientation", phone_orientation);
        }
        if (frame.mCustom.size() != 0) {
            ret.append("custom : {\n");
            for (String s : frame.mCustom.keySet()) {
                CustomVariable value = frame.mCustom.get(s);
                ret.append(s);
                ret.append(": ");
                switch (value.getType()) {
                    case 900: {
                        ret.append(value.getIntegerValue());
                        ret.append(",\n");
                        break;
                    }
                    case 901: 
                    case 905: {
                        ret.append(value.getFloatValue());
                        ret.append(",\n");
                        break;
                    }
                    case 902: {
                        ret.append("'");
                        ret.append(CustomVariable.colorString(value.getIntegerValue()));
                        ret.append("',\n");
                        break;
                    }
                    case 903: {
                        ret.append("'");
                        ret.append(value.getStringValue());
                        ret.append("',\n");
                        break;
                    }
                    case 904: {
                        ret.append("'");
                        ret.append(value.getBooleanValue());
                        ret.append("',\n");
                    }
                }
            }
            ret.append("}\n");
        }
        ret.append("}\n");
        return ret;
    }

    private static void add(StringBuilder s, String title, int value) {
        s.append(title);
        s.append(": ");
        s.append(value);
        s.append(",\n");
    }

    private static void add(StringBuilder s, String title, float value) {
        if (Float.isNaN(value)) {
            return;
        }
        s.append(title);
        s.append(": ");
        s.append(value);
        s.append(",\n");
    }

    void printCustomAttributes() {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String ss = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName();
        ss = ss + " " + this.hashCode() % 1000;
        ss = this.widget != null ? ss + "/" + this.widget.hashCode() % 1000 + " " : ss + "/NULL ";
        if (this.mCustom != null) {
            for (String key : this.mCustom.keySet()) {
                System.out.println(ss + this.mCustom.get(key).toString());
            }
        }
    }

    void logv(String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String ss = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName();
        ss = ss + " " + this.hashCode() % 1000;
        ss = this.widget != null ? ss + "/" + this.widget.hashCode() % 1000 : ss + "/NULL";
        System.out.println(ss + " " + str);
    }
}

