/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

final class Pools {
    private static final boolean DEBUG = false;

    private Pools() {
    }

    static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        public T acquire() {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance = this.mPool[lastPooledIndex];
                this.mPool[lastPooledIndex] = null;
                --this.mPoolSize;
                return (T)instance;
            }
            return null;
        }

        @Override
        public boolean release(T instance) {
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = instance;
                ++this.mPoolSize;
                return true;
            }
            return false;
        }

        @Override
        public void releaseAll(T[] variables, int count) {
            if (count > variables.length) {
                count = variables.length;
            }
            for (int i = 0; i < count; ++i) {
                T instance = variables[i];
                if (this.mPoolSize >= this.mPool.length) continue;
                this.mPool[this.mPoolSize] = instance;
                ++this.mPoolSize;
            }
        }

        private boolean isInPool(T instance) {
            for (int i = 0; i < this.mPoolSize; ++i) {
                if (this.mPool[i] != instance) continue;
                return true;
            }
            return false;
        }
    }

    static interface Pool<T> {
        public T acquire();

        public boolean release(T var1);

        public void releaseAll(T[] var1, int var2);
    }
}

